class star
{
  //variables that are part of the object
  int m_xPos = 0; 
  int m_yPos = 0;

  //empty constructor
  star()
  {
  }

  //draw the star
  void drawMe()
  {
    float longLength;
    float shortOffset;
    longLength = 40;
    shortOffset = 20;

    //main axis
    strokeWeight(2);  
    line(m_xPos-longLength, m_yPos, m_xPos+longLength, m_yPos);
    line(m_xPos, m_yPos+longLength, m_xPos, m_yPos-longLength);

    strokeWeight(1);
    line(m_xPos+shortOffset, m_yPos+shortOffset, m_xPos-shortOffset, m_yPos-shortOffset);
    line(m_xPos-shortOffset, m_yPos+shortOffset, m_xPos+shortOffset, m_yPos-shortOffset);
  }

  //change the star's position
  void move(int x, int y)
  {
    m_xPos = x;
    m_yPos = y;
  }
  
  void moveDown(int shiftY)
  
  {
    m_yPos += shiftY;
  }
}

//For example using single object
star gStar1 = new star();

//Example using an array of objects
star [] gStarList = new star[10];

void setup()
{
  frameRate(60);
  size(600, 600);
  background(255);
  smooth();
  
  for(int i =0; i<10; i++)
  {
    gStarList[i] = new star();
    gStarList[i].move(20+i*60, 50);
  }
}

void draw()
{

  background(255);
  
  //THIS IS AN EXAMPLE WITH A SINGLE OBJECT
  //work with the instance of star, the object gStar1
//  gStar1.move(frameCount % width, 150);
//  gStar1.drawMe();
 
 
 
  //THIS IS AN EXAMPLE USING AN ARRAY OF OBJECTS 
  //could have many more star objects that were varied independently

  for(int i =0; i<10; i++)
  {
    gStarList[i].moveDown(i); 
    gStarList[i].drawMe();
  }

 
}
