/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.AmbiguousMember;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.ClassNotFound;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.MemberDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.ContextEnvironment;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.IdentifierExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.InStatMember;
import edu.ucdavis.jr.trans.sun.tools.tree.InlineMethodExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.InlineNewInstanceExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.LocalMember;
import edu.ucdavis.jr.trans.sun.tools.tree.LoopInterface;
import edu.ucdavis.jr.trans.sun.tools.tree.Node;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.ThisExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.UplevelReference;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.util.ArrayList;
import java.util.Vector;

public class Context
implements Constants {
    Context prev;
    Node node;
    int varNumber;
    LocalMember locals;
    LocalMember classes;
    MemberDefinition field;
    int scopeNumber;
    int frameNumber;
    private boolean _inniStatic = false;

    public Context(Context context, MemberDefinition memberDefinition) {
        this.field = memberDefinition;
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = context;
            this.locals = context.locals;
            this.classes = context.classes;
            if (memberDefinition != null && (memberDefinition.isVariable() || memberDefinition.isInitializer())) {
                this.frameNumber = context.frameNumber;
                this.scopeNumber = context.scopeNumber + 1;
            } else {
                this.frameNumber = context.scopeNumber + 1;
                this.scopeNumber = this.frameNumber + 1;
            }
            this.varNumber = context.varNumber;
            this._inniStatic = context._inniStatic;
        }
    }

    public Context(Context context, ClassDefinition classDefinition) {
        this(context, (MemberDefinition)null);
    }

    public Context(Context context, Node node) {
        if (context == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = context;
            this.locals = context.locals;
            this.classes = context.classes;
            this.varNumber = context.varNumber;
            this.field = context.field;
            this.frameNumber = context.frameNumber;
            this.scopeNumber = context.scopeNumber + 1;
            this.node = node;
            this._inniStatic = context._inniStatic;
        }
    }

    public Context(Context context) {
        this(context, (Node)null);
    }

    public int declare(Environment environment, LocalMember localMember) {
        localMember.scopeNumber = this.scopeNumber;
        if (this.field == null && Constants.idThis.equals(localMember.getName())) {
            ++localMember.scopeNumber;
        }
        if (localMember.isInnerClass()) {
            localMember.prev = this.classes;
            this.classes = localMember;
            return 0;
        }
        if (localMember.isOp()) {
            this.checkOp(environment, localMember);
        }
        localMember.prev = this.locals;
        this.locals = localMember;
        localMember.number = this.varNumber;
        this.varNumber += localMember.getType().stackSize();
        return localMember.number;
    }

    public LocalMember getLocalField(Identifier identifier) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (identifier.equals(localMember.getName())) {
                return localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    public int getScopeNumber(ClassDefinition classDefinition) {
        Context context = this;
        while (context != null) {
            if (context.field != null && context.field.getClassDefinition() == classDefinition) {
                return context.frameNumber;
            }
            context = context.prev;
        }
        return -1;
    }

    private MemberDefinition getFieldCommon(Environment environment, Identifier identifier, boolean bl) throws AmbiguousMember, ClassNotFound {
        ClassDefinition classDefinition;
        LocalMember localMember = this.getLocalField(identifier);
        int n = localMember == null ? -2 : localMember.scopeNumber;
        for (ClassDefinition classDefinition2 = classDefinition = this.field.getClassDefinition(); classDefinition2 != null; classDefinition2 = classDefinition2.getOuterClass()) {
            MemberDefinition memberDefinition = classDefinition2.getVariable(environment, identifier, classDefinition);
            if (memberDefinition == null || this.getScopeNumber(classDefinition2) <= n || bl && memberDefinition.getClassDefinition() != classDefinition2) continue;
            return memberDefinition;
        }
        return localMember;
    }

    public int declareFieldNumber(MemberDefinition memberDefinition) {
        return this.declare(null, new LocalMember(memberDefinition));
    }

    public int getFieldNumber(MemberDefinition memberDefinition) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.getMember() == memberDefinition) {
                return localMember.number;
            }
            localMember = localMember.prev;
        }
        return -1;
    }

    public MemberDefinition getElement(int n) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.number == n) {
                MemberDefinition memberDefinition = localMember.getMember();
                return memberDefinition != null ? memberDefinition : localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    public LocalMember getLocalClass(Identifier identifier) {
        LocalMember localMember = this.classes;
        while (localMember != null) {
            if (identifier.equals(localMember.getName())) {
                return localMember;
            }
            localMember = localMember.prev;
        }
        return null;
    }

    private MemberDefinition getClassCommon(Environment environment, Identifier identifier, boolean bl) throws ClassNotFound {
        LocalMember localMember = this.getLocalClass(identifier);
        int n = localMember == null ? -2 : localMember.scopeNumber;
        for (ClassDefinition classDefinition = this.field.getClassDefinition(); classDefinition != null; classDefinition = classDefinition.getOuterClass()) {
            MemberDefinition memberDefinition = classDefinition.getInnerClass(environment, identifier);
            if (memberDefinition == null || this.getScopeNumber(classDefinition) <= n || bl && memberDefinition.getClassDefinition() != classDefinition) continue;
            return memberDefinition;
        }
        return localMember;
    }

    public final MemberDefinition getField(Environment environment, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(environment, identifier, false);
    }

    public void gatherPotentialOps(Identifier identifier, Vector vector) {
        Constants constants = this.locals;
        while (constants != null) {
            if (identifier.equals(((MemberDefinition)constants).getName()) && ((MemberDefinition)constants).isOp()) {
                vector.add(constants);
            }
            constants = ((LocalMember)constants).prev;
        }
        for (Constants constants2 = constants = this.field.getClassDefinition(); constants2 != null; constants2 = ((ClassDefinition)constants2).getOuterClass()) {
            ((ClassDefinition)constants2).gatherPotentialOps(identifier, vector);
        }
    }

    public final MemberDefinition getApparentField(Environment environment, Identifier identifier) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(environment, identifier, true);
    }

    public boolean isInScope(LocalMember localMember) {
        LocalMember localMember2 = this.locals;
        while (localMember2 != null) {
            if (localMember == localMember2) {
                return true;
            }
            localMember2 = localMember2.prev;
        }
        return false;
    }

    public UplevelReference noteReference(Environment environment, LocalMember localMember) {
        int n = !this.isInScope(localMember) ? -1 : localMember.scopeNumber;
        UplevelReference uplevelReference = null;
        int n2 = -1;
        Context context = this;
        while (context != null) {
            if (n2 != context.frameNumber) {
                n2 = context.frameNumber;
                if (n >= n2) break;
                ClassDefinition classDefinition = context.field.getClassDefinition();
                UplevelReference uplevelReference2 = classDefinition.getReference(localMember);
                uplevelReference2.noteReference(environment, context);
                if (uplevelReference == null) {
                    uplevelReference = uplevelReference2;
                }
            }
            context = context.prev;
        }
        return uplevelReference;
    }

    public Expression makeReference(Environment environment, LocalMember localMember) {
        UplevelReference uplevelReference = this.noteReference(environment, localMember);
        if (uplevelReference != null) {
            return uplevelReference.makeLocalReference(environment, this);
        }
        if (Constants.idThis.equals(localMember.getName())) {
            return new ThisExpression(0L, null, localMember);
        }
        return new IdentifierExpression(0L, localMember);
    }

    public Expression findOuterLink(Environment environment, long l, MemberDefinition memberDefinition) {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2 = memberDefinition.getClassDefinition();
        ClassDefinition classDefinition3 = memberDefinition.isStatic() ? null : (!memberDefinition.isConstructor() ? classDefinition2 : (classDefinition = classDefinition2.isTopLevel() ? null : classDefinition2.getOuterClass()));
        if (classDefinition == null) {
            return null;
        }
        return this.findOuterLink(environment, l, classDefinition, memberDefinition, false);
    }

    private static boolean match(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        try {
            return classDefinition == classDefinition2 || classDefinition2.implementedBy(environment, classDefinition.getClassDeclaration());
        }
        catch (ClassNotFound classNotFound) {
            return false;
        }
    }

    public Expression findOuterLink(Environment environment, long l, ClassDefinition classDefinition, MemberDefinition memberDefinition, boolean bl) {
        Constants constants;
        if (this.field instanceof InStatMember) {
            return this.prev.findOuterLink(environment, l, classDefinition, memberDefinition, bl);
        }
        if (this.field.isStatic()) {
            Constants constants2;
            if (memberDefinition == null) {
                constants2 = classDefinition.getName().getFlatName().getName();
                environment.error(l, "undef.var", Identifier.lookup(constants2, Constants.idThis));
            } else if (memberDefinition.isConstructor()) {
                environment.error(l, "no.outer.arg", classDefinition, memberDefinition.getClassDeclaration());
            } else if (memberDefinition.isMethod()) {
                environment.error(l, "no.static.meth.access", memberDefinition, memberDefinition.getClassDeclaration());
            } else {
                environment.error(l, "no.static.field.access", memberDefinition.getName(), memberDefinition.getClassDeclaration());
            }
            constants2 = new ThisExpression(l, null, this);
            ((Expression)constants2).type = classDefinition.getType();
            return constants2;
        }
        LocalMember localMember = this.locals;
        Expression expression = null;
        LocalMember localMember2 = null;
        ClassDefinition classDefinition2 = null;
        ClassDefinition classDefinition3 = null;
        if (this.field.isConstructor()) {
            classDefinition3 = this.field.getClassDefinition();
        }
        if (!this.field.isMethod() && !this.field.isOp()) {
            classDefinition2 = this.field.getClassDefinition();
            expression = new ThisExpression(l, null, this);
        }
        while (true) {
            if (expression == null) {
                while (localMember != null && !Constants.idThis.equals(localMember.getName())) {
                    localMember = localMember.prev;
                }
                if (localMember == null) break;
                expression = new ThisExpression(l, null, localMember);
                classDefinition2 = localMember.getClassDefinition();
                localMember2 = localMember;
                localMember = localMember.prev;
            }
            if (classDefinition2 == classDefinition || !bl && Context.match(environment, classDefinition2, classDefinition)) break;
            constants = classDefinition2.findOuterMember();
            if (constants == null) {
                expression = null;
                continue;
            }
            ClassDefinition classDefinition4 = classDefinition2;
            classDefinition2 = classDefinition4.getOuterClass();
            if (classDefinition4 == classDefinition3) {
                Identifier identifier = ((MemberDefinition)constants).getName();
                IdentifierExpression identifierExpression = new IdentifierExpression(l, null, identifier);
                identifierExpression.bind(environment, this);
                expression = identifierExpression;
                continue;
            }
            expression = new FieldExpression(l, null, expression, (MemberDefinition)constants);
        }
        if (expression != null) {
            return expression;
        }
        if (memberDefinition == null) {
            constants = classDefinition.getName().getFlatName().getName();
            environment.error(l, "undef.var", Identifier.lookup((Identifier)constants, Constants.idThis));
        } else if (memberDefinition.isConstructor()) {
            environment.error(l, "no.outer.arg", classDefinition, memberDefinition.getClassDefinition());
        } else {
            environment.error(l, "no.static.field.access", memberDefinition, this.field);
        }
        constants = new ThisExpression(l, null, this);
        ((Expression)constants).type = classDefinition.getType();
        return constants;
    }

    public static boolean outerLinkExists(Environment environment, ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        while (!Context.match(environment, classDefinition2, classDefinition)) {
            if (classDefinition2.isTopLevel()) {
                return false;
            }
            classDefinition2 = classDefinition2.getOuterClass();
        }
        return true;
    }

    public ClassDefinition findScope(Environment environment, ClassDefinition classDefinition) {
        ClassDefinition classDefinition2;
        for (classDefinition2 = this.field.getClassDefinition(); classDefinition2 != null && !Context.match(environment, classDefinition2, classDefinition); classDefinition2 = classDefinition2.getOuterClass()) {
        }
        return classDefinition2;
    }

    Identifier resolveName(Environment environment, Identifier identifier) {
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(environment, identifier.getHead());
            if (identifier2.hasAmbigPrefix()) {
                identifier2.setLexicalName(identifier.getLexicalName());
                return identifier2;
            }
            if (!environment.classExists(identifier2)) {
                Identifier identifier3 = environment.resolvePackageQualifiedName(identifier);
                identifier3.setLexicalName(identifier.getLexicalName());
                return identifier3;
            }
            try {
                Identifier identifier4 = environment.getClassDefinition(identifier2).resolveInnerClass(environment, identifier.getTail());
                identifier4.setLexicalName(identifier.getLexicalName());
                return identifier4;
            }
            catch (ClassNotFound classNotFound) {
                Identifier identifier5 = Identifier.lookupInner(identifier2, identifier.getTail());
                identifier5.setLexicalName(identifier.getLexicalName());
                return identifier5;
            }
        }
        try {
            MemberDefinition memberDefinition = this.getClassCommon(environment, identifier, false);
            if (memberDefinition != null) {
                Identifier identifier6 = memberDefinition.getInnerClass().getName();
                identifier6.setLexicalName(identifier.getLexicalName());
                return identifier6;
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        Identifier identifier7 = environment.resolveName(identifier);
        identifier7.setLexicalName(identifier.getLexicalName());
        return identifier7;
    }

    public Identifier getApparentClassName(Environment environment, Identifier identifier) {
        Constants constants;
        if (identifier.isQualified()) {
            Identifier identifier2 = this.getApparentClassName(environment, identifier.getHead());
            return identifier2 == null ? Constants.idNull : Identifier.lookup(identifier2, identifier.getTail());
        }
        try {
            constants = this.getClassCommon(environment, identifier, true);
            if (constants != null) {
                return ((MemberDefinition)constants).getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        constants = this.field.getClassDefinition().getTopClass().getName();
        if (((Identifier)constants).getName().equals(identifier)) {
            return constants;
        }
        return Constants.idNull;
    }

    public void checkBackBranch(Environment environment, Statement statement, Vset vset, Vset vset2) {
        LocalMember localMember = this.locals;
        while (localMember != null) {
            if (localMember.isBlankFinal() && vset.testVarUnassigned(localMember.number) && !vset2.testVarUnassigned(localMember.number)) {
                environment.error(statement.where, "assign.to.blank.final.in.loop", localMember.getName());
            }
            localMember = localMember.prev;
        }
    }

    public boolean canReach(Environment environment, MemberDefinition memberDefinition) {
        return this.field.canReach(environment, memberDefinition);
    }

    public Context getLabelContext(Identifier identifier) {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node instanceof Statement && ((Statement)context.node).hasLabel(identifier)) {
                return context;
            }
            context = context.prev;
        }
        return null;
    }

    public Context getBreakContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 191: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public Context getContinueContext(Identifier identifier) {
        if (identifier != null) {
            return this.getLabelContext(identifier);
        }
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 191: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public String getJRLabel() {
        switch (this.node.op) {
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 191: {
                return ((LoopInterface)((Object)this.node)).getJRLabel();
            }
        }
        return null;
    }

    public CheckContext getReturnContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null && context.node.op == 47) {
                return (CheckContext)context;
            }
            context = context.prev;
        }
        return null;
    }

    public CheckContext getTryExitContext() {
        Context context = this;
        while (context != null && context.node != null && context.node.op != 47) {
            if (context.node.op == 101) {
                return (CheckContext)context;
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineContext() {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: 
                    case 151: {
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    Context getInlineMemberContext(MemberDefinition memberDefinition) {
        Context context = this;
        while (context != null) {
            if (context.node != null) {
                switch (context.node.op) {
                    case 150: {
                        if (!((InlineMethodExpression)context.node).field.equals(memberDefinition)) break;
                        return context;
                    }
                    case 151: {
                        if (!((InlineNewInstanceExpression)context.node).field.equals(memberDefinition)) break;
                        return context;
                    }
                }
            }
            context = context.prev;
        }
        return null;
    }

    public final Vset removeAdditionalVars(Vset vset) {
        return vset.removeAdditionalVars(this.varNumber);
    }

    public final int getVarNumber() {
        return this.varNumber;
    }

    public int getThisNumber() {
        LocalMember localMember = this.getLocalField(Constants.idThis);
        if (localMember != null && localMember.getClassDefinition() == this.field.getClassDefinition()) {
            return localMember.number;
        }
        return this.varNumber;
    }

    public final MemberDefinition getField() {
        return this.field;
    }

    public static Environment newEnvironment(Environment environment, Context context) {
        return new ContextEnvironment(environment, context);
    }

    public MemberDefinition matchOp(Environment environment, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        return this.matchOp(environment, identifier, typeArray, null);
    }

    public MemberDefinition matchOp(Environment environment, Identifier identifier, Type[] typeArray, Expression[] expressionArray) throws AmbiguousMember, ClassNotFound {
        Object object = null;
        ArrayList<Object> arrayList = null;
        Object object2 = this.locals;
        while (object2 != null) {
            if ((((MemberDefinition)object2).isOp() || ((MemberDefinition)object2).isCap()) && ((MemberDefinition)object2).getName().equals(identifier) && environment.isApplicable((MemberDefinition)object2, typeArray, expressionArray)) {
                if (object == null) {
                    object = object2;
                } else if (environment.isMoreSpecific((MemberDefinition)object2, (MemberDefinition)object)) {
                    object = object2;
                } else if (!environment.isMoreSpecific((MemberDefinition)object, (MemberDefinition)object2)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object2);
                }
            }
            object2 = ((LocalMember)object2).prev;
        }
        if (object != null && arrayList != null) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                MemberDefinition memberDefinition = (MemberDefinition)object2.next();
                if (environment.isMoreSpecific((MemberDefinition)object, memberDefinition)) continue;
                throw new AmbiguousMember((MemberDefinition)object, memberDefinition);
            }
        }
        return object;
    }

    public MemberDefinition matchOpReceive(Environment environment, Identifier identifier, Type[] typeArray) throws AmbiguousMember, ClassNotFound {
        Object object = null;
        ArrayList<Object> arrayList = null;
        Object object2 = this.locals;
        while (object2 != null) {
            if ((((MemberDefinition)object2).isOp() || ((MemberDefinition)object2).isCap()) && ((MemberDefinition)object2).getName().equals(identifier) && environment.isApplicableReceive((MemberDefinition)object2, typeArray)) {
                if (object == null) {
                    object = object2;
                } else if (environment.isMoreSpecific((MemberDefinition)object, (MemberDefinition)object2)) {
                    object = object2;
                } else if (!environment.isMoreSpecific((MemberDefinition)object2, (MemberDefinition)object)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object2);
                }
            }
            object2 = ((LocalMember)object2).prev;
        }
        if (object != null && arrayList != null) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                MemberDefinition memberDefinition = (MemberDefinition)object2.next();
                if (environment.isMoreSpecific(memberDefinition, (MemberDefinition)object)) continue;
                throw new AmbiguousMember(memberDefinition, (MemberDefinition)object);
            }
        }
        return object;
    }

    public boolean diagnoseMisOp(Environment environment, Identifier identifier, Expression[] expressionArray, Type[] typeArray, int n, long l) throws ClassNotFound {
        Type[] typeArray2 = new Type[1];
        boolean bl = false;
        int n2 = 0;
        while (n2 < typeArray.length) {
            String string;
            int n3 = this.diagnoseMisOp(environment, identifier, typeArray, n2, typeArray2);
            String string2 = string = identifier.equals(Constants.idInit) ? "constructor" : Constants.opNames[n];
            if (n3 == -2) {
                environment.error(l, "wrong.number.args", "operation");
                bl = true;
            }
            if (n3 < 0) break;
            int n4 = n3 >> 2;
            boolean bl2 = (n3 & 2) != 0;
            boolean bl3 = (n3 & 1) != 0;
            Type type = typeArray2[0];
            String string3 = "" + type;
            if (bl2) {
                environment.error(expressionArray[n4].where, "explicit.cast.needed", string, typeArray[n4], string3);
            } else {
                environment.error(expressionArray[n4].where, "incompatible.type", string, typeArray[n4], string3);
            }
            bl = true;
            n2 = n4 + 1;
        }
        return bl;
    }

    private int diagnoseMisOp(Environment environment, Identifier identifier, Type[] typeArray, int n, Type[] typeArray2) throws ClassNotFound {
        int[] nArray = new int[typeArray.length];
        Type[] typeArray3 = new Type[typeArray.length];
        if (this.getLocalField(identifier) == null) {
            return -1;
        }
        if (!this.diagnoseMisOp(environment, identifier, typeArray, n, nArray, typeArray3)) {
            return -2;
        }
        for (int i = n; i < typeArray.length; ++i) {
            if (nArray[i] >= 4) continue;
            typeArray2[0] = typeArray3[i];
            return i << 2 | nArray[i];
        }
        return -1;
    }

    private boolean diagnoseMisOp(Environment environment, Identifier identifier, Type[] typeArray, int n, int[] nArray, Type[] typeArray2) throws ClassNotFound {
        boolean bl = false;
        LocalMember localMember = this.locals;
        while (localMember != null) {
            Type[] typeArray3;
            if ((localMember.isOp() || localMember.isCap()) && identifier.getName().equals(localMember.getName()) && (typeArray3 = localMember.getType().getArgumentTypes()).length == typeArray.length) {
                bl = true;
                for (int i = n; i < typeArray.length; ++i) {
                    Type type = typeArray[i];
                    Type type2 = typeArray3[i];
                    if (environment.implicitCast(type, type2)) {
                        nArray[i] = 4;
                        continue;
                    }
                    if (nArray[i] <= 2 && environment.explicitCast(type, type2)) {
                        if (nArray[i] < 2) {
                            typeArray2[i] = null;
                        }
                        nArray[i] = 2;
                    } else if (nArray[i] > 0) continue;
                    if (typeArray2[i] == null) {
                        typeArray2[i] = type2;
                        continue;
                    }
                    if (typeArray2[i] == type2) continue;
                    int n2 = i;
                    nArray[n2] = nArray[n2] | 1;
                }
            }
            localMember = localMember.prev;
        }
        if (identifier.equals(Constants.idInit)) {
            return bl;
        }
        return bl;
    }

    public boolean diagnoseMisOpReceive(Environment environment, Identifier identifier, Expression[] expressionArray, Type[] typeArray, int n, long l) throws ClassNotFound {
        Type[] typeArray2 = new Type[1];
        boolean bl = false;
        int n2 = 0;
        while (n2 < typeArray.length) {
            String string;
            int n3 = this.diagnoseMisOpReceive(environment, identifier, typeArray, n2, typeArray2);
            String string2 = string = identifier.equals(Constants.idInit) ? "constructor" : Constants.opNames[n];
            if (n3 == -2) {
                environment.error(l, "wrong.number.args", "operation");
                bl = true;
            }
            if (n3 < 0) break;
            int n4 = n3 >> 2;
            boolean bl2 = (n3 & 2) != 0;
            boolean bl3 = (n3 & 1) != 0;
            Type type = typeArray2[0];
            String string3 = "" + type;
            if (bl2) {
                environment.error(expressionArray[n4].where, "recv.explicit.cast.needed", string, string3, typeArray[n4]);
            } else {
                environment.error(expressionArray[n4].where, "incompatible.type", string, string3, typeArray[n4]);
            }
            bl = true;
            n2 = n4 + 1;
        }
        return bl;
    }

    private int diagnoseMisOpReceive(Environment environment, Identifier identifier, Type[] typeArray, int n, Type[] typeArray2) throws ClassNotFound {
        int[] nArray = new int[typeArray.length];
        Type[] typeArray3 = new Type[typeArray.length];
        if (this.getLocalField(identifier) == null) {
            return -1;
        }
        if (!this.diagnoseMisOpReceive(environment, identifier, typeArray, n, nArray, typeArray3)) {
            return -2;
        }
        for (int i = n; i < typeArray.length; ++i) {
            if (nArray[i] >= 4) continue;
            typeArray2[0] = typeArray3[i];
            return i << 2 | nArray[i];
        }
        return -1;
    }

    private boolean diagnoseMisOpReceive(Environment environment, Identifier identifier, Type[] typeArray, int n, int[] nArray, Type[] typeArray2) throws ClassNotFound {
        boolean bl = false;
        LocalMember localMember = this.locals;
        while (localMember != null) {
            Type[] typeArray3;
            if ((localMember.isOp() || localMember.isCap()) && identifier.getName().equals(localMember.getName()) && (typeArray3 = localMember.getType().getArgumentTypes()).length == typeArray.length) {
                bl = true;
                for (int i = n; i < typeArray.length; ++i) {
                    Type type = typeArray3[i];
                    Type type2 = typeArray[i];
                    if (environment.implicitCast(type, type2)) {
                        nArray[i] = 4;
                        continue;
                    }
                    if (nArray[i] <= 2 && environment.explicitCast(type, type2)) {
                        if (nArray[i] < 2) {
                            typeArray2[i] = null;
                        }
                        nArray[i] = 2;
                    } else if (nArray[i] > 0) continue;
                    if (typeArray2[i] == null) {
                        typeArray2[i] = type;
                        continue;
                    }
                    if (typeArray2[i] == type) continue;
                    int n2 = i;
                    nArray[n2] = nArray[n2] | 1;
                }
            }
            localMember = localMember.prev;
        }
        if (identifier.equals(Constants.idInit)) {
            return bl;
        }
        return bl;
    }

    public void checkOp(Environment environment, LocalMember localMember) {
        LocalMember localMember2 = this.locals;
        while (localMember2 != null) {
            if (localMember2.isOp() && localMember.getName().equals(localMember2.getName())) {
                if (localMember2.getType().equals(localMember.getType())) {
                    environment.error(localMember.getWhere(), "op.multidef", localMember);
                    return;
                }
                if (localMember2.getType().equalArguments(localMember.getType())) {
                    if (localMember2.getType().getReturnType() == localMember.getType().getReturnType()) {
                        environment.error(localMember.getWhere(), "op.exp.diff", localMember);
                    } else {
                        environment.error(localMember.getWhere(), "op.redef.rettype", localMember, localMember2);
                    }
                    return;
                }
                if (this.capArgAmbiguity(environment, localMember2, localMember)) {
                    return;
                }
            }
            localMember2 = localMember2.prev;
        }
    }

    private boolean capArgAmbiguity(Environment environment, MemberDefinition memberDefinition, MemberDefinition memberDefinition2) {
        return false;
    }

    public void setField(MemberDefinition memberDefinition) {
        this.field = memberDefinition;
    }

    public void addInStatement(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        if (!this.field.isMethod()) {
            this.prev.addInStatement(l, l2, bl, bl2, bl3);
        } else {
            this.field.addInStatement(l, l2, bl, bl2, bl3);
        }
    }

    public void addCoStatement(long l, int n, boolean[] blArray) {
        if (!this.field.isMethod()) {
            this.prev.addCoStatement(l, n, blArray);
        } else {
            this.field.addCoStatement(l, n, blArray);
        }
    }

    public boolean isInStat() {
        return this.field.isInStat();
    }

    public boolean inniStatic() {
        return this._inniStatic;
    }

    public void setInniStatic(boolean bl) {
        this._inniStatic = bl;
    }
}

