/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.MemberDefinition;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.InStatMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class ContinueStatement
extends Statement {
    Identifier lbl;
    private String loopLabel = null;
    private boolean isInStat = false;
    private int loopNumber;
    private int scopeNumber;

    public ContinueStatement(long l, String string, Identifier identifier) {
        super(99, l, string);
        this.lbl = identifier;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        boolean bl = vset.justReplied();
        this.checkLabel(environment, context);
        this.reach(environment, vset);
        CheckContext checkContext = (CheckContext)new CheckContext(context, this).getContinueContext(this.lbl);
        if (checkContext != null) {
            switch (checkContext.node.op) {
                case 92: 
                case 93: 
                case 94: 
                case 191: {
                    if (checkContext.frameNumber != context.frameNumber) {
                        environment.error(this.where, "branch.to.uplevel", this.lbl);
                    }
                    checkContext.vsContinue = checkContext.vsContinue.join(vset);
                    break;
                }
                default: {
                    environment.error(this.where, "invalid.continue");
                    break;
                }
            }
        } else if (this.lbl != null) {
            environment.error(this.where, "label.not.found", this.lbl);
        } else {
            environment.error(this.where, "invalid.continue");
        }
        this.loopLabel = checkContext.getJRLabel();
        CheckContext checkContext2 = context.getTryExitContext();
        if (checkContext2 != null) {
            checkContext2.vsTryExit = checkContext2.vsTryExit.join(vset);
        }
        if (context.field.isInStat() && (!checkContext.isInStat() || context.field != checkContext.field)) {
            this.scopeNumber = ((InStatMember)context.field).getScopeNumber();
            this.loopNumber = ((InStatMember)context.field).getLoopNumber();
            if (context.field.getType().getReturnType().isType(11)) {
                this.isInStat = true;
            }
            if (context.isInStat() && !context.field.getType().getReturnType().isType(11) && vset != null && !vset.isDeadEnd()) {
                environment.error(context.field.getWhere(), "continue.return.required.at.end", context.field, new Long(this.where >> 32));
            }
            if (context != checkContext && context.field != checkContext.field) {
                MemberDefinition memberDefinition = context.field;
                Vset vset2 = context.field.getVset();
                Context context2 = context.prev;
                while (context2 != null && context2 != checkContext && context2.field != null && context2.field != checkContext.field) {
                    if (context2.field == memberDefinition) {
                        vset2 = context2.field.getVset();
                    } else {
                        if (context2.isInStat() && !context2.field.getType().getReturnType().isType(11) && vset2 != null && !vset2.isDeadEnd()) {
                            environment.error(context2.field.getWhere(), "continue.return.required.at.end", context2.field, new Long(this.where >> 32));
                        }
                        memberDefinition = context2.field;
                        vset2 = context2.field.getVset();
                    }
                    context2 = context2.prev;
                }
            }
        }
        if (bl) {
            return REPLIED_DEAD_END;
        }
        return DEAD_END;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        if (this.isInStat) {
            printStream.print("{ if (");
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.println("retOp != null)");
            super.printIndent(printStream, n + 1);
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.print("retOp.send(jrvm.getTimestamp());");
        }
        printStream.print("continue");
        if (this.lbl != null) {
            printStream.print(" " + this.lbl);
        } else {
            printStream.print(" " + this.loopLabel);
        }
        printStream.print(";");
        if (this.isInStat) {
            printStream.print("}");
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.jrPrint(printStream, n);
        if (this.isInStat) {
            printStream.print("{ if (");
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.println("retOp != null)");
            super.printIndent(printStream, n + 1);
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.print("retOp.send(jrvm.getTimestamp());");
        }
        printStream.print("continue");
        if (this.lbl != null) {
            printStream.print(" " + this.lbl);
        } else if (this.loopLabel != null) {
            printStream.print(" " + this.loopLabel);
        }
        printStream.print(";");
        if (this.isInStat) {
            printStream.print("}");
        }
    }
}

