/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.java;

import edu.ucdavis.jr.trans.sun.tools.java.BinaryAttribute;
import edu.ucdavis.jr.trans.sun.tools.java.BinaryConstantPool;
import edu.ucdavis.jr.trans.sun.tools.java.BinaryExceptionHandler;
import edu.ucdavis.jr.trans.sun.tools.java.BinaryMember;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDeclaration;
import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class BinaryCode
implements Constants {
    int maxStack;
    int maxLocals;
    BinaryExceptionHandler[] exceptionHandlers;
    BinaryAttribute atts;
    BinaryConstantPool cpool;
    byte[] code;

    public BinaryCode(byte[] byArray, BinaryConstantPool binaryConstantPool, Environment environment) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            this.cpool = binaryConstantPool;
            this.maxStack = dataInputStream.readUnsignedShort();
            this.maxLocals = dataInputStream.readUnsignedShort();
            int n = dataInputStream.readInt();
            this.code = new byte[n];
            dataInputStream.read(this.code);
            int n2 = dataInputStream.readUnsignedShort();
            this.exceptionHandlers = new BinaryExceptionHandler[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = dataInputStream.readUnsignedShort();
                int n4 = dataInputStream.readUnsignedShort();
                int n5 = dataInputStream.readUnsignedShort();
                ClassDeclaration classDeclaration = binaryConstantPool.getDeclaration(environment, dataInputStream.readUnsignedShort());
                this.exceptionHandlers[i] = new BinaryExceptionHandler(n3, n4, n5, classDeclaration);
            }
            this.atts = BinaryAttribute.load(dataInputStream, binaryConstantPool, -1);
            if (dataInputStream.available() != 0) {
                System.err.println("Should have exhausted input stream!");
            }
        }
        catch (IOException iOException) {
            throw new CompilerError(iOException);
        }
    }

    public BinaryExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public BinaryAttribute getAttributes() {
        return this.atts;
    }

    public static BinaryCode load(BinaryMember binaryMember, BinaryConstantPool binaryConstantPool, Environment environment) {
        byte[] byArray = binaryMember.getAttribute(Constants.idCode);
        return byArray != null ? new BinaryCode(byArray, binaryConstantPool, environment) : null;
    }
}

