/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.java;

import edu.ucdavis.jr.trans.sun.tools.java.ArrayType;
import edu.ucdavis.jr.trans.sun.tools.java.CapType;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDeclaration;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.ClassNotFound;
import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.IdentifierToken;
import edu.ucdavis.jr.trans.sun.tools.java.OpType;
import edu.ucdavis.jr.trans.sun.tools.java.ResCapType;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.javac.SourceMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.Node;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class MemberDefinition
implements Constants,
Cloneable {
    protected long where;
    protected String file;
    protected int modifiers;
    protected Type type;
    protected String documentation;
    protected IdentifierToken[] expIds;
    protected ClassDeclaration[] exp;
    protected Expression init;
    protected Node value;
    protected ClassDefinition clazz;
    protected Identifier name;
    protected ClassDefinition innerClass;
    protected MemberDefinition nextMember;
    protected MemberDefinition nextMatch;
    protected MemberDefinition accessPeer;
    protected boolean superAccessMethod;
    protected Vector args;
    protected Vector argTypeNames;
    protected boolean procOp;
    protected MemberDefinition opPartner;
    protected String jrOpName;
    protected String jrOpSig;
    protected String jrRecvStr;
    protected boolean needprocess = false;
    protected Node quant;
    private static Map proxyCache;
    static final int PUBLIC_ACCESS = 1;
    static final int PROTECTED_ACCESS = 2;
    static final int PACKAGE_ACCESS = 3;
    static final int PRIVATE_ACCESS = 4;
    boolean inheritedInOp = false;
    private Hashtable recvDecls = null;
    protected Vector inStatements = null;
    protected Vector coStatements = null;
    protected Vset vset;

    public MemberDefinition(long l, String string, ClassDefinition classDefinition, int n, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, Node node) {
        this(l, string, classDefinition, n, type, identifier, identifierTokenArray, node, null);
    }

    public MemberDefinition(long l, String string, ClassDefinition classDefinition, int n, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, Node node, Node node2) {
        if (identifierTokenArray == null) {
            identifierTokenArray = new IdentifierToken[]{};
        }
        this.where = l;
        this.file = string;
        this.clazz = classDefinition;
        this.modifiers = n;
        this.type = type;
        this.name = identifier;
        this.expIds = identifierTokenArray;
        this.value = node;
        this.procOp = false;
        this.opPartner = null;
        this.quant = node2;
    }

    public MemberDefinition(ClassDefinition classDefinition) {
        this(classDefinition.getWhere(), classDefinition.getFile(), classDefinition.getOuterClass(), classDefinition.getModifiers(), classDefinition.getType(), classDefinition.getName().getFlatName().getName(), null, null);
        this.innerClass = classDefinition;
    }

    public static MemberDefinition makeProxyMember(MemberDefinition memberDefinition, ClassDefinition classDefinition, Environment environment) {
        String string;
        MemberDefinition memberDefinition2;
        if (proxyCache == null) {
            proxyCache = new HashMap();
        }
        if ((memberDefinition2 = (MemberDefinition)proxyCache.get(string = memberDefinition.toString() + "@" + classDefinition.toString())) != null) {
            return memberDefinition2;
        }
        memberDefinition2 = new MemberDefinition(memberDefinition.getWhere(), memberDefinition.getFile(), classDefinition, memberDefinition.getModifiers(), memberDefinition.getType(), memberDefinition.getName(), memberDefinition.getExceptionIds(), null);
        memberDefinition2.exp = memberDefinition.getExceptions(environment);
        proxyCache.put(string, memberDefinition2);
        return memberDefinition2;
    }

    public final long getWhere() {
        return this.where;
    }

    public final String getFile() {
        return this.file;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.clazz.getClassDeclaration();
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public ClassDeclaration getDefiningClassDeclaration() {
        return this.getClassDeclaration();
    }

    public ClassDefinition getClassDefinition() {
        return this.clazz;
    }

    public final ClassDefinition getTopClass() {
        return this.clazz.getTopClass();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int n) {
        this.modifiers &= ~n;
    }

    public final void addModifiers(int n) {
        this.modifiers |= n;
    }

    public final Type getType() {
        return this.type;
    }

    public final Identifier getName() {
        return this.name;
    }

    public Vector getArguments() {
        return this.isMethod() ? new Vector() : null;
    }

    public ClassDeclaration[] getExceptions(Environment environment) {
        if (this.expIds != null && this.exp == null) {
            if (this.expIds.length != 0) {
                throw new CompilerError("getExceptions " + this);
            }
            this.exp = new ClassDeclaration[0];
        }
        return this.exp;
    }

    public final IdentifierToken[] getExceptionIds() {
        return this.expIds;
    }

    public ClassDefinition getInnerClass() {
        return this.innerClass;
    }

    public boolean isUplevelValue() {
        if (!this.isSynthetic() || !this.isVariable() || this.isStatic()) {
            return false;
        }
        String string = this.name.toString();
        return string.startsWith("val$") || string.toString().startsWith("loc$") || string.toString().startsWith("this$");
    }

    public boolean isAccessMethod() {
        return this.isSynthetic() && this.isMethod() && this.accessPeer != null;
    }

    public MemberDefinition getAccessMethodTarget() {
        if (this.isAccessMethod()) {
            MemberDefinition memberDefinition = this.accessPeer;
            while (memberDefinition != null) {
                if (!memberDefinition.isAccessMethod()) {
                    return memberDefinition;
                }
                memberDefinition = memberDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessMethodTarget(MemberDefinition memberDefinition) {
        if (this.getAccessMethodTarget() != memberDefinition) {
            if (this.accessPeer != null || memberDefinition.accessPeer != null) {
                throw new CompilerError("accessPeer");
            }
            this.accessPeer = memberDefinition;
        }
    }

    public MemberDefinition getAccessUpdateMember() {
        if (this.isAccessMethod()) {
            MemberDefinition memberDefinition = this.accessPeer;
            while (memberDefinition != null) {
                if (memberDefinition.isAccessMethod()) {
                    return memberDefinition;
                }
                memberDefinition = memberDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessUpdateMember(MemberDefinition memberDefinition) {
        if (this.getAccessUpdateMember() != memberDefinition) {
            if (!this.isAccessMethod() || memberDefinition.getAccessMethodTarget() != this.getAccessMethodTarget()) {
                throw new CompilerError("accessPeer");
            }
            memberDefinition.accessPeer = this.accessPeer;
            this.accessPeer = memberDefinition;
        }
    }

    public final boolean isSuperAccessMethod() {
        return this.superAccessMethod;
    }

    public final void setIsSuperAccessMethod(boolean bl) {
        this.superAccessMethod = bl;
    }

    public final boolean isBlankFinal() {
        return this.isFinal() && !this.isSynthetic() && this.getValue() == null;
    }

    public boolean isNeverNull() {
        if (this.isUplevelValue()) {
            return !this.name.toString().startsWith("val$");
        }
        return false;
    }

    public Node getValue(Environment environment) throws ClassNotFound {
        return this.value;
    }

    public final Node getValue() {
        return this.value;
    }

    public final void setValue(Node node) {
        this.value = node;
    }

    public Object getInitialValue() {
        return null;
    }

    public final MemberDefinition getNextMember() {
        return this.nextMember;
    }

    public final MemberDefinition getNextMatch() {
        return this.nextMatch;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset check(Environment environment, Context context, Vset vset) throws ClassNotFound {
        return vset;
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.clazz.reportDeprecated(environment);
    }

    public boolean canReach(Environment environment, MemberDefinition memberDefinition) {
        if (memberDefinition.isLocal() || !memberDefinition.isVariable() || !this.isVariable() && !this.isInitializer()) {
            return true;
        }
        if (this.getClassDeclaration().equals(memberDefinition.getClassDeclaration()) && this.isStatic() == memberDefinition.isStatic()) {
            while ((memberDefinition = memberDefinition.getNextMember()) != null && memberDefinition != this) {
            }
            return memberDefinition != null;
        }
        return true;
    }

    private int getAccessLevel() {
        if (this.isPublic()) {
            return 1;
        }
        if (this.isProtected()) {
            return 2;
        }
        if (this.isPackagePrivate()) {
            return 3;
        }
        if (this.isPrivate()) {
            return 4;
        }
        throw new CompilerError("getAccessLevel()");
    }

    private void reportError(Environment environment, String string, ClassDeclaration classDeclaration, MemberDefinition memberDefinition) {
        if (classDeclaration == null) {
            environment.error(this.getWhere(), string, this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
        } else {
            environment.error(classDeclaration.getClassDefinition().getWhere(), string, this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
        }
    }

    public boolean sameReturnType(MemberDefinition memberDefinition) {
        Type type;
        if (!this.isMethod() && !this.isOp() || !memberDefinition.isMethod() && !memberDefinition.isOp()) {
            throw new CompilerError("sameReturnType: not method");
        }
        Type type2 = this.getType().getReturnType();
        return type2 == (type = memberDefinition.getType().getReturnType());
    }

    public boolean checkOverride(Environment environment, MemberDefinition memberDefinition) {
        return this.checkOverride(environment, memberDefinition, null);
    }

    private boolean checkOverride(Environment environment, MemberDefinition memberDefinition, ClassDeclaration classDeclaration) {
        boolean bl = true;
        if (!this.isMethod() && !this.isOp()) {
            throw new CompilerError("checkOverride(), expected method");
        }
        if (this.isSynthetic()) {
            if (memberDefinition.isFinal() || !memberDefinition.isConstructor() && !memberDefinition.isStatic() && !this.isStatic()) {
                throw new CompilerError("checkOverride() synthetic");
            }
            return true;
        }
        if (this.getName() != memberDefinition.getName() || !this.getType().equalArguments(memberDefinition.getType())) {
            throw new CompilerError("checkOverride(), signature mismatch");
        }
        if (memberDefinition.isStatic() && !this.isStatic()) {
            this.reportError(environment, "override.static.with.instance", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!memberDefinition.isStatic() && this.isStatic()) {
            this.reportError(environment, "hide.instance.with.static", classDeclaration, memberDefinition);
            bl = false;
        }
        if (memberDefinition.isFinal()) {
            this.reportError(environment, "override.final.method", classDeclaration, memberDefinition);
            bl = false;
        }
        if (memberDefinition.reportDeprecated(environment) && !this.isDeprecated() && this instanceof SourceMember) {
            this.reportError(environment, "warn.override.is.deprecated", classDeclaration, memberDefinition);
        }
        if (this.getAccessLevel() > memberDefinition.getAccessLevel()) {
            this.reportError(environment, "override.more.restrictive", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!this.sameReturnType(memberDefinition)) {
            this.reportError(environment, "override.different.return", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!this.exceptionsFit(environment, memberDefinition)) {
            this.reportError(environment, "override.incompatible.exceptions", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!memberDefinition.isOp() && !memberDefinition.isProcOp() && (this.isOp() || this.isProcOp())) {
            this.reportError(environment, "override.op.method", classDeclaration, memberDefinition);
            bl = false;
        }
        if (memberDefinition.isOp() && !memberDefinition.isProcOp() && !this.isProcOp() && !this.isOp()) {
            if (memberDefinition.isAbstract()) {
                this.reportError(environment, "override.proc.abstract", classDeclaration, memberDefinition);
            } else {
                this.reportError(environment, "override.proc.inop", classDeclaration, memberDefinition);
            }
            bl = false;
        }
        return bl;
    }

    public boolean checkMeet(Environment environment, MemberDefinition memberDefinition, ClassDeclaration classDeclaration) {
        if (!this.isMethod()) {
            throw new CompilerError("checkMeet(), expected method");
        }
        if (!this.isAbstract() && !memberDefinition.isAbstract()) {
            throw new CompilerError("checkMeet(), no abstract method");
        }
        if (!this.isAbstract()) {
            return this.checkOverride(environment, memberDefinition, classDeclaration);
        }
        if (!memberDefinition.isAbstract()) {
            return memberDefinition.checkOverride(environment, this, classDeclaration);
        }
        if (this.getName() != memberDefinition.getName() || !this.getType().equalArguments(memberDefinition.getType())) {
            throw new CompilerError("checkMeet(), signature mismatch");
        }
        if (!this.sameReturnType(memberDefinition)) {
            environment.error(classDeclaration.getClassDefinition().getWhere(), "meet.different.return", this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
            return false;
        }
        return true;
    }

    public boolean couldOverride(Environment environment, MemberDefinition memberDefinition) {
        if (!this.isMethod()) {
            throw new CompilerError("coulcOverride(), expected method");
        }
        if (!memberDefinition.isAbstract()) {
            return false;
        }
        if (this.getAccessLevel() > memberDefinition.getAccessLevel()) {
            return false;
        }
        return this.exceptionsFit(environment, memberDefinition);
    }

    private boolean exceptionsFit(Environment environment, MemberDefinition memberDefinition) {
        ClassDeclaration[] classDeclarationArray = this.getExceptions(environment);
        ClassDeclaration[] classDeclarationArray2 = memberDefinition.getExceptions(environment);
        block2: for (int i = 0; i < classDeclarationArray.length; ++i) {
            try {
                ClassDefinition classDefinition = classDeclarationArray[i].getClassDefinition(environment);
                for (int j = 0; j < classDeclarationArray2.length; ++j) {
                    if (classDefinition.subClassOf(environment, classDeclarationArray2[j])) continue block2;
                }
                if (classDefinition.subClassOf(environment, environment.getClassDeclaration(Constants.idJavaLangError)) || classDefinition.subClassOf(environment, environment.getClassDeclaration(Constants.idJavaLangRuntimeException))) continue;
                return false;
            }
            catch (ClassNotFound classNotFound) {
                environment.error(this.getWhere(), "class.not.found", classNotFound.name, memberDefinition.getClassDeclaration());
            }
        }
        return true;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isHandler() {
        return (this.modifiers & 0x400000) != 0;
    }

    public final boolean isOpMethod() {
        return (this.modifiers & 0x800000) != 0;
    }

    public final boolean isMethod() {
        return this.type.isType(12);
    }

    public final boolean isOp() {
        return this.type.isType(14);
    }

    public final boolean isCap() {
        return this.type.isType(15);
    }

    public final boolean isVariable() {
        return !this.type.isType(12) && !this.type.isType(14) && this.innerClass == null;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x40000) != 0;
    }

    public final boolean isStrict() {
        return (this.modifiers & 0x200000) != 0;
    }

    public final boolean isInnerClass() {
        return this.innerClass != null;
    }

    public final boolean isInitializer() {
        return this.getName().equals(Constants.idClassInit);
    }

    public final boolean isConstructor() {
        return this.getName().equals(Constants.idInit);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isInlineable(Environment environment, boolean bl) throws ClassNotFound {
        return (this.isStatic() || this.isPrivate() || this.isFinal() || this.isConstructor() || bl) && !this.isSynchronized() && !this.isNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConstant() {
        if (this.isFinal() && this.isVariable() && this.value != null) {
            try {
                this.modifiers &= 0xFFFFFFEF;
                boolean bl = ((Expression)this.value).isConstant();
                return bl;
            }
            finally {
                this.modifiers |= 0x10;
            }
        }
        return false;
    }

    public String toString() {
        Identifier identifier = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            return this.isStatic() ? "static {}" : "instance {}";
        }
        if (this.isConstructor()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(identifier);
            stringBuffer.append('(');
            Type[] typeArray = this.getType().getArgumentTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[i].toString());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        return this.type.typeString(this.getName().toString());
    }

    public String jrToString() {
        Identifier identifier = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            return "";
        }
        if (this.isConstructor()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(identifier);
            stringBuffer.append('(');
            Type[] typeArray = this.getType().getArgumentTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[i].toString());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        if (this.isMethod()) {
            return this.type.jrTypeString(this.getName().toString(), true, true);
        }
        if (this.isOp()) {
            return this.jrOpString();
        }
        if (this.isCap()) {
            return this.jrCapString();
        }
        if (this.type.isType(9) && ((ArrayType)this.type).getBaseElementType().isType(15)) {
            return this.type.jrTypeString(((CapType)((ArrayType)this.type).getBaseElementType()).getJrCapName(this.getName().toString()), true, true, this.where, this.file);
        }
        return this.type.jrTypeString(this.getName().toString(), true, true, this.where, this.file);
    }

    public String jrToString(long l) {
        Identifier identifier = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            return "";
        }
        if (this.isConstructor()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(identifier);
            stringBuffer.append('(');
            Type[] typeArray = this.getType().getArgumentTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[i].jrToString());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        if (this.isMethod()) {
            return this.type.jrTypeString(this.getName().toString(), true, true);
        }
        if (this.isOp()) {
            return this.jrOpString();
        }
        if (this.isCap()) {
            return this.jrCapString();
        }
        if (this.type.isType(9) && ((ArrayType)this.type).getBaseElementType().isType(15)) {
            return this.type.jrTypeString(((CapType)((ArrayType)this.type).getBaseElementType()).getJrCapName(this.getName().toString()), true, true, l, this.file);
        }
        return this.type.jrTypeString(this.getName().toString(), true, true, l, this.file);
    }

    public void jrPrint(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isPrivate()) {
            printStream.print("private ");
        }
        if (this.isProtected()) {
            printStream.print("protected ");
        }
        if (this.isFinal()) {
            printStream.print("final ");
        }
        if (this.isStatic()) {
            printStream.print("static ");
        }
        if (this.isSynchronized() && !this.isOp()) {
            printStream.print("synchronized ");
        }
        if (this.isAbstract()) {
            printStream.print("abstract ");
        }
        if (this.isNative() && !this.isOp()) {
            printStream.print("native ");
        }
        if (this.isVolatile() && !this.isOp()) {
            printStream.print("volatile ");
        }
        if (this.isTransient() && !this.isOp()) {
            printStream.print("transient ");
        }
        if (this.isStrict() && !this.isOp()) {
            printStream.print("strictfp ");
        }
        printStream.print(this.jrToString());
    }

    private void appendModifiers(StringBuffer stringBuffer) {
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        if (this.isSynchronized() && !this.isOp()) {
            stringBuffer.append("synchronized ");
        }
        if (this.isAbstract() && !this.isOp()) {
            stringBuffer.append("abstract ");
        }
        if (this.isNative() && !this.isOp()) {
            stringBuffer.append("native ");
        }
        if (this.isVolatile() && !this.isOp()) {
            stringBuffer.append("volatile ");
        }
        if (this.isTransient() && !this.isOp()) {
            stringBuffer.append("transient ");
        }
        if (this.isStrict() && !this.isOp()) {
            stringBuffer.append("strictfp ");
        }
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isPrivate()) {
            printStream.print("private ");
        }
        if (this.isProtected()) {
            printStream.print("protected ");
        }
        if (this.isFinal()) {
            printStream.print("final ");
        }
        if (this.isStatic()) {
            printStream.print("static ");
        }
        if (this.isSynchronized()) {
            printStream.print("synchronized ");
        }
        if (this.isAbstract()) {
            printStream.print("abstract ");
        }
        if (this.isNative()) {
            printStream.print("native ");
        }
        if (this.isVolatile()) {
            printStream.print("volatile ");
        }
        if (this.isTransient()) {
            printStream.print("transient ");
        }
        printStream.println(this.toString() + ";");
    }

    public void cleanup(Environment environment) {
        this.documentation = null;
        if (this.isMethod() && this.value != null) {
            int n = 0;
            if (this.isPrivate() || this.isInitializer()) {
                this.value = Statement.empty;
            } else {
                n = ((Statement)this.value).costInline(Statement.MAXINLINECOST, null, null);
                if (n >= Statement.MAXINLINECOST) {
                    this.value = Statement.empty;
                } else {
                    try {
                        if (!this.isInlineable(null, true)) {
                            this.value = Statement.empty;
                        }
                    }
                    catch (ClassNotFound classNotFound) {
                        // empty catch block
                    }
                }
            }
            if (this.value != Statement.empty && environment.dump()) {
                environment.output("[after cleanup of " + this.getName() + ", " + n + " expression cost units remain]");
            }
        } else if (this.isVariable() && (this.isPrivate() || !this.isFinal() || this.type.isType(9))) {
            this.value = null;
        }
    }

    public void setProcOp(MemberDefinition memberDefinition, Environment environment) {
        if (!this.type.isType(14) && !this.type.isType(12)) {
            return;
        }
        this.procOp = memberDefinition != null;
        this.opPartner = memberDefinition;
    }

    public boolean isProcOp() {
        return this.procOp;
    }

    public void setNeedProcess() {
        if (this.isProcOp()) {
            this.needprocess = true;
            this.opPartner.needprocess = true;
        }
    }

    public boolean needProcess() {
        if (this.isProcOp()) {
            return this.needprocess;
        }
        return true;
    }

    public void setInherited() {
        this.inheritedInOp = true;
    }

    public boolean isInherited() {
        return this.inheritedInOp;
    }

    public boolean isInStat() {
        return false;
    }

    public MemberDefinition getProcOp() {
        if (this.isProcOp()) {
            return this.opPartner;
        }
        return null;
    }

    public String getJrOpName() {
        if (!this.isOp()) {
            return null;
        }
        if (this.jrOpName != null) {
            return this.jrOpName;
        }
        this.jrOpName = this.createJrOpName();
        return this.jrOpName;
    }

    public String getJrCapName(String string) {
        if (!this.isCap()) {
            return null;
        }
        return ((CapType)this.type).getJrCapName(string);
    }

    public boolean recvDeclInMemb(String string) {
        if (this.recvDecls == null) {
            this.recvDecls = new Hashtable();
        }
        if (this.recvDecls.get(string) != null) {
            return true;
        }
        this.recvDecls.put(string, string);
        return false;
    }

    public String getJrRecvStr(boolean bl) {
        if (this.isCap()) {
            return ((CapType)this.type).getJrCapRecvStr(bl);
        }
        if (!this.isOp()) {
            return null;
        }
        if (this.jrRecvStr == null) {
            this.jrRecvStr = this.getJrSig();
        }
        return bl ? "Recv_" + this.jrRecvStr : "recv_" + this.jrRecvStr;
    }

    public String getJrSig() {
        if (!this.isOp()) {
            return null;
        }
        if (this.jrOpSig != null) {
            return this.jrOpSig;
        }
        this.jrOpSig = this.createJrSig();
        return this.jrOpSig;
    }

    protected String createJrOpName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.argTypeNames == null) {
            this.createArgTypeNames();
        }
        stringBuffer.append("op_" + this.name.getLexicalName() + "_");
        stringBuffer.append(this.getJrSig());
        return stringBuffer.toString();
    }

    protected String createJrSig() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.argTypeNames == null) {
            this.createArgTypeNames();
        }
        Type[] typeArray = this.type.getArgumentTypes();
        if (this.argTypeNames == null) {
            stringBuffer.append("void");
        } else {
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('X');
                }
                if (typeArray[i].isType(15)) {
                    stringBuffer.append((String)this.argTypeNames.elementAt(i));
                    continue;
                }
                stringBuffer.append(Type.jrName((String)this.argTypeNames.elementAt(i)));
            }
        }
        stringBuffer.append("To");
        if (this.type.getReturnType().isType(15)) {
            stringBuffer.append("Cap_" + ((CapType)this.type.getReturnType()).getJrCapSig());
        } else {
            stringBuffer.append(Type.jrName(this.type.getReturnType().typeString("", false, true)));
        }
        ClassDeclaration[] classDeclarationArray = ((OpType)this.type).getResolvedExceptions();
        if (classDeclarationArray != null && classDeclarationArray.length != 0 && this.exp.length > 0) {
            stringBuffer.append("Throws");
            for (int i = 0; i < classDeclarationArray.length; ++i) {
                String string = Type.jrName(classDeclarationArray[i].getType().typeString("", false, true));
                if (i > 0) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void createArgTypeNames() {
        Type[] typeArray = this.type.getArgumentTypes();
        if (typeArray == null || typeArray.length == 0 || !this.isOp() && !this.isMethod()) {
            return;
        }
        this.argTypeNames = new Vector();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].isType(15)) {
                this.argTypeNames.addElement("Cap_" + ((CapType)typeArray[i]).getJrCapSig());
                continue;
            }
            if (typeArray[i].isType(9) && ((ArrayType)typeArray[i]).getBaseElementType().isType(15)) {
                this.argTypeNames.addElement(typeArray[i].jrTypeString("", false, true));
                continue;
            }
            if (typeArray[i].isType(9) && ((ArrayType)typeArray[i]).getBaseElementType().isType(16)) {
                this.argTypeNames.addElement(typeArray[i].jrTypeString("", false, true));
                continue;
            }
            if (typeArray[i].isType(9) && ((ArrayType)typeArray[i]).getBaseElementType().isType(17)) {
                this.argTypeNames.addElement(typeArray[i].jrTypeString("", false, true));
                continue;
            }
            if (typeArray[i].isType(16)) {
                this.argTypeNames.addElement(((ResCapType)typeArray[i]).jrCapString(""));
                continue;
            }
            if (typeArray[i].isType(17)) {
                this.argTypeNames.addElement("edu.ucdavis.jr.jrx.VM");
                continue;
            }
            this.argTypeNames.addElement(typeArray[i].typeString("", false, true));
        }
    }

    public Vector getArgTypeNames() {
        if (this.argTypeNames == null) {
            this.createArgTypeNames();
        }
        return this.argTypeNames;
    }

    protected String jrOpString() {
        String string = this.type.getReturnType().jrTypeString("", true, true, this.where, this.file).replaceAll("\\.", "dot");
        string = string.replaceAll("\\[\\]", "bkt");
        if (!this.isOp() || this.args == null) {
            return "Invalid call to jrOpString";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = this.getJrSig();
        if (!this.isLocal()) {
            stringBuffer.append("Op_" + string2 + "." + "JR" + "ProxyOp " + "JR" + "get_" + this.getJrOpName() + "()");
            if (!this.isAbstract()) {
                stringBuffer.append("\n    {\n\treturn " + this.getJrOpName() + ";\n    }\n    ");
                this.appendModifiers(stringBuffer);
            }
        }
        if (!this.isAbstract()) {
            stringBuffer.append("Op_");
            Type[] typeArray = this.type.getArgumentTypes();
            int n = typeArray == null ? 0 : typeArray.length;
            stringBuffer.append(string2);
            stringBuffer.append(".JRProxyOp");
            stringBuffer.append(' ');
            stringBuffer.append("\n\t" + this.getJrOpName());
            if (!this.isProcOp() && this.isLocal()) {
                stringBuffer.append(" = null;\n    ");
                stringBuffer.append("try{\n\t");
                stringBuffer.append(this.getJrOpName());
                stringBuffer.append("\n\t    = new Op_" + string2 + "." + "JR" + "ProxyOp(new InOp_");
                stringBuffer.append(string2);
                stringBuffer.append("_impl());");
                if (this.init != null) {
                    stringBuffer.append("\n      {");
                    stringBuffer.append("\n\tlong JRTotal = " + this.init.jrToString() + ";");
                    stringBuffer.append("\n\tif (JRTotal < 0) throw new jrRuntimeError(\"op initialized with a negative value\");");
                    stringBuffer.append("\n\tfor (long JRiter = 0; JRiter < JRTotal; JRiter++)");
                    stringBuffer.append("\n\t    " + this.getJrOpName() + ".send(jrvm.getTimestamp());");
                    stringBuffer.append("\n      }");
                }
                stringBuffer.append("\n    }catch (Exception e)");
                stringBuffer.append("{throw new jrRuntimeError(\"Cannot initialize op\");}");
            }
            if (this.isProcOp()) {
                int n2;
                stringBuffer.append(";\n    ");
                if (this.isStatic()) {
                    stringBuffer.append("static ");
                }
                stringBuffer.append("class ProcOp_" + string2 + "_impl" + this.name.getLexicalName() + " extends ProcOp_" + string2 + "_impl");
                stringBuffer.append("\n    {");
                if (!this.isStatic()) {
                    stringBuffer.append("\n\t" + this.clazz.getLocalName() + " thisarg;");
                }
                stringBuffer.append("\n\tpublic ProcOp_" + string2 + "_impl" + this.name.getLexicalName() + "(" + this.clazz.getLocalName() + " thisIn) throws RemoteException");
                stringBuffer.append("\n\t{");
                if (!this.isStatic()) {
                    stringBuffer.append("\n\t    thisarg = thisIn;");
                }
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append(this.type.getReturnType().jrTypeString("", true, true, this.where, this.file));
                stringBuffer.append(" call(");
                stringBuffer.append("long JRtimestamp");
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                int n3 = 0;
                if (!this.isStatic()) {
                    n3 = 1;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer2.append(", ");
                    }
                    stringBuffer2.append(typeArray[n2].jrTypeString("", true, true, ((MemberDefinition)this.args.elementAt(n2 + n3)).getWhere(), this.file));
                    stringBuffer2.append(" arg" + n2);
                }
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(") throws RemoteException");
                for (int i = 0; i < this.exp.length; ++i) {
                    stringBuffer.append(", " + this.exp[i].getName());
                }
                stringBuffer.append("\n");
                stringBuffer.append("\n\t{\n\t    ");
                String string3 = this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file));
                stringBuffer.append("jrvm.ariseAndReceive(); // from caller\n\t    ");
                stringBuffer.append("try {\n\t\t");
                if (this.needprocess) {
                    stringBuffer.append("Op_" + string3 + "Tovoid." + "JR" + "ProxyOp" + " retOp =\n\t\tnew Op_" + string3 + "Tovoid." + "JR" + "ProxyOp(new InOp_" + string3 + "Tovoid_impl(false, true));\n\t\t");
                }
                if (this.needprocess) {
                    stringBuffer.append("send");
                } else {
                    stringBuffer.append("jrvm.setTimestamp(JRtimestamp);\n\t\t");
                    if (string3.compareTo("void") != 0) {
                        stringBuffer.append("return ");
                    }
                    if (this.isStatic()) {
                        stringBuffer.append(this.clazz.getLocalName() + "." + this.name.getLexicalName());
                    } else {
                        stringBuffer.append("thisarg." + this.name.getLexicalName());
                    }
                }
                stringBuffer.append("(");
                if (this.needprocess) {
                    stringBuffer.append("JRtimestamp, ");
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("arg" + n2);
                }
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                if (this.needprocess) {
                    stringBuffer.append("retOp");
                } else {
                    stringBuffer.append("null");
                }
                if (!this.needprocess) {
                    stringBuffer.append(", null");
                }
                stringBuffer.append(", null");
                if (this.needprocess) {
                    stringBuffer.append(", null");
                }
                stringBuffer.append(");");
                if (this.needprocess) {
                    stringBuffer.append("\n\t\tjrvm.sendAndDie(); // to recv");
                    stringBuffer.append("\n\t\t    Recv_" + string3 + "Tovoid ret;");
                    stringBuffer.append("\n\t\ttry {");
                    stringBuffer.append("\n\t\t    ret = retOp.recv();");
                    stringBuffer.append("\n\t\t} finally {");
                    stringBuffer.append("\n\t\t    jrvm.ariseAndReceive(); // from recv");
                    stringBuffer.append("\n\t\t}");
                    stringBuffer.append("\n\t\tretOp.delete(false);");
                    stringBuffer.append("// check for exception");
                    stringBuffer.append("\n\t\tif (ret.thrownException != null)");
                    stringBuffer.append("\n\t\t{\n");
                    for (int i = 0; i < this.expIds.length; ++i) {
                        stringBuffer.append("\t\t    if (ret.thrownException instanceof " + this.expIds[i].toString() + ") throw (" + this.expIds[i].toString() + ") ret.thrownException;\n");
                    }
                    stringBuffer.append("\t\t    // catch all\n");
                    stringBuffer.append("\t\t    throw new jrRuntimeError(\"Unhandled exception: \" + ret.thrownException.toString());");
                    stringBuffer.append("\n\t\t}");
                    if (string3.compareTo("void") == 0) {
                        stringBuffer.append("\n\t\treturn;");
                    } else {
                        stringBuffer.append("\n\t\treturn ret.arg0;");
                    }
                }
                stringBuffer.append("\n\t    } finally {");
                stringBuffer.append("\n\t\tjrvm.sendAndDie(); // to caller");
                stringBuffer.append("\n\t    }");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tclass sendThread implements Runnable");
                stringBuffer.append("\n\t{");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("\n\t    ");
                    stringBuffer.append(typeArray[n2].jrTypeString("", true, true, ((MemberDefinition)this.args.elementAt(n2 + n3)).getWhere(), this.file));
                    stringBuffer.append(" arg" + n2 + ";");
                }
                stringBuffer.append("\n\t    ");
                stringBuffer.append("Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp;\n");
                stringBuffer.append("\t    Cap_voidTovoid fretOp;\n\t    ");
                stringBuffer.append("edu.ucdavis.jr.RemoteHandler handler;");
                stringBuffer.append("\n\t    public sendThread(");
                stringBuffer.append(stringBuffer2);
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp");
                stringBuffer.append(", edu.ucdavis.jr.RemoteHandler handler)");
                stringBuffer.append("\n\t    {");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("\n\t\tthis.arg" + n2 + " = arg" + n2 + ";");
                }
                stringBuffer.append("\n\t\tthis.retOp = retOp;");
                stringBuffer.append("\n\t\tthis.handler = handler;");
                stringBuffer.append("\n\t    }");
                stringBuffer.append("\n\t    public sendThread(");
                stringBuffer.append(stringBuffer2);
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp, Cap_voidTovoid fretOp");
                stringBuffer.append(", edu.ucdavis.jr.RemoteHandler handler)");
                stringBuffer.append("\n\t    {");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("\n\t\tthis.arg" + n2 + " = arg" + n2 + ";");
                }
                stringBuffer.append("\n\t\tthis.retOp = retOp;");
                stringBuffer.append("\n\t\tthis.fretOp = fretOp;");
                stringBuffer.append("\n\t\tthis.handler = handler;");
                stringBuffer.append("\n\t    }");
                stringBuffer.append("\n\t    public void run()");
                stringBuffer.append("\n\t    {\n\t\t");
                stringBuffer.append("try{\n\t\t    ");
                if (this.isStatic()) {
                    stringBuffer.append(this.clazz.getLocalName() + "." + this.name.getLexicalName());
                } else {
                    stringBuffer.append("thisarg." + this.name.getLexicalName());
                }
                stringBuffer.append("(");
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("this.arg" + n2);
                }
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("this.retOp");
                stringBuffer.append(", this.fretOp");
                stringBuffer.append(", this.handler);\n\t\t");
                stringBuffer.append("} catch (Exception e) {/* should be safe to ignore this exception */ }");
                stringBuffer.append("\n\t\tjrvm.threadDeath();");
                stringBuffer.append("\n\t    }");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("void");
                stringBuffer.append(" send(");
                stringBuffer.append("long JRtimestamp");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", " + stringBuffer2);
                }
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("this.send(");
                stringBuffer.append("JRtimestamp, ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("arg" + n2 + ", ");
                }
                stringBuffer.append("null, null, null);");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("Cap_" + string + "Tovoid");
                stringBuffer.append(" cosend(");
                stringBuffer.append("long JRtimestamp");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", " + stringBuffer2);
                }
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("return this.cosend(");
                stringBuffer.append("JRtimestamp, ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("arg" + n2 + ", ");
                }
                stringBuffer.append("null, null, null);");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("void");
                stringBuffer.append(" send(");
                stringBuffer.append("long JRtimestamp, ");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2 + ", ");
                }
                stringBuffer.append("edu.ucdavis.jr.RemoteHandler handler");
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("this.send(");
                stringBuffer.append("JRtimestamp, ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("arg" + n2 + ", ");
                }
                stringBuffer.append("null, handler, null);");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("Cap_" + string + "Tovoid");
                stringBuffer.append(" cosend(");
                stringBuffer.append("long JRtimestamp, ");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2 + ", ");
                }
                stringBuffer.append("edu.ucdavis.jr.RemoteHandler handler");
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("return this.cosend(");
                stringBuffer.append("JRtimestamp, ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("arg" + n2 + ", ");
                }
                stringBuffer.append("null, handler, null);");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("void");
                stringBuffer.append(" send(");
                stringBuffer.append("long JRtimestamp, ");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2 + ", ");
                }
                stringBuffer.append("Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp, ");
                stringBuffer.append("edu.ucdavis.jr.RemoteHandler handler, ");
                stringBuffer.append("Exception thrown");
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("jrvm.setTimestamp(JRtimestamp);");
                stringBuffer.append("\n\t    jrvm.threadBirth();");
                stringBuffer.append("\n\t    new Thread(new sendThread(");
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("arg" + n2);
                }
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("retOp, handler)).start();");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append("Cap_" + string + "Tovoid");
                stringBuffer.append(" cosend(");
                stringBuffer.append("long JRtimestamp, ");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2 + ", ");
                }
                stringBuffer.append("Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp, ");
                stringBuffer.append("edu.ucdavis.jr.RemoteHandler handler, ");
                stringBuffer.append("Exception thrown");
                stringBuffer.append(") throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("jrvm.setTimestamp(JRtimestamp);");
                stringBuffer.append("\n\t    jrvm.threadBirth();");
                stringBuffer.append("\n\t    new Thread(new sendThread(");
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("arg" + n2);
                }
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("null, handler)).start();");
                String string4 = (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid";
                String string5 = string4 + "." + "JR" + "ProxyOp";
                stringBuffer.append("\n\t    Op_" + string5 + " myretOp" + " = new Op_" + string5 + "(new InOp_" + string4 + "_impl());");
                stringBuffer.append("\n\t    myretOp.send(jrvm.getTimestamp()");
                if (!string4.equals("voidTovoid")) {
                    if (string4.equals("booleanTovoid")) {
                        stringBuffer.append(", false");
                    } else if (string4.equals("byteTovoid") || string4.equals("charTovoid") || string4.equals("shortTovoid") || string4.equals("intTovoid") || string4.equals("longTovoid") || string4.equals("floatTovoid") || string4.equals("doubleTovoid")) {
                        stringBuffer.append(", 0");
                    } else {
                        String string6 = ", (";
                        string6 = this.type.getReturnType().isType(15) ? string6 + this.type.getReturnType().jrTypeString(null, false, false) + ") null" : (this.type.getReturnType().isType(17) ? string6 + Type.jrName("edu.ucdavis.jr.jrx.VM") + ") null" : string6 + Type.jrName(this.type.getReturnType().toString()) + ") null");
                        if ((string6 = string6.replaceAll("bkt", "\\[\\]")).startsWith(", (remote")) {
                            string6 = string6.replaceFirst("remote", "JR");
                        }
                        if (!this.type.getReturnType().isType(15)) {
                            stringBuffer.append(string6.replaceAll("dot", "\\."));
                        } else {
                            stringBuffer.append(string6);
                        }
                    }
                }
                stringBuffer.append(");");
                stringBuffer.append("\n\t    return new Cap_" + string4 + "(myretOp);");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic Cap_" + string + "Tovoid cocall(");
                stringBuffer.append("long JRtimestamp");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", " + stringBuffer2);
                }
                stringBuffer.append(") throws RemoteException");
                for (int i = 0; i < this.exp.length; ++i) {
                    stringBuffer.append(", " + this.exp[i].getName());
                }
                stringBuffer.append("\n\t{");
                stringBuffer.append("\n\t    Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp = new ");
                stringBuffer.append("\n\t        Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp(new ");
                stringBuffer.append("InOp_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid_impl(false));");
                stringBuffer.append("\n\t    jrvm.setTimestamp(JRtimestamp);");
                stringBuffer.append("\n\t    jrvm.threadBirth();");
                stringBuffer.append("\n\t    new Thread(new sendThread(");
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("arg" + n2);
                }
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("retOp, null)).start();");
                stringBuffer.append("\n\t    Cap_" + string + "Tovoid retCap = new Cap_" + string + "Tovoid(retOp);");
                stringBuffer.append("\n\t    return retCap;");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic Cap_" + string + "Tovoid cocall(");
                stringBuffer.append("long JRtimestamp");
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(", " + stringBuffer2);
                }
                stringBuffer.append(", edu.ucdavis.jr.RemoteHandler handler, Cap_voidTovoid fretOp) throws RemoteException");
                stringBuffer.append("\n\t{");
                stringBuffer.append("\n\t    Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp retOp = new ");
                stringBuffer.append("\n\t        Op_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid." + "JR" + "ProxyOp(new ");
                stringBuffer.append("InOp_" + (this.type.getReturnType().isType(15) ? this.type.getReturnType().jrTypeString("", false, true, this.where, this.file) : Type.jrName(this.type.getReturnType().jrTypeString("", false, true, this.where, this.file))) + "Tovoid_impl(false));");
                stringBuffer.append("\n\t    jrvm.setTimestamp(JRtimestamp);");
                stringBuffer.append("\n\t    jrvm.threadBirth();");
                stringBuffer.append("\n\t    new Thread(new sendThread(");
                for (n2 = 0; n2 < n; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("arg" + n2);
                }
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("retOp, fretOp, handler)).start();");
                stringBuffer.append("\n\t    Cap_" + string + "Tovoid retCap = new Cap_" + string + "Tovoid(retOp);");
                stringBuffer.append("\n\t    return retCap;");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic ");
                stringBuffer.append(this.getJrRecvStr(true));
                stringBuffer.append(" recv() throws RemoteException");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("/* This is an error */\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"Receive invoked on an operation/operation capability associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic void deliverPendingMessages()");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("/* This is an error */\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"Message delivery invoked on an operation associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic int length()");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("return 0;");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic InOpIterator elements()");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("// This is an error\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"Elements invoked on an operation/operation capability associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic InLock getLock()");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("/* This is an error */\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"getLock invoked on an operation/operation capability associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic long getFirstTime()");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("/* This is an error */\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"getFirstTime invoked on an operation/operation capability associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n\tpublic boolean isRemote(String site)");
                stringBuffer.append("\n\t{\n\t    ");
                stringBuffer.append("// This is an error\n\t\t");
                stringBuffer.append("throw new jrRuntimeError(\"IsRemote invoked on an operation/operation capability associated with a method!\");");
                stringBuffer.append("\n\t}");
                stringBuffer.append("\n    }");
            }
            if (this.isStatic()) {
                stringBuffer.append(";\n    static {\n\ttry{\n\t");
                stringBuffer.append(this.getJrOpName() + " = ");
                if (!this.isProcOp() && this.isInherited() && this.clazz.getSuperClass() != null) {
                    stringBuffer.append(Type.jrName(this.clazz.getSuperClass().getName().toString()));
                    stringBuffer.append("." + this.getJrOpName() + ";\n\t");
                } else {
                    stringBuffer.append("new Op_" + string2 + "." + "JR" + "ProxyOp(");
                    stringBuffer.append("new ");
                    if (this.isProcOp()) {
                        stringBuffer.append("Proc");
                    } else {
                        stringBuffer.append("In");
                    }
                    stringBuffer.append("Op_");
                    stringBuffer.append(string2 + "_impl");
                    if (this.isProcOp()) {
                        stringBuffer.append(this.name.getLexicalName() + "(null));\n\t");
                    } else {
                        stringBuffer.append("());\n\t");
                    }
                }
                if (this.getValue() != null) {
                    Node node = this.getValue();
                    stringBuffer.append("\n      {");
                    stringBuffer.append("\n\tlong JRTotal = " + node.jrToString() + ";");
                    stringBuffer.append("\n\tif (JRTotal < 0) throw new jrRuntimeError(\"op initialized with a negative value\");");
                    stringBuffer.append("\n\tfor (long JRiter = 0; JRiter < JRTotal; JRiter++)");
                    stringBuffer.append("\n\t    " + this.getJrOpName() + ".send(jrvm.getTimestamp());\n");
                    stringBuffer.append("\n      }");
                }
                stringBuffer.append("} catch (Exception e) {throw new jrRuntimeError(e.toString());}\n    }");
            }
        }
        return stringBuffer.toString();
    }

    public String jrCapString() {
        if (!this.isCap()) {
            return "Invalid call to jrCapString";
        }
        return ((CapType)this.type).jrCapString(this.name.getLexicalName());
    }

    public String getJrCapName() {
        if (!this.isCap()) {
            return "Invalid call to jrCapName";
        }
        return ((CapType)this.type).getJrCapName(this.name.getLexicalName());
    }

    public String getJrCapSig() {
        if (!this.isCap()) {
            return "Invalid call to jrCapName";
        }
        return ((CapType)this.type).getJrCapSig();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void toCap(Environment environment, ClassDefinition classDefinition) {
        IdentifierToken[] identifierTokenArray = null;
        ClassDeclaration[] classDeclarationArray = null;
        if (this.expIds.length > 0) {
            identifierTokenArray = new IdentifierToken[this.expIds.length];
            classDeclarationArray = new ClassDeclaration[this.exp.length];
            System.arraycopy(this.expIds, 0, identifierTokenArray, 0, identifierTokenArray.length);
            System.arraycopy(this.exp, 0, classDeclarationArray, 0, classDeclarationArray.length);
        }
        this.type = Type.tCap(this.type.getReturnType(), this.type.getArgumentTypes(), identifierTokenArray, classDeclarationArray);
        if (environment != null) {
            ((CapType)this.type).getExceptions(environment, classDefinition);
        }
        this.procOp = false;
        this.opPartner = null;
    }

    public void toOp(Environment environment, ClassDefinition classDefinition) {
        IdentifierToken[] identifierTokenArray = null;
        ClassDeclaration[] classDeclarationArray = null;
        if (this.expIds.length > 0) {
            identifierTokenArray = new IdentifierToken[this.expIds.length];
            classDeclarationArray = new ClassDeclaration[this.exp.length];
            System.arraycopy(this.expIds, 0, identifierTokenArray, 0, identifierTokenArray.length);
            System.arraycopy(this.exp, 0, classDeclarationArray, 0, classDeclarationArray.length);
        }
        this.type = Type.tOp(this.type.getReturnType(), this.type.getArgumentTypes(), identifierTokenArray, classDeclarationArray);
        if (environment != null) {
            ((OpType)this.type).getExceptions(environment, classDefinition);
        }
        this.procOp = false;
        this.opPartner = null;
    }

    public void addInStatement(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        if (this.inStatements == null) {
            this.inStatements = new Vector();
        }
        this.inStatements.add(new InData(l, l2, bl, bl2, bl3));
    }

    public void addCoStatement(long l, int n, boolean[] blArray) {
        if (this.coStatements == null) {
            this.coStatements = new Vector();
        }
        this.coStatements.add(new CoData(l, n, blArray));
    }

    public void setVset(Vset vset) {
        this.vset = vset;
    }

    public Vset getVset() {
        return this.vset;
    }

    public void clearVset() {
        this.vset = null;
    }

    public Type getOpRetType() {
        throw new CompilerError("Expected an in statement member");
    }

    public static class CoData {
        public long myCoNum;
        public int totNumArms;
        public boolean[] CoQuantifiedArm;

        public CoData(long l, int n, boolean[] blArray) {
            this.myCoNum = l;
            this.totNumArms = n;
            this.CoQuantifiedArm = blArray;
        }
    }

    public static class InData {
        public long inNumber;
        public long numArms;
        public boolean overselect;
        public boolean quantifier;
        public boolean hasCap;

        public InData(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
            this.inNumber = l;
            this.numArms = l2;
            this.overselect = bl;
            this.quantifier = bl2;
            this.hasCap = bl3;
        }
    }
}

