/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.AmbiguousMember;
import edu.ucdavis.jr.trans.sun.tools.java.CapType;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.ClassNotFound;
import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.IdentifierToken;
import edu.ucdavis.jr.trans.sun.tools.java.MemberDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.OpType;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldUpdater;
import edu.ucdavis.jr.trans.sun.tools.tree.LocalMember;
import edu.ucdavis.jr.trans.sun.tools.tree.TypeExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.UnaryExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IdentifierExpression
extends Expression {
    Identifier id;
    MemberDefinition field;
    Expression implementation;
    Type ltype;
    private Vector potentialOps;

    public IdentifierExpression(long l, String string, Identifier identifier) {
        super(60, l, string, Type.tError);
        Type.setLexicalName(identifier.getLexicalName(), l, string);
        this.id = identifier;
    }

    public IdentifierExpression(IdentifierToken identifierToken) {
        this(identifierToken.getWhere(), identifierToken.getFile(), identifierToken.getName());
        Type.setLexicalName(identifierToken.getLexicalName(), this.where, this.file);
    }

    public IdentifierExpression(long l, MemberDefinition memberDefinition) {
        super(60, l, memberDefinition.getFile(), memberDefinition.getType());
        this.id = memberDefinition.getName();
        this.field = memberDefinition;
        this.file = memberDefinition.getFile();
        Type.setLexicalName(memberDefinition.getName().getLexicalName(), l, this.file);
    }

    public Identifier getId() {
        return this.id;
    }

    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    public boolean equals(Identifier identifier) {
        return this.id.equals(identifier);
    }

    private Vset assign(Environment environment, Context context, Vset vset) {
        if (this.field.isLocal()) {
            LocalMember localMember = (LocalMember)this.field;
            if (localMember.scopeNumber < context.frameNumber) {
                environment.error(this.where, "assign.to.uplevel", this.id);
            }
            if (localMember.isFinal()) {
                if (!localMember.isBlankFinal()) {
                    environment.error(this.where, "assign.to.final", this.id);
                } else if (!vset.testVarUnassigned(localMember.number)) {
                    environment.error(this.where, "assign.to.blank.final", this.id);
                }
            }
            vset.addVar(localMember.number);
            ++localMember.writecount;
        } else if (this.field.isFinal()) {
            vset = FieldExpression.checkFinalAssign(environment, context, vset, this.where, this.field);
        }
        return vset;
    }

    private Vset get(Environment environment, Context context, Vset vset) {
        if (this.field.isLocal()) {
            LocalMember localMember = (LocalMember)this.field;
            if (localMember.scopeNumber < context.frameNumber && !localMember.isFinal()) {
                environment.error(this.where, "invalid.uplevel", this.id);
            }
            if (!vset.testVar(localMember.number)) {
                environment.error(this.where, "var.not.initialized", this.id);
                vset.addVar(localMember.number);
            }
            ++localMember.readcount;
        } else {
            int n;
            if (!this.field.isStatic() && !vset.testVar(context.getThisNumber())) {
                environment.error(this.where, "access.inst.before.super", this.id);
                this.implementation = null;
            }
            if (this.field.isBlankFinal() && (n = context.getFieldNumber(this.field)) >= 0 && !vset.testVar(n)) {
                environment.error(this.where, "var.not.initialized", this.id);
            }
        }
        return vset;
    }

    boolean bind(Environment environment, Context context) {
        return this.bind(environment, context, null, true);
    }

    boolean bind(Environment environment, Context context, Type type, boolean bl) {
        MemberDefinition memberDefinition = null;
        LocalMember localMember = null;
        try {
            Constants constants;
            if (type != null) {
                constants = context.getLocalField(this.id);
                if (constants != null && ((MemberDefinition)constants).isOp()) {
                    memberDefinition = constants;
                    constants = context.matchOp(environment, this.id, type.getArgumentTypes());
                } else if (!(constants == null || ((MemberDefinition)constants).isCap() || bl && ((MemberDefinition)constants).getType() == Type.tObject)) {
                    localMember = constants;
                    constants = null;
                }
                if (constants != null && (((MemberDefinition)constants).isCap() || bl && ((MemberDefinition)constants).getType() == Type.tObject)) {
                    this.field = constants;
                } else {
                    this.field = context.field.getClassDefinition().matchOpOrCap(environment, context.field.getClassDefinition(), this.id, type.getArgumentTypes(), (MemberDefinition)constants, false, false, this.overselect);
                    if (this.field == null) {
                        memberDefinition = context.field.getClassDefinition().findAnyOpOrCap(environment, this.id);
                    }
                    if (constants != null) {
                        if (this.field == null || environment.isMoreSpecific((MemberDefinition)constants, this.field)) {
                            this.field = constants;
                        }
                    } else if (this.field != null && this.field.isCap() && localMember != null) {
                        this.field = localMember;
                    }
                }
                if (this.field == null && memberDefinition == null) {
                    this.field = context.getField(environment, this.id);
                }
            } else {
                this.field = context.getField(environment, this.id);
            }
            if (this.field == null) {
                if (memberDefinition != null && type != null) {
                    if (environment.explicitCast(memberDefinition.getType(), type)) {
                        environment.error(this.where, "explicit.cast.needed", type, memberDefinition.getType(), type);
                    } else {
                        environment.error(this.where, "incompatible.type", type, memberDefinition.getType(), type);
                    }
                    return false;
                }
                for (constants = context.field.getClassDefinition(); constants != null; constants = ((ClassDefinition)constants).getOuterClass()) {
                    if (((ClassDefinition)constants).findAnyMethod(environment, this.id) == null) continue;
                    if (this.overselect) {
                        environment.error(this.where, "in.over.select.invalid", this.id);
                    } else {
                        environment.error(this.where, "invalid.var", this.id, context.field.getClassDeclaration());
                    }
                    return false;
                }
                environment.error(this.where, "undef.var", this.id);
                return false;
            }
            this.type = this.field.getType();
            if (!context.field.getClassDefinition().canAccess(environment, this.field)) {
                environment.error(this.where, "no.field.access", this.id, this.field.getClassDeclaration(), context.field.getClassDeclaration());
                return false;
            }
            if (this.field.isLocal()) {
                constants = (LocalMember)this.field;
                if (((LocalMember)constants).scopeNumber < context.frameNumber) {
                    this.implementation = context.makeReference(environment, (LocalMember)constants);
                }
            } else {
                Cloneable cloneable;
                ClassDefinition classDefinition;
                constants = this.field;
                if (((MemberDefinition)constants).reportDeprecated(environment)) {
                    environment.error(this.where, "warn.field.is.deprecated", this.id, ((MemberDefinition)constants).getClassDefinition());
                }
                if ((classDefinition = ((MemberDefinition)constants).getClassDefinition()) != context.field.getClassDefinition() && (cloneable = context.getApparentField(environment, this.id)) != null && cloneable != constants) {
                    ClassDefinition classDefinition2 = context.findScope(environment, classDefinition);
                    if (classDefinition2 == null) {
                        classDefinition2 = ((MemberDefinition)constants).getClassDefinition();
                    }
                    if (((MemberDefinition)cloneable).isLocal()) {
                        environment.error(this.where, "inherited.hides.local", this.id, classDefinition2.getClassDeclaration());
                    } else {
                        environment.error(this.where, "inherited.hides.field", this.id, classDefinition2.getClassDeclaration(), ((MemberDefinition)cloneable).getClassDeclaration());
                    }
                }
                if (((MemberDefinition)constants).isStatic()) {
                    cloneable = new TypeExpression(this.where, this.file, ((MemberDefinition)constants).getClassDeclaration().getType());
                    this.implementation = new FieldExpression(this.where, this.file, null, (MemberDefinition)constants);
                } else {
                    cloneable = context.findOuterLink(environment, this.where, (MemberDefinition)constants);
                    if (cloneable != null) {
                        this.implementation = new FieldExpression(this.where, this.file, (Expression)cloneable, (MemberDefinition)constants);
                    }
                }
            }
            if (!context.canReach(environment, this.field)) {
                environment.error(this.where, "forward.ref", this.id, this.field.getClassDeclaration());
                return false;
            }
            return true;
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        catch (AmbiguousMember ambiguousMember) {
            environment.error(this.where, "ambig.field", this.id, ambiguousMember.field1.getClassDeclaration(), ambiguousMember.field2.getClassDeclaration());
        }
        return false;
    }

    boolean rebind(Environment environment, Context context, Type type) {
        try {
            MemberDefinition memberDefinition = context.getLocalField(this.id);
            memberDefinition = memberDefinition != null && memberDefinition.isOp() ? context.matchOp(environment, this.id, type.getArgumentTypes()) : null;
            this.field = context.field.getClassDefinition().matchOpOrCap(environment, context.field.getClassDefinition(), this.id, type.getArgumentTypes(), memberDefinition, false, false, false);
            if (memberDefinition != null && (this.field == null || environment.isMoreSpecific(memberDefinition, this.field))) {
                this.field = memberDefinition;
            }
            if (this.field == null) {
                for (ClassDefinition classDefinition = context.field.getClassDefinition(); classDefinition != null; classDefinition = classDefinition.getOuterClass()) {
                    if (classDefinition.findAnyMethod(environment, this.id) == null) continue;
                    environment.error(this.where, "invalid.var", this.id, context.field.getClassDeclaration());
                    return false;
                }
                environment.error(this.where, "undef.var", this.id);
                return false;
            }
            this.type = this.field.getType();
            if (!context.field.getClassDefinition().canAccess(environment, this.field)) {
                environment.error(this.where, "no.field.access", this.id, this.field.getClassDeclaration(), context.field.getClassDeclaration());
                return false;
            }
            if (this.field.isLocal()) {
                LocalMember localMember = (LocalMember)this.field;
                if (localMember.scopeNumber < context.frameNumber) {
                    this.implementation = context.makeReference(environment, localMember);
                }
            } else {
                Cloneable cloneable;
                ClassDefinition classDefinition;
                MemberDefinition memberDefinition2 = this.field;
                if (memberDefinition2.reportDeprecated(environment)) {
                    environment.error(this.where, "warn.field.is.deprecated", this.id, memberDefinition2.getClassDefinition());
                }
                if ((classDefinition = memberDefinition2.getClassDefinition()) != context.field.getClassDefinition() && (cloneable = context.getApparentField(environment, this.id)) != null && cloneable != memberDefinition2) {
                    ClassDefinition classDefinition2 = context.findScope(environment, classDefinition);
                    if (classDefinition2 == null) {
                        classDefinition2 = memberDefinition2.getClassDefinition();
                    }
                    if (((MemberDefinition)cloneable).isLocal()) {
                        environment.error(this.where, "inherited.hides.local", this.id, classDefinition2.getClassDeclaration());
                    } else {
                        environment.error(this.where, "inherited.hides.field", this.id, classDefinition2.getClassDeclaration(), ((MemberDefinition)cloneable).getClassDeclaration());
                    }
                }
                if (memberDefinition2.isStatic()) {
                    cloneable = new TypeExpression(this.where, this.file, memberDefinition2.getClassDeclaration().getType());
                    this.implementation = new FieldExpression(this.where, this.file, null, memberDefinition2);
                } else {
                    cloneable = context.findOuterLink(environment, this.where, memberDefinition2);
                    if (cloneable != null) {
                        this.implementation = new FieldExpression(this.where, this.file, (Expression)cloneable, memberDefinition2);
                    }
                }
            }
            if (!context.canReach(environment, this.field)) {
                environment.error(this.where, "forward.ref", this.id, this.field.getClassDeclaration());
                return false;
            }
            return true;
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        catch (AmbiguousMember ambiguousMember) {
            environment.error(this.where, "ambig.field", this.id, ambiguousMember.field1.getClassDeclaration(), ambiguousMember.field2.getClassDeclaration());
        }
        return false;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (this.field != null) {
            return vset;
        }
        if (this.bind(environment, context)) {
            this.potentialOps = new Vector();
            if (this.field.getType().isType(14)) {
                context.gatherPotentialOps(this.id, this.potentialOps);
                ((OpType)this.field.getType()).getExceptions(environment, context);
            }
            vset = this.get(environment, context, vset);
            context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            if (this.implementation != null) {
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
            }
        }
        return vset;
    }

    public Vset checkValueExpectOpOrCap(Environment environment, Context context, Vset vset, Hashtable hashtable, Type type, boolean bl) {
        if (this.field != null) {
            return vset;
        }
        this.ltype = type;
        if (this.bind(environment, context, type, bl)) {
            vset = this.get(environment, context, vset);
            context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            if (this.implementation != null) {
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
            }
        }
        return vset;
    }

    public Vset recheckValue(Environment environment, Context context, Vset vset, Hashtable hashtable, Type type) {
        if (this.rebind(environment, context, type)) {
            if (this.field.getType().isType(14)) {
                ((OpType)this.field.getType()).getExceptions(environment, context);
            }
            vset = this.get(environment, context, vset);
            context.field.getClassDefinition().addDependency(this.field.getClassDeclaration());
            if (this.implementation != null) {
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
            }
        }
        return vset;
    }

    public Vset checkLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (!this.bind(environment, context)) {
            return vset;
        }
        vset = this.assign(environment, context, vset);
        if (this.implementation != null) {
            vset = this.implementation.checkValue(environment, context, vset, hashtable);
        }
        return vset;
    }

    public Vset earlyCheckLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.bind(environment, context);
        return vset;
    }

    public Vset checkLHSReceive(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.checkLHS(environment, context, vset, hashtable);
    }

    public Vset checkAssignOp(Environment environment, Context context, Vset vset, Hashtable hashtable, Expression expression) {
        if (!this.bind(environment, context)) {
            return vset;
        }
        vset = this.assign(environment, context, this.get(environment, context, vset));
        if (this.implementation != null) {
            vset = this.implementation.checkValue(environment, context, vset, hashtable);
        }
        return vset;
    }

    public Type isCapExpression(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        Type type = null;
        try {
            MemberDefinition memberDefinition = this.field;
            if (memberDefinition == null) {
                memberDefinition = context.getField(environment, this.id);
            }
            if (memberDefinition != null && (type = memberDefinition.getType()) != null && !type.isType(15)) {
                type = null;
            }
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        catch (AmbiguousMember ambiguousMember) {
            environment.error(this.where, "ambig.field", this.id, ambiguousMember.field1.getClassDeclaration(), ambiguousMember.field2.getClassDeclaration());
        }
        return type;
    }

    public FieldUpdater getAssigner(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.getAssigner(environment, context);
        }
        return null;
    }

    public FieldUpdater getUpdater(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.getUpdater(environment, context);
        }
        return null;
    }

    public Vset checkAmbigName(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        try {
            if (context.getField(environment, this.id) != null) {
                return this.checkValue(environment, context, vset, hashtable);
            }
        }
        catch (ClassNotFound classNotFound) {
        }
        catch (AmbiguousMember ambiguousMember) {
            // empty catch block
        }
        ClassDefinition classDefinition = this.toResolvedType(environment, context, true);
        if (classDefinition != null) {
            classDefinition.getType().setLexicalName(this.id.getLexicalName());
            unaryExpression.right = new TypeExpression(unaryExpression.right.getWhere(), unaryExpression.right.getFile(), classDefinition.getType());
            Type.setLexicalName(this.id.getLexicalName(), unaryExpression.right.getWhere(), unaryExpression.right.getFile());
            return vset;
        }
        this.type = Type.tPackage;
        return vset;
    }

    private ClassDefinition toResolvedType(Environment environment, Context context, boolean bl) {
        Identifier identifier = context.resolveName(environment, this.id);
        Type type = Type.tClass(identifier);
        if (bl && !environment.classExists(type)) {
            return null;
        }
        if (environment.resolve(this.where, context.field.getClassDefinition(), type)) {
            try {
                Identifier identifier2;
                ClassDefinition classDefinition;
                ClassDefinition classDefinition2 = environment.getClassDefinition(type);
                if (classDefinition2.isMember() && (classDefinition = context.findScope(environment, classDefinition2.getOuterClass())) != classDefinition2.getOuterClass() && !(identifier2 = context.getApparentClassName(environment, this.id)).equals(Constants.idNull) && !identifier2.equals(identifier)) {
                    environment.error(this.where, "inherited.hides.type", this.id, classDefinition.getClassDeclaration());
                }
                if (!classDefinition2.getLocalName().equals(this.id.getFlatName().getName())) {
                    environment.error(this.where, "illegal.mangled.name", this.id, classDefinition2);
                }
                return classDefinition2;
            }
            catch (ClassNotFound classNotFound) {
                // empty catch block
            }
        }
        return null;
    }

    Type toType(Environment environment, Context context) {
        ClassDefinition classDefinition = this.toResolvedType(environment, context, false);
        if (classDefinition != null) {
            classDefinition.getType().getClassName().setWhere(this.where);
            classDefinition.getType().getClassName().setFile(this.file);
            classDefinition.getType();
            Type.setLexicalName(this.id.getLexicalName(), this.where, this.file);
            classDefinition.getType().setWhere(this.where);
            classDefinition.getType().setFile(this.file);
            return classDefinition.getType();
        }
        return Type.tError;
    }

    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null) {
            return this.field.isConstant();
        }
        return false;
    }

    public Expression inline(Environment environment, Context context) {
        return null;
    }

    public Expression inlineValue(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(environment, context);
        }
        if (this.field == null) {
            return this;
        }
        try {
            if (this.field.isLocal()) {
                if (this.field.isInlineable(environment, false)) {
                    Expression expression = (Expression)this.field.getValue(environment);
                    return expression == null ? this : expression.inlineValue(environment, context);
                }
                return this;
            }
            return this;
        }
        catch (ClassNotFound classNotFound) {
            throw new CompilerError(classNotFound);
        }
    }

    public Expression inlineLHS(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(environment, context);
        }
        return this;
    }

    public Expression copyInline(Context context) {
        if (this.implementation != null) {
            return this.implementation.copyInline(context);
        }
        IdentifierExpression identifierExpression = (IdentifierExpression)super.copyInline(context);
        if (this.field != null && this.field.isLocal()) {
            identifierExpression.field = ((LocalMember)this.field).getCurrentInlineCopy(context);
        }
        return identifierExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.costInline(n, environment, context);
        }
        return super.costInline(n, environment, context);
    }

    public void print(PrintStream printStream) {
        printStream.print(this.id + "#" + (this.field != null ? this.field.hashCode() : 0));
        if (this.implementation != null) {
            printStream.print("/IMPL=");
            this.implementation.print(printStream);
        }
    }

    public void jrPrint(PrintStream printStream) {
        if (debugName) {
            printStream.println("IDENTIFIEREXPRESSION");
        }
        if (this.field != null && this.field.isCap()) {
            printStream.print(this.field.getJrCapName(this.id.getLexicalName()));
        } else if (this.field != null && this.field.isOp()) {
            if (!this.field.isLocal()) {
                printStream.print("JRget_");
            }
            printStream.print(this.field.getJrOpName());
            if (!this.field.isLocal()) {
                printStream.print("()");
            }
        } else if (this.field != null && this.field.getType().isType(9) && this.field.getType().getBaseElementType().isType(15)) {
            printStream.print(((CapType)this.field.getType().getBaseElementType()).getJrCapName(this.id.getLexicalName()));
        } else {
            printStream.print(this.id.getLexicalName());
        }
    }

    public Enumeration getPotentialOps() {
        return this.potentialOps == null ? null : this.potentialOps.elements();
    }
}

