#!/usr/bin/perl -w

use strict;

use File::Copy;

use Env qw(JR_HOME JR_RMIC_CACHED JR_ECHO);

##print "JR_ECHO=$JR_ECHO\n";
##if (defined($JR_ECHO)) { print "$JR_ECHO\n";} else { print "notdefined\n"; }

my @starimplfiles = ("*_impl.java");
my @implfiles; # starimplfiles expanded
foreach my $f ( <@starimplfiles> ) {
    push(@implfiles, $f);
}

##print "@implfiles\n";
##exit;

if ( scalar(@implfiles) < 1 ) {
    exit 0;
}

# are we caching or not?
# if so, directory needs to be at least readable.
# (if it's not writable, too, then writebacks will fail, but that's OK.)
if( !defined($JR_RMIC_CACHED) ||
    !(-d $JR_RMIC_CACHED ) || !( -r $JR_RMIC_CACHED ) ) {
    # NO CACHING
    if( defined($JR_ECHO) ) {
	print "NO CACHING\n";
    }
    # just rmic everything.
    # accumulate all _impl.java files and then rmic them
    # (written this way, rather than individual rmic's, since rmic has
    # significant startup cost.)
    my @all;
    foreach my $file ( @implfiles ) {
	$file =~ s/\.java$//;
	push(@all, $file);
	if( defined($JR_ECHO) ) {
	    print "$file\n";
	}
    }
##print "@all\n";
##exit;
    system("rmic -d . @all");
}

else {
    # CACHING
    if( defined($JR_ECHO) ) {
	print "CACHING\n";
    }
    # note: race conditions are possible
    # (e.g., cp of .java and Skel and Stub files
    # especially if cache directory shared by several users)
    # this script doesn't handle those.
    # so it is probably best then to have per-user cache, provided the user
    # doesn't have multiple compiles active at the same time.

    my @all;
    foreach my $file ( @implfiles ) {

	my $baseName = $file;
	$baseName =~ s/\.java$//;
	if( defined($JR_ECHO) ) {
	    print "$baseName\n";
	}

	my $maybe= "$JR_RMIC_CACHED/$file";

	# reasonably assume that if _impl.java file exists,
	# then so do Skel and Stub files.

	if ( -r $maybe ) {
	    system("perl \"$JR_HOME/bin/cmp.pl\" -s \"$file\" \"$maybe\"");
	    if ( ($?>>8) == 0 ) {
		my $c1 = copy("$JR_RMIC_CACHED/".$baseName."_Skel.class", ".");
		my $c2 = copy("$JR_RMIC_CACHED/".$baseName."_Stub.class", ".");
		if (  $c1+$c2 == 2) { # both OK.
		    if (defined($JR_ECHO)) {
			print
			    "jr_rmic: $baseName using cached Skel and Stub\n";
		    }
		}
		else {
		    # sigh, have to rmic it.
		    push(@all, $baseName);
		    if (defined($JR_ECHO)) {
			print "jr_rmic: $baseName "
			    . "unable to copy cached Skel and Stub\n";
		    }
		}
	    }

	    else {
		push (@all, $baseName);
		if ( defined($JR_ECHO) ) {
		    print "jr_rmic: $file found in cache, but different\n";
		}
	    }
	}
	else {
	    push (@all, $baseName);
	    if ( defined($JR_ECHO) ) {
		print "jr_rmic: $file not found in cache\n"
	    }
	}
    }

    if ( scalar(@all) > 0) {
	system("rmic -d . @all");

	# copy back all files for possible use another time
	# lazy: also copies back those not just created
	# but those are identical (I hope)
	# note: cp can fail, e.g., if JR_RMIC_CACHED isn't writeable;
	# if so, ignore it.
	my @starreusefiles = ("*_impl.java",
			     "*_impl_Skel.class", 
			     "*_impl_Stub.class");
	foreach my $f ( <@starreusefiles> ) {
	    copy($f,$JR_RMIC_CACHED);
	}
    }
}
