/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldUpdater;
import edu.ucdavis.jr.trans.sun.tools.tree.TypeExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.UnaryExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class ArrayAccessExpression
extends UnaryExpression {
    Expression index;

    public ArrayAccessExpression(long l, String string, Expression expression, Expression expression2) {
        super(48, l, string, Type.tError, expression);
        this.index = expression2;
    }

    public Expression getRight() {
        return this.right;
    }

    public Expression getIndex() {
        return this.index;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.right.checkValue(environment, context, vset, hashtable);
        if (this.index == null) {
            environment.error(this.where, "array.index.required");
            return vset;
        }
        vset = this.index.checkValue(environment, context, vset, hashtable);
        this.index = this.convert(environment, context, Type.tInt, this.index);
        if (!this.right.type.isType(9)) {
            if (!this.right.type.isType(13)) {
                environment.error(this.where, "not.array", this.right.type);
            }
            return vset;
        }
        this.type = this.right.type.getElementType();
        return vset;
    }

    public Vset checkAmbigName(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        if (this.index == null) {
            vset = this.right.checkAmbigName(environment, context, vset, hashtable, this);
            if (this.right.type == Type.tPackage) {
                FieldExpression.reportFailedPackagePrefix(environment, this.right);
                return vset;
            }
            if (this.right instanceof TypeExpression) {
                Type type = Type.tArray(this.right.type);
                unaryExpression.right = new TypeExpression(this.right.getWhere(), this.right.getFile(), type);
                return vset;
            }
            environment.error(this.where, "array.index.required");
            return vset;
        }
        return super.checkAmbigName(environment, context, vset, hashtable, unaryExpression);
    }

    public Vset checkLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.checkValue(environment, context, vset, hashtable);
    }

    public Vset checkLHSReceive(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.checkLHS(environment, context, vset, hashtable);
    }

    public Vset checkAssignOp(Environment environment, Context context, Vset vset, Hashtable hashtable, Expression expression) {
        return this.checkValue(environment, context, vset, hashtable);
    }

    public FieldUpdater getAssigner(Environment environment, Context context) {
        return null;
    }

    public FieldUpdater getUpdater(Environment environment, Context context) {
        return null;
    }

    Type toType(Environment environment, Context context) {
        Type type = this.right.toType(environment, context);
        Type type2 = this.toType(environment, type);
        type2.setWhere(type.getWhere());
        type2.setFile(type.getFile());
        return type2;
    }

    Type toType(Environment environment, Type type) {
        if (this.index != null) {
            environment.error(this.index.where, "array.dim.in.type");
        }
        Type type2 = Type.tArray(type);
        type2.setWhere(type.getWhere());
        type2.setFile(type.getFile());
        return type2;
    }

    public Expression inline(Environment environment, Context context) {
        this.right = this.right.inlineValue(environment, context);
        this.index = this.index.inlineValue(environment, context);
        return this;
    }

    public Expression inlineValue(Environment environment, Context context) {
        this.right = this.right.inlineValue(environment, context);
        this.index = this.index.inlineValue(environment, context);
        return this;
    }

    public Expression inlineLHS(Environment environment, Context context) {
        return this.inlineValue(environment, context);
    }

    public Expression copyInline(Context context) {
        ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)this.clone();
        arrayAccessExpression.right = this.right.copyInline(context);
        arrayAccessExpression.index = this.index == null ? null : this.index.copyInline(context);
        return arrayAccessExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1 + this.right.costInline(n, environment, context) + this.index.costInline(n, environment, context);
    }

    public void print(PrintStream printStream) {
        printStream.print("(" + Constants.opNames[this.op] + " ");
        this.right.print(printStream);
        printStream.print(" ");
        if (this.index != null) {
            this.index.print(printStream);
        } else {
            printStream.print("<empty>");
        }
        printStream.print(")");
    }

    public void jrPrint(PrintStream printStream) {
        if (Constants.opNames[this.op].compareTo("[]") != 0) {
            System.err.println("ArrayAccessExpression: unknown operation");
        }
        this.right.jrPrint(printStream);
        printStream.print("[");
        if (this.index != null) {
            this.index.jrPrint(printStream);
        } else {
            printStream.print("");
        }
        printStream.print("]");
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        if (debugName) {
            printStream.println("ArrayAccessExpression");
        }
        if (Constants.opNames[this.op].compareTo("[]") != 0) {
            System.err.println("ArrayAccessExpression: unknown operation");
        }
        this.right.jrPrintWhere(printStream, this.right.getWhere());
        printStream.print("[");
        if (this.index != null) {
            this.index.jrPrintWhere(printStream, this.index.getWhere());
        } else {
            printStream.print("");
        }
        printStream.print("]");
    }
}

