/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.ClassDefinition;
import edu.ucdavis.jr.trans.sun.tools.java.ClassNotFound;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.IdentifierToken;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.LocalMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class CatchStatement
extends Statement {
    int mod;
    Expression texpr;
    Identifier id;
    Statement body;
    LocalMember field;

    public CatchStatement(long l, String string, Expression expression, IdentifierToken identifierToken, Statement statement) {
        super(102, l, string);
        this.mod = identifierToken.getModifiers();
        this.texpr = expression;
        this.id = identifierToken.getName();
        this.body = statement;
    }

    public CatchStatement(long l, String string, Expression expression, Identifier identifier, Statement statement) {
        super(102, l, string);
        this.texpr = expression;
        this.id = identifier;
        this.body = statement;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.reach(environment, vset);
        context = new Context(context, this);
        Type type = this.texpr.toType(environment, context);
        try {
            if (context.getLocalField(this.id) != null) {
                environment.error(this.where, "local.redefined", this.id);
            }
            if (!type.isType(13)) {
                if (!type.isType(10)) {
                    environment.error(this.where, "catch.not.throwable", type);
                } else {
                    ClassDefinition classDefinition = environment.getClassDefinition(type);
                    if (!classDefinition.subClassOf(environment, environment.getClassDeclaration(Constants.idJavaLangThrowable))) {
                        environment.error(this.where, "catch.not.throwable", classDefinition);
                    }
                }
            }
            this.field = new LocalMember(this.where, this.file, context.field.getClassDefinition(), this.mod, type, this.id);
            context.declare(environment, this.field);
            vset.addVar(this.field.number);
            return this.body.check(environment, context, vset, hashtable);
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, Constants.opNames[this.op]);
            return vset;
        }
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        if (this.field.isUsed()) {
            context.declare(environment, this.field);
        }
        if (this.body != null) {
            this.body = this.body.inline(environment, context);
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        CatchStatement catchStatement = (CatchStatement)this.clone();
        if (this.body != null) {
            catchStatement.body = this.body.copyInline(context, bl);
        }
        if (this.field != null) {
            catchStatement.field = this.field.copyInline(context);
        }
        return catchStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1;
        if (this.body != null) {
            n2 += this.body.costInline(n, environment, context);
        }
        return n2;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("catch (");
        this.texpr.print(printStream);
        printStream.print(" " + this.id + ") ");
        if (this.body != null) {
            this.body.print(printStream, n);
        } else {
            printStream.print("<empty>");
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("catch (");
        if ((this.mod & 0x10) != 0) {
            printStream.print("final ");
        }
        printStream.print(this.field.jrToString(this.typeWhere));
        printStream.print(") ");
        if (this.body != null) {
            this.body.jrPrint(printStream, n);
        } else {
            printStream.print("");
        }
    }
}

