/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CaseStatement;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.InStatement;
import edu.ucdavis.jr.trans.sun.tools.tree.IntegerExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.LoopInterface;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class SwitchStatement
extends Statement
implements LoopInterface {
    Expression expr;
    Statement[] args;
    private long myLoopLabelNumber;
    private String myJRLabel;

    public SwitchStatement(long l, String string, Expression expression, Statement[] statementArray) {
        super(95, l, string);
        this.expr = expression;
        this.args = statementArray;
        this.myLoopLabelNumber = InStatement.getNextLoopLabelNumber();
        this.myJRLabel = "JRLoop_" + this.myLoopLabelNumber;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        vset = this.expr.checkValue(environment, checkContext, this.reach(environment, vset), hashtable);
        Type type = this.expr.type;
        this.expr = this.convert(environment, checkContext, Type.tInt, this.expr);
        Hashtable<Expression, Statement> hashtable2 = new Hashtable<Expression, Statement>();
        boolean bl = false;
        Vset vset2 = DEAD_END;
        for (int i = 0; i < this.args.length; ++i) {
            Statement statement = this.args[i];
            if (statement.op == 96) {
                vset2 = statement.check(environment, checkContext, vset2.join(vset.copy()), hashtable);
                Expression expression = ((CaseStatement)statement).expr;
                if (expression != null) {
                    if (expression instanceof IntegerExpression) {
                        boolean bl2;
                        Integer n = (Integer)((IntegerExpression)expression).getValue();
                        int n2 = n;
                        if (hashtable2.get(expression) != null) {
                            environment.error(statement.where, "duplicate.label", n);
                            continue;
                        }
                        hashtable2.put(expression, statement);
                        switch (type.getTypeCode()) {
                            case 1: {
                                bl2 = n2 != (byte)n2;
                                break;
                            }
                            case 3: {
                                bl2 = n2 != (short)n2;
                                break;
                            }
                            case 2: {
                                bl2 = n2 != (char)n2;
                                break;
                            }
                            default: {
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        environment.error(statement.where, "switch.overflow", n, type);
                        continue;
                    }
                    if (expression.isConstant() && expression.getType() == Type.tInt) continue;
                    environment.error(statement.where, "const.expr.required");
                    continue;
                }
                if (bl) {
                    environment.error(statement.where, "duplicate.default");
                }
                bl = true;
                continue;
            }
            vset2 = statement.checkBlockStatement(environment, checkContext, vset2, hashtable);
        }
        if (!vset2.isDeadEnd()) {
            checkContext.vsBreak = checkContext.vsBreak.join(vset2);
        }
        if (bl) {
            vset = checkContext.vsBreak;
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.expr = this.expr.inlineValue(environment, context);
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i] = this.args[i].inline(environment, context);
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        SwitchStatement switchStatement = (SwitchStatement)this.clone();
        switchStatement.expr = this.expr.copyInline(context);
        switchStatement.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            switchStatement.args[i] = this.args[i].copyInline(context, bl);
        }
        return switchStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = this.expr.costInline(n, environment, context);
        for (int i = 0; i < this.args.length && n2 < n; ++i) {
            if (this.args[i] == null) continue;
            n2 += this.args[i].costInline(n, environment, context);
        }
        return n2;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print(this.myJRLabel + ": do { ");
        printStream.print("switch (");
        this.expr.print(printStream);
        printStream.print(") {\n");
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.printIndent(printStream, n + 1);
            this.args[i].print(printStream, n + 1);
            printStream.print("\n");
        }
        this.printIndent(printStream, n);
        printStream.print("}");
        printStream.print("} while(false);");
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.jrPrint(printStream, n);
        printStream.print(this.myJRLabel + ": do { ");
        printStream.print("switch (");
        this.expr.jrPrintWhere(printStream, this.typeWhere);
        printStream.print(") {\n");
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.printIndent(printStream, n + 1);
            this.args[i].jrPrint(printStream, n + 1);
            printStream.print("\n");
        }
        this.printIndent(printStream, n);
        printStream.print("}");
        printStream.print("} while(false);");
    }

    public String getJRLabel() {
        return this.myJRLabel;
    }
}

