/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class SynchronizedStatement
extends Statement {
    Expression expr;
    Statement body;
    boolean needReturnSlot;

    public SynchronizedStatement(long l, String string, Expression expression, Statement statement) {
        super(126, l, string);
        this.expr = expression;
        this.body = statement;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        vset = this.reach(environment, vset);
        vset = this.expr.checkValue(environment, checkContext, vset, hashtable);
        if (this.expr.type.equals(Type.tNull)) {
            environment.error(this.expr.where, "synchronized.null");
        }
        this.expr = this.convert(environment, checkContext, Type.tClass(Constants.idJavaLangObject), this.expr);
        vset = this.body.check(environment, checkContext, vset, hashtable);
        return context.removeAdditionalVars(vset.join(checkContext.vsBreak));
    }

    public Statement inline(Environment environment, Context context) {
        if (this.body != null) {
            this.body = this.body.inline(environment, context);
        }
        this.expr = this.expr.inlineValue(environment, context);
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        SynchronizedStatement synchronizedStatement = (SynchronizedStatement)this.clone();
        synchronizedStatement.expr = this.expr.copyInline(context);
        if (this.body != null) {
            synchronizedStatement.body = this.body.copyInline(context, bl);
        }
        return synchronizedStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1;
        if (this.expr != null && (n2 += this.expr.costInline(n, environment, context)) >= n) {
            return n2;
        }
        if (this.body != null) {
            n2 += this.body.costInline(n, environment, context);
        }
        return n2;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("synchronized ");
        this.expr.print(printStream);
        printStream.print(" ");
        if (this.body != null) {
            this.body.print(printStream, n);
        } else {
            printStream.print("{}");
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.jrPrint(printStream, n);
        printStream.print("synchronized (");
        this.expr.jrPrintWhere(printStream, this.typeWhere);
        printStream.print(")");
        printStream.print(" ");
        if (this.body != null) {
            this.body.jrPrint(printStream, n);
        } else {
            printStream.print("{}");
        }
    }
}

