/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.ConditionVars;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.InStatement;
import edu.ucdavis.jr.trans.sun.tools.tree.LoopInterface;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class WhileStatement
extends Statement
implements LoopInterface {
    Expression cond;
    Statement body;
    private long myLoopLabelNumber;
    private String myJRLabel;

    public WhileStatement(long l, String string, Expression expression, Statement statement) {
        super(93, l, string);
        this.cond = expression;
        this.body = statement;
        this.myLoopLabelNumber = InStatement.getNextLoopLabelNumber();
        this.myJRLabel = "JRLoop_" + this.myLoopLabelNumber;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        boolean bl = vset.justReplied();
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        Vset vset2 = vset.copy();
        ConditionVars conditionVars = this.cond.checkCondition(environment, checkContext, this.reach(environment, vset), hashtable);
        this.cond = this.convert(environment, checkContext, Type.tBoolean, this.cond);
        vset = this.body.check(environment, checkContext, conditionVars.vsTrue, hashtable);
        vset = vset.join(checkContext.vsContinue);
        context.checkBackBranch(environment, this, vset2, vset);
        vset = checkContext.vsBreak.join(conditionVars.vsFalse);
        if (bl) {
            vset.setReplied();
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.cond = this.cond.inlineValue(environment, context);
        if (this.body != null) {
            this.body = this.body.inline(environment, context);
        }
        return this;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1 + this.cond.costInline(n, environment, context) + (this.body != null ? this.body.costInline(n, environment, context) : 0);
    }

    public Statement copyInline(Context context, boolean bl) {
        WhileStatement whileStatement = (WhileStatement)this.clone();
        whileStatement.cond = this.cond.copyInline(context);
        if (this.body != null) {
            whileStatement.body = this.body.copyInline(context, bl);
        }
        return whileStatement;
    }

    public void print(PrintStream printStream, int n) {
        printStream.print(this.myJRLabel + ": ");
        super.print(printStream, n);
        printStream.print("while ");
        this.cond.print(printStream);
        if (this.body != null) {
            printStream.print(" ");
            this.body.print(printStream, n);
        } else {
            printStream.print(";");
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        printStream.print(this.myJRLabel + ": ");
        super.jrPrint(printStream, n);
        printStream.print("while (");
        this.cond.jrPrintWhere(printStream, this.typeWhere);
        printStream.println(")");
        if (this.body != null) {
            printStream.print(" ");
            this.body.jrPrint(printStream, n);
        } else {
            printStream.print(";");
        }
    }

    public String getJRLabel() {
        return this.myJRLabel;
    }
}

