/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.CompoundStatement;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.IdentifierExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Node;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class Statement
extends Node {
    public static final Vset DEAD_END = Vset.DEAD_END;
    public static final Vset REPLIED_DEAD_END = Vset.REPLIED_DEAD_END;
    Identifier[] labels = null;
    private boolean sendAtEnd = false;
    private boolean returnAtEnd = false;
    long typeWhere;
    public static final Statement empty = new Statement(105, 0L, null);
    public static final int MAXINLINECOST = Integer.getInteger("javac.maxinlinecost", 30);

    Statement(int n, long l, String string) {
        super(n, l, string);
        this.typeWhere = l;
    }

    public static Statement insertStatement(Statement statement, Statement statement2) {
        if (statement2 == null) {
            statement2 = statement;
        } else if (statement2 instanceof CompoundStatement) {
            ((CompoundStatement)statement2).insertStatement(statement);
        } else {
            Statement[] statementArray = new Statement[]{statement, statement2};
            statement2 = new CompoundStatement(statement.getWhere(), statement.getFile(), statementArray);
        }
        return statement2;
    }

    public void setLabel(Environment environment, Expression expression) {
        if (expression.op == 60) {
            if (this.labels == null) {
                this.labels = new Identifier[1];
            } else {
                Identifier[] identifierArray = new Identifier[this.labels.length + 1];
                System.arraycopy(this.labels, 0, identifierArray, 1, this.labels.length);
                this.labels = identifierArray;
            }
            this.labels[0] = ((IdentifierExpression)expression).id;
        } else {
            environment.error(expression.where, "invalid.label");
        }
    }

    public Vset checkMethod(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        CheckContext checkContext = new CheckContext(context, new Statement(47, 0L, null));
        context = checkContext;
        vset = this.check(environment, context, vset, hashtable);
        if (!context.field.getType().getReturnType().isType(11)) {
            if (!vset.isDeadEnd()) {
                environment.error(context.field.getWhere(), "return.required.at.end", context.field);
            } else if (context.field.isProcOp() && vset.justReplied()) {
                this.addReturnAtEnd();
            }
        } else if (context.field.isProcOp() && !vset.isDeadEnd()) {
            this.addSendAtEnd();
        }
        vset = vset.join(checkContext.vsBreak);
        return vset;
    }

    Vset checkDeclaration(Environment environment, Context context, Vset vset, int n, Type type, Hashtable hashtable) {
        throw new CompilerError("checkDeclaration");
    }

    protected void checkLabel(Environment environment, Context context) {
        if (this.labels != null) {
            block0: for (int i = 0; i < this.labels.length; ++i) {
                for (int j = i + 1; j < this.labels.length; ++j) {
                    if (this.labels[i] != this.labels[j]) continue;
                    environment.error(this.where, "nested.duplicate.label", this.labels[i]);
                    continue block0;
                }
                CheckContext checkContext = (CheckContext)context.getLabelContext(this.labels[i]);
                if (checkContext == null || checkContext.frameNumber != context.frameNumber) continue;
                environment.error(this.where, "nested.duplicate.label", this.labels[i]);
            }
        }
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        throw new CompilerError("check");
    }

    public Vset checkQuantifier(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.check(environment, context, vset, hashtable);
    }

    Vset checkBlockStatement(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        return this.check(environment, context, vset, hashtable);
    }

    Vset reach(Environment environment, Vset vset) {
        if (vset.isDeadEnd() && !vset.justReplied()) {
            environment.error(this.where, "stat.not.reached");
            vset = vset.clearDeadEnd();
        }
        return vset;
    }

    public Statement inline(Environment environment, Context context) {
        return this;
    }

    public Statement eliminate(Environment environment, Statement statement) {
        if (statement != null && this.labels != null) {
            Statement[] statementArray = new Statement[]{statement};
            statement = new CompoundStatement(this.where, this.file, statementArray);
            statement.labels = this.labels;
        }
        return statement;
    }

    public boolean hasLabel(Identifier identifier) {
        Identifier[] identifierArray = this.labels;
        if (identifierArray != null) {
            int n = identifierArray.length;
            while (--n >= 0) {
                if (!identifierArray[n].equals(identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public Expression firstConstructor() {
        return null;
    }

    public Statement copyInline(Context context, boolean bl) {
        return (Statement)this.clone();
    }

    public int costInline(int n, Environment environment, Context context) {
        return n;
    }

    void printIndent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
    }

    public void print(PrintStream printStream, int n) {
        if (this.labels != null) {
            int n2 = this.labels.length;
            while (--n2 >= 0) {
                printStream.print(this.labels[n2] + ": ");
            }
        }
    }

    public void print(PrintStream printStream) {
        this.print(printStream, 0);
    }

    public void jrPrint(PrintStream printStream, int n) {
        if (this.labels != null) {
            int n2 = this.labels.length;
            while (--n2 >= 0) {
                printStream.print(this.labels[n2] + ": ");
            }
        }
    }

    public void jrPrint(PrintStream printStream) {
        this.jrPrint(printStream, 0);
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        this.jrPrint(printStream);
    }

    public void setTypeWhere(long l) {
        this.typeWhere = l;
    }

    protected void addSendAtEnd() {
        this.sendAtEnd = true;
    }

    protected boolean getSendAtEnd() {
        return this.sendAtEnd;
    }

    protected void addReturnAtEnd() {
        this.returnAtEnd = true;
    }

    protected boolean getReturnAtEnd() {
        return this.returnAtEnd;
    }
}

