/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac;

import edu.ucdavis.jr.trans.sun.tools.java.ClassDeclaration;
import edu.ucdavis.jr.trans.sun.tools.java.ClassFile;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.Node;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class jrGenClass {
    protected Hashtable sources = new Hashtable();
    protected static Hashtable binarySources = new Hashtable();
    protected String hashkey;
    protected Vector args;
    protected ClassDeclaration[] exps;
    protected String ret;
    protected String jrret;
    protected String sig;
    protected String arglist;
    protected boolean callable;
    protected boolean sendable;
    public static final String jrprepend = "JR";
    public static final String enumerationName = "ArmSubEnumeration";
    public static final String jrvmIntfName = "jrvm_intf";
    public static final String finalInvocationName = "finalInvoc";
    public static final String HANDLER_TYPE = "edu.ucdavis.jr.RemoteHandler";
    public static final String COMM_EXCEPTION = "edu.ucdavis.jr.jrCommunicationException";
    public static final boolean CANCALL = true;
    public static final boolean CANNOTCALL = false;
    public static final boolean CANSEND = true;
    public static final boolean CANNOTSEND = false;
    public static final String genHeader = "/*****************************************************\n * jr generated file\n ****************************************************/\n";
    public static final String importHeader = "import edu.ucdavis.jr.*;\nimport edu.ucdavis.jr.jrx.*;\nimport java.rmi.*;\nimport java.io.Serializable;\n\n";
    public static final String subdirName = "jrGen";

    public jrGenClass(String string, Vector vector, ClassDeclaration[] classDeclarationArray, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.hashkey = string;
        this.args = vector == null ? new Vector() : vector;
        this.exps = classDeclarationArray == null ? new ClassDeclaration[]{} : classDeclarationArray;
        this.ret = string2;
        this.jrret = string3;
        this.sig = string4;
        this.callable = bl;
        this.sendable = bl2;
        jrGenClass.stripVoid(this.args);
        this.createArgList(this.args);
    }

    public void addSource(ClassFile classFile) {
        if (classFile == null) {
            return;
        }
        this.sources.put(classFile.getAbsoluteName(), classFile);
        jrGenClass.addBinarySource(classFile);
    }

    public static void addBinarySource(ClassFile classFile) {
        if (classFile == null) {
            return;
        }
        binarySources.put(classFile.getAbsoluteName(), classFile);
    }

    public Hashtable getSources() {
        return this.sources;
    }

    public String getKey() {
        return this.hashkey;
    }

    public void jrPrint(Environment environment) {
        Enumeration enumeration = this.sources.elements();
        while (enumeration.hasMoreElements()) {
            ClassFile classFile = (ClassFile)enumeration.nextElement();
            String string = this.hashkey + ".java";
            try {
                int n = classFile.getPath().lastIndexOf(File.separatorChar);
                String string2 = n != -1 ? classFile.getPath().substring(0, n) + "/" + subdirName + "/" : "jrGen/";
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                file = new File(file, string);
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
                this.emitCode(new PrintStream(fileOutputStream));
                fileOutputStream.close();
            }
            catch (Exception exception) {
                environment.error(0L, "bad.filename", string);
            }
        }
    }

    private static void stripVoid(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (((String)vector.elementAt(i - n2)).compareTo("void") != 0) continue;
            vector.remove(i - n2);
            ++n2;
        }
    }

    private void createArgList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector != null ? vector.size() : 0;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)vector.elementAt(i));
            stringBuffer.append(" arg" + i);
        }
        this.arglist = stringBuffer.toString();
    }

    public boolean isCallable() {
        return this.callable;
    }

    public void setCallable(boolean bl) {
        this.callable = bl;
    }

    public boolean isSendable() {
        return this.sendable;
    }

    public void setSendable(boolean bl) {
        this.sendable = bl;
    }

    public String getRet() {
        return this.ret;
    }

    public String getJrRet() {
        return this.jrret;
    }

    public void setRet(String string) {
        this.ret = string;
    }

    public void setJrRet(String string) {
        this.jrret = string;
    }

    public boolean doCasts() {
        return false;
    }

    public void setCasts(boolean bl) {
    }

    protected abstract void emitCode(PrintStream var1);

    public static void emitDefaultValue(PrintStream printStream, String string) {
        String string2 = "null";
        if (string.compareTo("boolean") == 0) {
            string2 = "false";
        } else if (string.compareTo("char") == 0) {
            string2 = "'\\0'";
        } else if (string.compareTo("byte") == 0) {
            string2 = "0";
        } else if (string.compareTo("short") == 0) {
            string2 = "0";
        } else if (string.compareTo("int") == 0) {
            string2 = "0";
        } else if (string.compareTo("long") == 0) {
            string2 = "0";
        } else if (string.compareTo("float") == 0) {
            string2 = "0.0F";
        } else if (string.compareTo("double") == 0) {
            string2 = "0.0";
        } else if (string.compareTo("void") == 0) {
            string2 = "";
        }
        printStream.print(string2);
    }

    public static void printClassTypes(PrintStream printStream, Expression[] expressionArray) {
        for (int i = 0; i < expressionArray.length; ++i) {
            if (i > 0) {
                printStream.print(", ");
            }
            if (expressionArray[i] != null) {
                if (jrGenClass.isPrimitive(expressionArray[i].getType().getTypeCode())) {
                    printStream.print(jrGenClass.jrPrimitiveString(expressionArray[i].getType().getTypeCode()));
                } else {
                    printStream.print(expressionArray[i].getType().jrTypeString("", false, false));
                }
                printStream.print(".class");
                continue;
            }
            printStream.print("");
        }
    }

    public static void printObjectValuesWhere(PrintStream printStream, Expression[] expressionArray, Type[] typeArray, Expression[] expressionArray2) {
        for (int i = 0; i < expressionArray.length; ++i) {
            if (i > 0) {
                printStream.print(", ");
            }
            if (expressionArray[i] != null) {
                if (jrGenClass.isPrimitive(expressionArray[i].getType().getTypeCode())) {
                    printStream.print("new " + jrGenClass.primitiveString(expressionArray[i].getType().getTypeCode()) + "(");
                    expressionArray[i].jrPrintWhere(printStream, expressionArray[i].getWhere());
                    printStream.print(")");
                    continue;
                }
                if (typeArray[i].isType(15)) {
                    Node.printCapConversion(typeArray[i], expressionArray2[i], expressionArray[i], printStream, expressionArray[i].getWhere(), true, true);
                    continue;
                }
                expressionArray[i].jrPrintWhere(printStream, expressionArray[i].getWhere());
                continue;
            }
            printStream.print("");
        }
    }

    public static void printObjectValues(PrintStream printStream, Expression[] expressionArray, Type[] typeArray, Expression[] expressionArray2) {
        for (int i = 0; i < expressionArray.length; ++i) {
            if (i > 0) {
                printStream.print(", ");
            }
            if (expressionArray[i] != null) {
                if (jrGenClass.isPrimitive(expressionArray[i].getType().getTypeCode())) {
                    printStream.print("new " + jrGenClass.primitiveString(expressionArray[i].getType().getTypeCode()) + "(");
                    expressionArray[i].jrPrint(printStream);
                    printStream.print(")");
                    continue;
                }
                if (typeArray[i].isType(15)) {
                    Node.printCapConversion(typeArray[i], expressionArray2[i], expressionArray[i], printStream, 0L, false, true);
                    continue;
                }
                expressionArray[i].jrPrint(printStream);
                continue;
            }
            printStream.print("");
        }
    }

    public static boolean isPrimitive(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static String jrPrimitiveString(int n) {
        switch (n) {
            case 11: {
                return "jrVoid";
            }
            case 0: {
                return "jrBoolean";
            }
            case 1: {
                return "jrByte";
            }
            case 2: {
                return "jrChar";
            }
            case 3: {
                return "jrShort";
            }
            case 4: {
                return "jrInt";
            }
            case 6: {
                return "jrFloat";
            }
            case 5: {
                return "jrLong";
            }
            case 7: {
                return "jrDouble";
            }
        }
        return "<err>";
    }

    public static String primitiveString(int n) {
        switch (n) {
            case 11: {
                return "Void";
            }
            case 0: {
                return "Boolean";
            }
            case 1: {
                return "Byte";
            }
            case 2: {
                return "Char";
            }
            case 3: {
                return "Short";
            }
            case 4: {
                return "Integer";
            }
            case 6: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 7: {
                return "Double";
            }
        }
        return "<err>";
    }
}

