/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.InStatMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class BreakStatement
extends Statement {
    Identifier lbl;
    private String loopLabel = null;
    private boolean isInStat = false;
    private int loopNumber;
    private int scopeNumber;

    public BreakStatement(long l, String string, Identifier identifier) {
        super(98, l, string);
        this.lbl = identifier;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        Constants constants;
        boolean bl = vset.justReplied();
        this.reach(environment, vset);
        this.checkLabel(environment, context);
        CheckContext checkContext = (CheckContext)new CheckContext(context, this).getBreakContext(this.lbl);
        if (checkContext != null) {
            if (checkContext.frameNumber != context.frameNumber) {
                environment.error(this.where, "branch.to.uplevel", this.lbl);
            }
            checkContext.vsBreak = checkContext.vsBreak.join(vset);
        } else if (this.lbl != null) {
            environment.error(this.where, "label.not.found", this.lbl);
        } else {
            environment.error(this.where, "invalid.break");
        }
        this.loopLabel = checkContext.getJRLabel();
        if (context.isInStat() && (!checkContext.isInStat() || context.field != checkContext.field)) {
            this.loopNumber = ((InStatMember)context.field).getLoopNumber();
            this.scopeNumber = ((InStatMember)context.field).getScopeNumber();
            if (context.field.getType().getReturnType().isType(11)) {
                this.isInStat = true;
            }
            if (context.isInStat() && !context.field.getType().getReturnType().isType(11) && vset != null && !vset.isDeadEnd()) {
                environment.error(context.field.getWhere(), "break.return.required.at.end", context.field, new Long(this.where >> 32));
            }
            if (context != checkContext && context.field != checkContext.field) {
                constants = context.field;
                Vset vset2 = context.field.getVset();
                Context context2 = context.prev;
                while (context2 != null && context2 != checkContext && context2.field != null && context2.field != checkContext.field) {
                    if (context2.field == constants) {
                        vset2 = context2.field.getVset();
                    } else {
                        if (context2.isInStat() && !context2.field.getType().getReturnType().isType(11) && vset2 != null && !vset2.isDeadEnd()) {
                            environment.error(context2.field.getWhere(), "continue.return.required.at.end", context2.field, new Long(this.where >> 32));
                        }
                        constants = context2.field;
                        vset2 = context2.field.getVset();
                    }
                    context2 = context2.prev;
                }
            }
        }
        if ((constants = context.getTryExitContext()) != null) {
            constants.vsTryExit = constants.vsTryExit.join(vset);
        }
        if (bl) {
            return REPLIED_DEAD_END;
        }
        return DEAD_END;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        if (this.isInStat) {
            printStream.print("{ if (");
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.println("retOp != null)");
            super.printIndent(printStream, n + 1);
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.print("retOp.send(jrvm.getTimestamp());");
        }
        printStream.print("break");
        if (this.lbl != null) {
            printStream.print(" " + this.lbl);
        } else {
            printStream.print(" " + this.loopLabel);
        }
        printStream.print(";");
        if (this.isInStat) {
            printStream.print("}");
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        if (this.isInStat) {
            printStream.print("{ if (");
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.println("retOp != null)");
            super.printIndent(printStream, n + 1);
            printStream.print("JRrrecv_" + this.scopeNumber + ".");
            printStream.print("retOp.send(jrvm.getTimestamp());");
        }
        super.jrPrint(printStream, n);
        printStream.print("break");
        if (this.lbl != null) {
            printStream.print(" " + this.lbl);
        } else if (this.loopLabel != null) {
            printStream.print(" " + this.loopLabel);
        }
        printStream.print(";");
        if (this.isInStat) {
            printStream.print("}");
        }
    }
}

