/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.jrx.RemoteInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

public class ProxyInputStream
extends InputStream {
    RemoteInputStream rin;

    public ProxyInputStream(RemoteInputStream remoteInputStream) {
        this.rin = remoteInputStream;
    }

    public int available() throws IOException {
        try {
            return this.rin.available();
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            this.rin.close();
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void mark(int n) {
        try {
            this.rin.mark(n);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        try {
            return this.rin.markSupported();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int read() throws IOException {
        try {
            return this.rin.read();
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("null buffer");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            RemoteInputStream.readResult readResult2 = this.rin.read(n2);
            if (readResult2.ret > 0) {
                System.arraycopy(readResult2.buf, 0, byArray, n, n2);
            }
            return readResult2.ret;
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void reset() throws IOException {
        try {
            this.rin.reset();
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }

    public long skip(long l) throws IOException {
        try {
            return this.rin.skip(l);
        }
        catch (RemoteException remoteException) {
            throw new IOException("RemoteException: " + remoteException.getMessage());
        }
    }
}

