/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List<A>
implements Collection<A> {
    public A head;
    public List<A> tail;
    private static Iterator EMPTYITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public List(A a, List<A> list) {
        this.tail = list;
        this.head = a;
    }

    public List() {
        this(null, null);
    }

    public static <A> List<A> make() {
        return new List<A>();
    }

    public static <A> List<A> make(A a) {
        return new List<A>(a, new List<A>());
    }

    public static <A> List<A> make(A a, A a2) {
        return new List<A>(a, new List<A>(a2, new List<A>()));
    }

    public static <A> List<A> make(A a, A a2, A a3) {
        return new List<A>(a, new List<A>(a2, new List<A>(a3, new List<A>())));
    }

    public static <A> List<A> make(A[] AArray) {
        List<A> list = new List<A>();
        for (int i = AArray.length - 1; i >= 0; --i) {
            list = new List<A>(AArray[i], list);
        }
        return list;
    }

    public static <A> List<A> make(int n, A a) {
        List<A> list = new List<A>();
        for (int i = 0; i < n; ++i) {
            list = new List<A>(a, list);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> list = this;
        int n = 0;
        while (list.tail != null) {
            list = list.tail;
            ++n;
        }
        return n;
    }

    @Override
    public int size() {
        return this.length();
    }

    public List<A> prepend(A a) {
        return new List<A>(a, this);
    }

    public List<A> prependList(List<A> list) {
        if (this.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return this;
        }
        List<A> list2 = this;
        list = list.reverse();
        while (list.nonEmpty()) {
            List<A> list3 = list;
            list = list.tail;
            list3.tail = list2;
            list2 = list3;
        }
        return list2;
    }

    public List<A> reverse() {
        List<A> list = new List<A>();
        List<A> list2 = this;
        while (list2.nonEmpty()) {
            list = new List<A>(list2.head, list);
            list2 = list2.tail;
        }
        return list;
    }

    public List<A> append(A a) {
        return List.make(a).prependList(this);
    }

    public List<A> appendList(List<A> list) {
        return list.prependList(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        List<A> list = this;
        T[] TArray2 = TArray;
        for (int i = 0; list.nonEmpty() && i < TArray.length; ++i) {
            TArray2[i] = list.head;
            list = list.tail;
        }
        return TArray;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public String toString(String string) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.head);
        List<A> list = this.tail;
        while (list.nonEmpty()) {
            stringBuffer.append(string);
            stringBuffer.append(list.head);
            list = list.tail;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(",");
    }

    @Override
    public int hashCode() {
        List<A> list = this;
        int n = 0;
        while (list.tail != null) {
            n = n * 41 + (this.head != null ? this.head.hashCode() : 0);
            list = list.tail;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof List && List.equals(this, (List)object);
    }

    public static boolean equals(List list, List list2) {
        while (list.tail != null && list2.tail != null) {
            if (list.head == null ? list2.head != null : !list.head.equals(list2.head)) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    @Override
    public boolean contains(Object object) {
        List<A> list = this;
        while (list.tail != null) {
            if (object == null ? list.head == null : list.head.equals(object)) {
                return true;
            }
            list = list.tail;
        }
        return false;
    }

    public A last() {
        A a = null;
        List<A> list = this;
        while (list.tail != null) {
            a = list.head;
            list = list.tail;
        }
        return a;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.tail == null) {
            return EMPTYITERATOR;
        }
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = List.this;
            }

            @Override
            public boolean hasNext() {
                return this.elems.tail != null;
            }

            @Override
            public A next() {
                Object a = this.elems.head;
                this.elems = this.elems.tail;
                return a;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends A> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

