/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.util;

import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Log;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private final Log log;
    private final Options options;
    private boolean warn;
    private Path bootClassPath;
    private Path userClassPath;
    private Path sourcePath;
    private boolean inited = false;
    private Path sourceSearchPath;
    private Path classSearchPath;

    public static Paths instance(Context context) {
        Paths paths = context.get(pathsKey);
        if (paths == null) {
            paths = new Paths(context);
        }
        return paths;
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.log = Log.instance(context);
        this.options = Options.instance(context);
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.options.lint("path");
            this.bootClassPath = this.computeBootClassPath();
            this.userClassPath = this.computeUserClassPath();
            this.sourcePath = this.computeSourcePath();
            this.inited = true;
            if (this.options.get("-verbose") != null) {
                this.printVerbose("sourcepath", this.sourceSearchPath().toString());
                this.printVerbose("classpath", this.classSearchPath().toString());
            }
        }
    }

    public Collection<String> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.bootClassPath);
    }

    public Collection<String> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.userClassPath);
    }

    public Collection<String> sourcePath() {
        this.lazy();
        return this.sourcePath == null ? null : Collections.unmodifiableCollection(this.sourcePath);
    }

    private Path computeBootClassPath() {
        Path path = new Path();
        path.addFiles((String)this.options.get("-Xbootclasspath/p:"));
        String string = (String)this.options.get("-endorseddirs");
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        string = (String)this.options.get("-bootclasspath");
        if (string != null) {
            path.addFiles(string);
        } else {
            path.addFiles(System.getProperty("sun.boot.class.path"), false);
        }
        path.addFiles((String)this.options.get("-Xbootclasspath/a:"));
        string = (String)this.options.get("-extdirs");
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        return path;
    }

    private Path computeUserClassPath() {
        String string = (String)this.options.get("-classpath");
        if (string == null) {
            string = System.getProperty("env.class.path");
        }
        if (string == null && System.getProperty("application.home") == null) {
            string = System.getProperty("java.class.path");
        }
        if (string == null) {
            string = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(".").addFiles(string);
    }

    private Path computeSourcePath() {
        String string = (String)this.options.get("-sourcepath");
        if (string == null) {
            return null;
        }
        return new Path().addFiles(string);
    }

    public Collection<String> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            this.sourceSearchPath = this.sourcePath != null ? this.sourcePath : this.userClassPath;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<String> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(this.bootClassPath);
            this.classSearchPath.addAll(this.userClassPath);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    private static boolean isZip(String string) {
        return new File(string).isFile();
    }

    private void printVerbose(String string, String string2) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, string2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Path
    extends LinkedHashSet<String> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private String emptyPathDefault = null;

        public Path expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public Path emptyPathDefault(String string) {
            this.emptyPathDefault = string;
            return this;
        }

        public Path addDirectories(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string)) {
                    this.addDirectory(string2, bl);
                }
            }
            return this;
        }

        public Path addDirectories(String string) {
            return this.addDirectories(string, Paths.this.warn);
        }

        private void addDirectory(String string, boolean bl) {
            if (!new File(string).isDirectory()) {
                if (bl) {
                    Paths.this.log.warning(0, "dir.path.element.not.found", string);
                }
                return;
            }
            for (String string2 : new File(string).list()) {
                String string3 = string2.toLowerCase();
                if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
                this.addFile(string + File.separator + string2, bl);
            }
        }

        public Path addFiles(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string, this.emptyPathDefault)) {
                    this.addFile(string2, bl);
                }
            }
            return this;
        }

        public Path addFiles(String string) {
            return this.addFiles(string, Paths.this.warn);
        }

        private void addFile(String string, boolean bl) {
            if (!this.contains(string)) {
                if (!new File(string).exists()) {
                    if (bl) {
                        Paths.this.log.warning(0, "path.element.not.found", string);
                    }
                } else {
                    super.add(string);
                    if (this.expandJarClassPaths && Paths.isZip(string)) {
                        this.addJarClassPath(string, bl);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addJarClassPath(String string, boolean bl) {
            try {
                String string2 = new File(string).getParent();
                JarFile jarFile = new JarFile(string);
                try {
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null) {
                        return;
                    }
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null) {
                        return;
                    }
                    String string3 = attributes.getValue(Attributes.Name.CLASS_PATH);
                    if (string3 == null) {
                        return;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string2 != null) {
                            string4 = new File(string2, string4).toString();
                        }
                        this.addFile(string4, bl);
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Paths.this.log.error(0, "error.reading.file", string, iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathIterator
    implements Collection<String> {
        private int pos = 0;
        private final String path;
        private final String emptyPathDefault;

        public PathIterator(String string, String string2) {
            this.path = string;
            this.emptyPathDefault = string2;
        }

        public PathIterator(String string) {
            this(string, null);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return PathIterator.this.pos <= PathIterator.this.path.length();
                }

                @Override
                public String next() {
                    int n = PathIterator.this.pos;
                    int n2 = PathIterator.this.path.indexOf(File.pathSeparator, n);
                    if (n2 == -1) {
                        n2 = PathIterator.this.path.length();
                    }
                    PathIterator.this.pos = n2 + 1;
                    if (n == n2 && PathIterator.this.emptyPathDefault != null) {
                        return PathIterator.this.emptyPathDefault;
                    }
                    return PathIterator.this.path.substring(n, n2);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends String> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

