/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.jvm;

import edu.ucdavis.jr.trans.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    int pp;
    Object[] pool;
    Map<Object, Integer> indices;

    public Pool(int n, Object[] objectArray) {
        this.pp = n;
        this.pool = objectArray;
        this.indices = new HashMap<Object, Integer>(objectArray.length);
        for (int i = 1; i < n; ++i) {
            if (objectArray[i] == null) continue;
            this.indices.put(objectArray[i], i);
        }
    }

    public Pool() {
        this(1, new Object[64]);
    }

    public int numEntries() {
        return this.pp;
    }

    public void reset() {
        this.pp = 1;
        this.indices.clear();
    }

    private void doublePool() {
        Object[] objectArray = new Object[this.pool.length * 2];
        System.arraycopy(this.pool, 0, objectArray, 0, this.pool.length);
        this.pool = objectArray;
    }

    public int put(Object object) {
        if (object instanceof Symbol.MethodSymbol) {
            object = new Method((Symbol.MethodSymbol)object);
        } else if (object instanceof Symbol.VarSymbol) {
            object = new Variable((Symbol.VarSymbol)object);
        }
        Integer n = this.indices.get(object);
        if (n == null) {
            n = this.pp;
            this.indices.put(object, n);
            if (this.pp == this.pool.length) {
                this.doublePool();
            }
            this.pool[this.pp++] = object;
            if (object instanceof Long || object instanceof Double) {
                if (this.pp == this.pool.length) {
                    this.doublePool();
                }
                this.pool[this.pp++] = null;
            }
        }
        return n;
    }

    public int get(Object object) {
        Integer n = this.indices.get(object);
        return n == null ? -1 : n;
    }

    static class Variable
    extends Symbol.DelegatedSymbol {
        Symbol.VarSymbol v;

        Variable(Symbol.VarSymbol varSymbol) {
            super(varSymbol);
            this.v = varSymbol;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Variable)) {
                return false;
            }
            Symbol.VarSymbol varSymbol = ((Variable)object).v;
            return varSymbol.name == this.v.name && varSymbol.owner == this.v.owner && varSymbol.type.equals(this.v.type);
        }

        public int hashCode() {
            return this.v.name.hashCode() * 33 + this.v.owner.hashCode() * 9 + this.v.type.hashCode();
        }
    }

    static class Method
    extends Symbol.DelegatedSymbol {
        Symbol.MethodSymbol m;

        Method(Symbol.MethodSymbol methodSymbol) {
            super(methodSymbol);
            this.m = methodSymbol;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Method)) {
                return false;
            }
            Symbol.MethodSymbol methodSymbol = ((Method)object).m;
            return methodSymbol.name == this.m.name && methodSymbol.owner == this.m.owner && methodSymbol.type.equals(this.m.type);
        }

        public int hashCode() {
            return this.m.name.hashCode() * 33 + this.m.owner.hashCode() * 9 + this.m.type.hashCode();
        }
    }
}

