/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.main;

import edu.ucdavis.jr.trans.sun.tools.javac.code.Source;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Symbol;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Symtab;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Types;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Annotate;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Attr;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.AttrContext;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Check;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Enter;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Env;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Flow;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Lower;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.Todo;
import edu.ucdavis.jr.trans.sun.tools.javac.comp.TransTypes;
import edu.ucdavis.jr.trans.sun.tools.javac.jrgen.jrBinaryProxy;
import edu.ucdavis.jr.trans.sun.tools.javac.jrgen.jrGenClass;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.ClassReader;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.ClassWriter;
import edu.ucdavis.jr.trans.sun.tools.javac.jvm.Gen;
import edu.ucdavis.jr.trans.sun.tools.javac.parser.Parser;
import edu.ucdavis.jr.trans.sun.tools.javac.parser.Scanner;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.Pretty;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.Tree;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.TreeMaker;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.TreeTranslator;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Abort;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.List;
import edu.ucdavis.jr.trans.sun.tools.javac.util.ListBuffer;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Log;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Name;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    Log log;
    TreeMaker make;
    ClassReader reader;
    ClassWriter writer;
    Enter enter;
    Symtab syms;
    Source source;
    Gen gen;
    Name.Table names;
    Attr attr;
    Check chk;
    Flow flow;
    TransTypes transTypes;
    Lower lower;
    Annotate annotate;
    final Name completionFailureName;
    Types types;
    Scanner.Factory scannerFactory;
    Parser.Factory parserFactory;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public String encoding;
    private Todo todo;
    Set<File> inputFiles = new HashSet<File>();
    private boolean hasBeenUsed = false;

    public static JavaCompiler instance(Context context) {
        JavaCompiler javaCompiler = context.get(compilerKey);
        if (javaCompiler == null) {
            javaCompiler = new JavaCompiler(context);
        }
        return javaCompiler;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.parserFactory = Parser.Factory.instance(context);
        this.scannerFactory = Scanner.Factory.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(0, completionFailure.getMessage(), new Object[0]);
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.lint("deprecation");
        this.warnunchecked = options.lint("unchecked");
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.add(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", string);
            return null;
        }
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(this.names.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = this.scannerFactory.newScanner(inputStream, this.encoding);
                inputStream.close();
                Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, "error.reading.file", string, iOException);
            }
        }
        this.log.useSource(name);
        topLevel.sourcefile = this.names.fromString(string);
        return topLevel;
    }

    protected boolean keepComments() {
        return this.sourceOutput || this.stubOutput;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        File file = this.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file);
        } else {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            try {
                new Pretty(printWriter, true).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
            }
            finally {
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printJRSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        Object object;
        File file = this.writer.JRoutputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file);
        } else {
            object = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            try {
                new Pretty((PrintWriter)object, true).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
            }
            finally {
                ((PrintWriter)object).close();
            }
        }
        object = new jrBinaryProxy(this.types, "JRjavadotlangdotObject", false, null, null);
        jrGenClass.addJrClass("JRjavadotlangdotObject", (jrGenClass)object);
        List<jrGenClass> list = jrGenClass.getJrClasses();
        while (list.nonEmpty()) {
            jrGenClass jrGenClass2 = (jrGenClass)list.head;
            file = this.writer.JRoutputFile(jrGenClass2.hashkey);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            jrGenClass2.printJRSource(printWriter);
            printWriter.close();
            list = list.tail;
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        try {
            if (this.gen.genClass(env, classDef)) {
                this.writer.writeClass(classDef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow poolOverflow) {
            this.log.error(classDef.pos, "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow stringOverflow) {
            this.log.error(classDef.pos, "limit.string.overflow", stringOverflow.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(0, completionFailure.getMessage(), new Object[0]);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.complete(List.make(topLevel), classSymbol);
        if (this.enter.getEnv(classSymbol) == null) {
            throw new ClassReader.BadClassFile(classSymbol, string, Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Symbol.ClassSymbol> compile(List<String> var1_1) throws Throwable {
        if (!JavaCompiler.$assertionsDisabled && this.hasBeenUsed) {
            throw new AssertionError((Object)"attempt to reuse JavaCompiler");
        }
        this.hasBeenUsed = true;
        var2_2 = 0;
        var3_3 = System.currentTimeMillis();
        var5_4 = new ListBuffer<A>();
        try {
            var6_5 = new ListBuffer<Tree.TopLevel>();
            var7_8 = var1_1;
            while (var7_8.nonEmpty()) {
                var6_5.append(this.parse((String)var7_8.head));
                var7_8 = var7_8.tail;
            }
            var7_8 = var6_5.toList();
            if (this.errorCount() == 0) {
                this.enter.main(var7_8);
            }
            var8_9 = null;
            if (this.sourceOutput || this.stubOutput) {
                var9_10 = new ListBuffer<Tree.ClassDef>();
                var10_11 = var7_8;
                while (var10_11.nonEmpty()) {
                    var11_12 = ((Tree.TopLevel)var10_11.head).defs;
                    while (var11_12.nonEmpty()) {
                        if (var11_12.head instanceof Tree.ClassDef) {
                            var9_10.append((Tree.ClassDef)var11_12.head);
                        }
                        var11_12 = var11_12.tail;
                    }
                    var10_11 = var10_11.tail;
                }
                var8_9 = var9_10.toList();
            }
            var9_10 = new ListBuffer<A>();
            var10_11 = var7_8;
            while (var10_11.nonEmpty()) {
                var11_12 = ((Tree.TopLevel)var10_11.head).defs;
                while (var11_12.nonEmpty()) {
                    if (var11_12.head instanceof Tree.ClassDef) {
                        var9_10.append((Tree.ClassDef)var11_12.head);
                    }
                    var11_12 = var11_12.tail;
                }
                var10_11 = var10_11.tail;
            }
            var8_9 = var9_10.toList();
            if (this.todo.isEmpty() && this.errorCount() != 0) {
                Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen.all", new Object[0]));
            }
            while (this.todo.nonEmpty()) {
                var9_10 = (Env)this.todo.next();
                var10_11 = var9_10.tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", var9_10.enclClass.sym);
                }
                var11_12 = this.log.useSource(var9_10.enclClass.sym.sourcefile);
                this.attr.attribClass(var9_10.tree.pos, var9_10.enclClass.sym);
                if (this.attrParseOnly) continue;
                this.make.at(1025);
                var12_13 = this.make.forToplevel(var9_10.toplevel);
                if (this.errorCount() == 0 && !this.relax) {
                    this.flow.analyzeTree(var9_10.tree, var12_13);
                }
                var13_14 = null;
                try {
                    if (this.errorCount() != 0) ** GOTO lbl132
                    if (!(var9_10.tree instanceof Tree.TopLevel)) ** GOTO lbl-1000
                    var14_15 = this.lower.translateTopLevelClass((Env<AttrContext>)var9_10, var9_10.tree, var12_13);
                    if (var14_15.head != null) {
                        if (!JavaCompiler.$assertionsDisabled && !var14_15.tail.isEmpty()) {
                            throw new AssertionError();
                        }
                        this.genCode((Env<AttrContext>)var9_10, (Tree.ClassDef)var14_15.head);
                    }
                    if ((var15_21 = this.errorCount()) == 0 || var2_2 == var15_21) ** GOTO lbl91
                    ** GOTO lbl89
                }
                catch (IOException var14_20) {
                    block37: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        try {
                                            this.log.error(var13_14.pos, "class.cant.write", new Object[]{var13_14.sym, var14_20.getMessage()});
                                            var14_19 = this.errorCount();
                                            if (var14_19 != 0 && var2_2 != var14_19) {
                                            }
                                            break block37;
                                        }
                                        catch (Throwable var16_22) {
                                            var17_23 = this.errorCount();
                                            if (var17_23 != 0 && var2_2 != var17_23) {
                                                Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                                                var2_2 = var17_23;
                                            }
                                            this.log.useSource((Name)var11_12);
                                            throw var16_22;
                                        }
lbl89:
                                        // 1 sources

                                        Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                                        var2_2 = var15_21;
lbl91:
                                        // 2 sources

                                        this.log.useSource((Name)var11_12);
                                        continue;
lbl-1000:
                                        // 1 sources

                                        {
                                            if (!this.stubOutput) ** GOTO lbl-1000
                                            var13_14 = (Tree.ClassDef)var9_10.tree;
                                            if (var10_11 instanceof Tree.ClassDef && var8_9.contains((Tree.ClassDef)var10_11) && ((var13_14.mods.flags & 5L) != 0L || var13_14.sym.packge().fullName() == this.names.java_lang)) {
                                                this.printSource((Env<AttrContext>)var9_10, this.removeMethodBodies(var13_14));
                                            }
                                            if ((var14_16 = this.errorCount()) == 0 || var2_2 == var14_16) break block38;
                                        }
                                        Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                                        var2_2 = var14_16;
                                    }
                                    this.log.useSource((Name)var11_12);
                                    continue;
lbl-1000:
                                    // 1 sources

                                    {
                                        var9_10.tree = this.transTypes.translateTopLevelClass(var9_10.tree, var12_13);
                                        if (this.errorCount() == 0) ** GOTO lbl-1000
                                        var14_17 = this.errorCount();
                                        if (var14_17 == 0 || var2_2 == var14_17) break block39;
                                    }
                                    Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                                    var2_2 = var14_17;
                                }
                                this.log.useSource((Name)var11_12);
                                continue;
lbl-1000:
                                // 1 sources

                                {
                                    if (!this.sourceOutput) ** GOTO lbl-1000
                                    var13_14 = (Tree.ClassDef)var9_10.tree;
                                    if (var10_11 instanceof Tree.ClassDef && var8_9.contains((Tree.ClassDef)var10_11)) {
                                        this.printSource((Env<AttrContext>)var9_10, var13_14);
                                    }
                                    if ((var14_18 = this.errorCount()) == 0 || var2_2 == var14_18) break block40;
                                }
                                Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                                var2_2 = var14_18;
                            }
                            this.log.useSource((Name)var11_12);
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                var13_14 = (Tree.ClassDef)var9_10.tree;
                                if (!(var10_11 instanceof Tree.ClassDef) || !var8_9.contains((Tree.ClassDef)var10_11)) break block41;
                                this.printJRSource((Env<AttrContext>)var9_10, var13_14);
                            }
                        }
                        if ((var14_19 = this.errorCount()) != 0 && var2_2 != var14_19) {
                            Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                            var2_2 = var14_19;
                        }
                        this.log.useSource((Name)var11_12);
                        continue;
                        Log.printLines(this.log.errWriter, Log.getLocalizedString("jr.not.gen", new Object[]{((Tree.ClassDef)var9_10.tree).name.toString() + ".java"}));
                        var2_2 = var14_19;
                    }
                    this.log.useSource((Name)var11_12);
                }
            }
        }
        catch (Abort var6_6) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - var3_3));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource);
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.makeNotes(this.chk.uncheckedSource.toString());
        }
        if ((var6_7 = this.errorCount()) == 1) {
            this.printCount("error", var6_7);
        } else {
            this.printCount("error.plural", var6_7);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
            return var5_4.toList();
        }
        this.printCount("warn.plural", this.log.nwarnings);
        return var5_4.toList();
    }

    Tree.ClassDef removeMethodBodies(Tree.ClassDef classDef) {
        final boolean bl = (classDef.mods.flags & 0x200L) != 0L;
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(Tree.MethodDef methodDef) {
                methodDef.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef varDef : methodDef.params) {
                    varDef.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                methodDef.body = null;
                super.visitMethodDef(methodDef);
            }

            @Override
            public void visitOperationDef(Tree.OperationDef operationDef) {
                operationDef.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef varDef : operationDef.params) {
                    varDef.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                operationDef.body = null;
                super.visitOperationDef(operationDef);
            }

            @Override
            public void visitVarDef(Tree.VarDef varDef) {
                if (varDef.init != null && varDef.init.type.constValue == null) {
                    varDef.init = null;
                }
                super.visitVarDef(varDef);
            }

            @Override
            public void visitClassDef(Tree.ClassDef classDef) {
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                List<Tree> list = classDef.defs;
                while (list.tail != null) {
                    Tree tree = (Tree)list.head;
                    switch (tree.tag) {
                        case 4: {
                            if (!bl && (((Tree.ClassDef)tree).mods.flags & 5L) == 0L && ((((Tree.ClassDef)tree).mods.flags & 2L) != 0L || ((Tree.ClassDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 5: {
                            if (!bl && (((Tree.MethodDef)tree).mods.flags & 5L) == 0L && ((Tree.MethodDef)tree).sym.name != JavaCompiler.this.names.init && ((((Tree.MethodDef)tree).mods.flags & 2L) != 0L || ((Tree.MethodDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 6: {
                            if (!bl && (((Tree.OperationDef)tree).mods.flags & 5L) == 0L && ((Tree.OperationDef)tree).sym.name != JavaCompiler.this.names.init && ((((Tree.OperationDef)tree).mods.flags & 2L) != 0L || ((Tree.OperationDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 10: {
                            if (!bl && (((Tree.VarDef)tree).mods.flags & 5L) == 0L && ((((Tree.VarDef)tree).mods.flags & 2L) != 0L || ((Tree.VarDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                    }
                    list = list.tail;
                }
                classDef.defs = listBuffer.toList();
                super.visitClassDef(classDef);
            }
        }
        MethodBodyRemover methodBodyRemover = new MethodBodyRemover();
        return (Tree.ClassDef)methodBodyRemover.translate(classDef);
    }

    public void close() {
        this.log.flush();
        this.reader.close();
        this.names.dispose();
    }

    private void printVerbose(String string, Object object) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, object));
    }

    private void noteDeprecated(Object object) {
        if (object.equals("*")) {
            this.log.note("deprecated.plural", new Object[0]);
        } else {
            this.log.note("deprecated.filename", object);
        }
        this.log.note("deprecated.recompile", new Object[0]);
    }

    void makeNotes(Object object) {
        if (object.toString().equals("*")) {
            this.log.note("unchecked.plural", new Object[0]);
        } else {
            this.log.note("unchecked.filename", object);
        }
        this.log.note("unchecked.recompile", new Object[0]);
    }

    void printCount(String string, int n) {
        if (n != 0) {
            Log.printLines(this.log.errWriter, Log.getLocalizedString("count." + string, Integer.toString(n)));
            this.log.errWriter.flush();
        }
    }
}

