/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.jvm;

import edu.ucdavis.jr.trans.sun.tools.javac.code.Symbol;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public enum Target {
    CLDC1_0("cldc1.0", 45, 3),
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JSR14("jsr14", 48, 0),
    JDK1_4_1("1.4.1", 48, 0),
    JDK1_4_2("1.4.2", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0);

    protected static final Context.Key<Target> targetKey;
    private static Target MIN;
    private static Target MAX;
    private static Map<String, Target> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final Target DEFAULT;

    public static Target instance(Context context) {
        Target target = context.get(targetKey);
        if (target == null) {
            Options options = Options.instance(context);
            String string = (String)options.get("-target");
            if (string != null) {
                target = Target.lookup(string);
            }
            if (target == null) {
                target = DEFAULT;
            }
            context.put(targetKey, target);
        }
        return target;
    }

    public static Target MIN() {
        return MIN;
    }

    public static Target MAX() {
        return MAX;
    }

    private Target(String string2, int n2, int n3) {
        this.name = string2;
        this.majorVersion = n2;
        this.minorVersion = n3;
    }

    public static Target lookup(String string) {
        return tab.get(string);
    }

    public boolean requiresIproxy() {
        return this.compareTo(JDK1_1) <= 0;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean obeyBinaryCompatibility() {
        return this.compareTo(JDK1_2) >= 0;
    }

    public boolean arrayBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.compareTo(JDK1_2) > 0;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean usePrivateSyntheticFields() {
        return this.compareTo(JDK1_4_2) < 0;
    }

    public boolean useInnerCacheClass() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean generateStackmap() {
        return this == CLDC1_0;
    }

    public boolean generateEmptyAfterBig() {
        return false;
    }

    public boolean useStringBuilder() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useSyntheticFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useEnumFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useAnnotationFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useVarargsFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useBridgeFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasClassLiterals() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean classLiteralsNoInit() {
        return this.compareTo(JDK1_4_2) >= 0;
    }

    public boolean hasInitCause() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean boxWithConstructors() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean hasIterable() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean compilerBootstrap(Symbol symbol) {
        return this == JSR14 && (symbol.flags() & 0x4000L) != 0L && symbol.flatName().toString().startsWith("edu.ucdavis.jr.trans.sun.tools.");
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.compareTo(JDK1_5) >= 0 || this == JSR14;
    }

    static {
        targetKey = new Context.Key();
        tab = new HashMap<String, Target>();
        for (Target target : Target.values()) {
            if (MIN == null) {
                MIN = target;
            }
            MAX = target;
            tab.put(target.name, target);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        DEFAULT = JDK1_4;
    }
}

