/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.jrx.RemoteLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class RemoteLoader_impl
extends UnicastRemoteObject
implements RemoteLoader {
    static final long serialVersionUID = 0L;
    private static final String dotJar = ".jar";
    private static final char separatorChar = '/';
    Hashtable<String, byte[]> hash = new Hashtable();

    @Override
    public void unregister() throws RemoteException {
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.toString());
        }
    }

    @Override
    public byte[] getClass(String string) throws RemoteException {
        try {
            string = string.trim().replace('.', '/');
            byte[] byArray = this.hash.get(string);
            if (byArray != null) {
                return byArray;
            }
            String string2 = string.concat(".class");
            String string3 = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.length() > 4 && string4.endsWith(dotJar)) {
                    try {
                        byArray = this.readJar(string4, string2);
                        if (byArray == null) continue;
                        this.hash.put(string, byArray);
                        return byArray;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                try {
                    byArray = this.readFile(string4, string2);
                    if (byArray == null) continue;
                    this.hash.put(string, byArray);
                    return byArray;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            throw new RemoteException(exception.toString());
        }
        return null;
    }

    private byte[] readJar(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.exists() && file.canRead()) {
            JarFile jarFile = new JarFile(file, false);
            JarEntry jarEntry = jarFile.getJarEntry(string2);
            if (jarEntry == null) {
                return null;
            }
            long l = jarEntry.getSize();
            JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory() || !jarEntry.getName().equals(string2)) continue;
                int n = (int)(jarEntry.getSize() == -1L ? l : jarEntry.getSize());
                return this.readClass(jarInputStream, n);
            }
        }
        return null;
    }

    private byte[] readFile(String string, String string2) throws IOException {
        String string3 = string + "/" + string2;
        File file = new File(string3);
        if (file.exists() && file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.readClass(fileInputStream, ((InputStream)fileInputStream).available());
        }
        return null;
    }

    private byte[] readClass(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n - n2 > 0 && (n3 = inputStream.read(byArray, n2, n - n2)) != -1) {
            n2 += n3;
        }
        return byArray;
    }
}

