/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.rj;

import edu.ucdavis.rj.CLock;
import edu.ucdavis.rj.InLock;
import edu.ucdavis.rj.InLock_impl;
import edu.ucdavis.rj.InniArm;
import edu.ucdavis.rj.OpProxy;
import edu.ucdavis.rj.rjCommunicationException;
import edu.ucdavis.rj.rjRuntimeError;
import edu.ucdavis.rj.rjvm;
import java.rmi.RemoteException;
import java.util.ArrayList;

class InniLocker {
    public int N;
    private ArrayList<InniArm> armList;
    private CLock[] lockArray;
    private CLock masterLock;
    private boolean ecFormed;
    private boolean hasCap;
    private boolean quantified;
    private boolean cleared;

    public InniLocker(ArrayList<InniArm> arrayList) {
        this.armList = arrayList;
        this.N = arrayList.size();
        this.quantified = true;
        this.ecFormed = false;
        this.masterLock = null;
        this.lockArray = new CLock[this.N];
        this.hasCap = true;
        this.cleared = false;
        this.quantified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        try {
            boolean bl = false;
            if (!this.ecFormed || (this.hasCap || this.quantified) && this.capChanged()) {
                int n;
                this.masterLock = null;
                rjvm.sendAndDie();
                try {
                    rjvm.rjx.lockEC();
                }
                finally {
                    rjvm.ariseAndReceive();
                }
                for (n = 0; n < this.N; ++n) {
                    OpProxy opProxy = this.armList.get(n).getOpProxy();
                    this.lockArray[n] = new CLock(opProxy.getLock());
                    if (!opProxy.isRemote(rjvm.thisVM.getName())) continue;
                    bl = true;
                }
                CLock.markDuplicates(this.lockArray);
                try {
                    for (n = 0; n < this.N; ++n) {
                        if (this.lockArray[n].duplicate) continue;
                        rjvm.sendAndDie();
                        try {
                            this.lockArray[n].lockEC();
                        }
                        finally {
                            rjvm.ariseAndReceive();
                        }
                        if (this.lockArray[n].isRemoteLock && (this.masterLock == null || !this.masterLock.isRemoteLock || this.lockArray[n].numDupes > this.masterLock.numDupes)) {
                            this.masterLock = this.lockArray[n];
                            continue;
                        }
                        if (this.lockArray[n].isRemoteLock || this.masterLock != null && (this.masterLock.isRemoteLock || this.lockArray[n].numDupes <= this.masterLock.numDupes)) continue;
                        this.masterLock = this.lockArray[n];
                    }
                    if (bl) {
                        if (this.masterLock == null || !this.masterLock.isRemoteLock) {
                            this.masterLock = new CLock(rjvm.rjx.createRemoteLock());
                        }
                    } else if (this.masterLock == null) {
                        this.masterLock = new CLock(InniLocker.createLocalLock());
                    }
                    for (n = 0; n < this.N; ++n) {
                        if (this.lockArray[n].isDupeOf(this.masterLock) || this.lockArray[n].duplicate) continue;
                        rjvm.sendAndDie();
                        try {
                            this.lockArray[n].forwardTo(this.masterLock.getLock());
                            continue;
                        }
                        finally {
                            rjvm.ariseAndReceive();
                        }
                    }
                    this.equivClassFormed();
                    rjvm.sendAndDie();
                    try {
                        this.masterLock.unlockEC();
                    }
                    finally {
                        rjvm.ariseAndReceive();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new rjRuntimeError("error constructing equivalence class");
                }
                rjvm.sendAndDie();
                try {
                    rjvm.rjx.unlockEC();
                }
                finally {
                    rjvm.ariseAndReceive();
                }
            }
            rjvm.sendAndDie();
            try {
                this.masterLock.lock();
            }
            finally {
                rjvm.ariseAndReceive();
            }
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    public void unlock() {
        rjvm.sendAndDie();
        try {
            this.masterLock.unlock();
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
        finally {
            rjvm.ariseAndReceive();
        }
    }

    public void waitOnLock() {
        rjvm.sendAndDie();
        try {
            this.masterLock.waitOnLock();
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
        finally {
            rjvm.ariseAndReceive();
        }
    }

    private void equivClassFormed() {
        this.ecFormed = true;
    }

    private boolean capChanged() {
        return true;
    }

    private static InLock createLocalLock() {
        try {
            return new InLock_impl(rjvm.thisVM.getName(), true);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }
}

