/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.rj;

import edu.ucdavis.rj.AtomicPrintlnPrintStream;
import edu.ucdavis.rj.Debug;
import edu.ucdavis.rj.ProxyInputStream;
import edu.ucdavis.rj.ProxyOutputStream;
import edu.ucdavis.rj.RJX;
import edu.ucdavis.rj.RemoteRefs;
import edu.ucdavis.rj.Semaphore;
import edu.ucdavis.rj.TerminationData;
import edu.ucdavis.rj.VM;
import edu.ucdavis.rj.rjCommunicationException;
import edu.ucdavis.rj.rjvm_intf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class rjvm
extends UnicastRemoteObject
implements rjvm_intf {
    static final long serialVersionUID = 0L;
    private String name;
    public static String vmName;
    public String host;
    public static RJX rjx;
    public static rjvm thisVM;
    public static boolean threadLocalRO;
    private static Hashtable<UnicastRemoteObject, UnicastRemoteObject> remTable;
    private Thread pChecker;
    private Thread reaper;
    private Object dieMutex;
    private boolean dying = false;
    private static Semaphore termination;
    public static boolean implicitTermination;
    private static int verbosity;
    private static final int NUMARGS = 8;
    private static final int SERVER_ARG = 0;
    private static final int NAME_ARG = 1;
    private static final int LOCAL_ARG = 2;
    private static final int PORT_ARG = 3;
    private static final int IMPLICIT_ARG = 4;
    private static final int VERBOSITY_ARG = 5;
    private static final int IDLE_ARG = 6;
    private static final int VMTYPE_ARG = 7;
    private static final String LOCAL_HOST = "localhost";
    private static long timestamp;
    private static final long time_inc = 1L;
    private boolean pinged = true;
    private int missed = 0;
    private static long ready;
    private static long messages;
    private static boolean amIdle;

    protected rjvm(String string, String string2) throws RemoteException {
        Debug.println("this is   RJ  rjvm Name: " + string);
        Debug.println("this is   RJ  rjvm Host: " + string2);
        this.name = string;
        this.host = string2;
        this.dieMutex = new Object();
        this.pChecker = new PingChecker();
        this.pChecker.start();
        this.reaper = new Reaper();
        this.reaper.start();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyVM() throws RemoteException {
        Object object = this.dieMutex;
        synchronized (object) {
            this.dying = true;
            this.dieMutex.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void die() {
        try {
            boolean bl = true;
            Enumeration<UnicastRemoteObject> enumeration = remTable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    bl &= UnicastRemoteObject.unexportObject(enumeration.nextElement(), true);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            try {
                bl &= UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        finally {
            System.exit(0);
        }
    }

    public static RemoteRefs createInstance(rjvm_intf rjvm_intf2, String string, Class[] classArray, Object[] objectArray) {
        try {
            return rjvm_intf2.innerCreateInstance(string, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    @Override
    public RemoteRefs innerCreateInstance(String string, Class[] classArray, Object[] objectArray) throws RemoteException {
        Object object;
        Class<?> clazz;
        Debug.println("Let's create an instance of " + string);
        Debug.println("Try to create an object: " + string);
        Debug.println("====>>>>start createInstance " + ready);
        try {
            clazz = rjvm.class.getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.toString());
        }
        Debug.println("Creating an object: " + string);
        try {
            try {
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Debug.println("getConstructor succeeded");
                Debug.println("trying newInstance");
                this.threadBirth();
                object = constructor.newInstance(objectArray);
                Debug.println("newInstance succeeded");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Debug.println("NoSuchMethod failed");
                Debug.println("====>>>> going to try harder");
                this.threadBirth();
                object = rjvm.tryHarder(string, classArray, objectArray);
                Debug.println("====>>>> trying harder worked");
            }
            this.threadDeath();
            Debug.println("Created an object: " + string);
        }
        catch (Exception exception) {
            this.threadDeath();
            throw new RemoteException(exception.toString());
        }
        finally {
            Debug.println("====>>>>done  createInstance " + ready);
        }
        try {
            Debug.println("Trying to get RemoteRefs for " + clazz);
            return new RemoteRefs(clazz, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object tryHarder(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Constructor<?>[] constructorArray;
        Class<?> clazz;
        Object var4_3 = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFound failed OOPS");
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
            try {
                var4_3 = constructor.newInstance(objectArray);
                return var4_3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug.println("java.lang.IllegalArgumentException failed");
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        throw new NoSuchMethodException("can't find matching constructor");
    }

    public static Object createInstance(rjvm_intf rjvm_intf2, String string, Class[] classArray, Object[] objectArray, String string2) {
        try {
            return rjvm_intf2.innerCreateInstance(string, classArray, objectArray, string2);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    @Override
    public Object innerCreateInstance(String string, Class[] classArray, Object[] objectArray, String string2) throws RemoteException {
        Object obj;
        Class<?> clazz;
        try {
            clazz = rjvm.class.getClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.threadBirth();
            obj = constructor.newInstance(objectArray);
            this.threadDeath();
        }
        catch (Exception exception) {
            this.threadDeath();
            exception.printStackTrace();
            throw new RemoteException(exception.toString());
        }
        try {
            clazz = rjvm.class.getClassLoader().loadClass(string2);
            obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void startmain(String[] stringArray) throws Exception {
        Class[] classArray = new Class[]{stringArray.getClass()};
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        amIdle = false;
        rjvm.threadBirth();
        Class<?> clazz = rjvm.class.getClassLoader().loadClass(stringArray[0]);
        Method method = clazz.getMethod("main", classArray);
        if (method == null) {
            throw new NoSuchMethodError("main");
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodError("main not static");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new NoSuchMethodError("main not public");
        }
        Object[] objectArray = new Object[]{stringArray2};
        method.invoke(null, objectArray);
        rjvm.threadDeath();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 8) {
            System.exit(1);
        }
        try {
            String[] stringArray2;
            VM vM;
            rjvm rjvm2;
            RJX rJX;
            implicitTermination = Integer.parseInt(stringArray[4]) == 1;
            verbosity = Integer.parseInt(stringArray[5]);
            String string = stringArray[1];
            String string2 = stringArray[0].equals(stringArray[2]) ? LOCAL_HOST : stringArray[0];
            String string3 = "//" + string2 + ":" + stringArray[3] + "/RJX";
            System.setProperty("java.rmi.server.hostname", stringArray[2]);
            rjx = rJX = (RJX)Naming.lookup(string3);
            System.setIn(new ProxyInputStream(rJX.getStdIn()));
            System.setOut(new AtomicPrintlnPrintStream(new ProxyOutputStream(rJX.getStdOut())));
            System.setErr(new AtomicPrintlnPrintStream(new ProxyOutputStream(rJX.getStdErr())));
            String string4 = System.getProperty("RJnewRO");
            threadLocalRO = string4 == null;
            vmName = string;
            if (stringArray[7].equals("VM")) {
                rjvm2 = new rjvm(string, stringArray[2]);
                vM = new VM(stringArray[1], rjvm2);
            } else {
                stringArray2 = Class.forName(stringArray[7]);
                Constructor<?> constructor = stringArray2.getConstructor(rJX.getParamTypes(stringArray[1]));
                rjvm2 = (rjvm)constructor.newInstance(rJX.getParamValues(stringArray[1]));
                vM = rjvm.createVMProxy(stringArray[7], stringArray[1], rjvm2);
            }
            thisVM = rjvm2;
            Debug.println("about to say hi");
            rJX.hello(stringArray[1], vM, Integer.parseInt(stringArray[6]) == 1);
            Debug.println("\t\t**** rjvm running *****");
            if (stringArray.length > 8) {
                Debug.println(" rjvm args.length==" + stringArray.length);
                stringArray2 = new String[stringArray.length - 8];
                System.arraycopy(stringArray, 8, stringArray2, 0, stringArray2.length);
                rjvm.startmain(stringArray2);
                Debug.println(" back from startmain rjvm args.length==" + stringArray.length);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("RJ rjvm 466  exception: " + invocationTargetException.getTargetException().getMessage());
            invocationTargetException.getTargetException().printStackTrace();
            try {
                rjx.exit(1);
            }
            catch (Exception exception) {
                System.err.println("Abnormal exit!");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("rjvm exception: " + exception.getMessage());
            exception.printStackTrace();
            try {
                rjx.exit(1);
            }
            catch (Exception exception2) {
                System.err.println("Abnormal exit!");
                exception2.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static VM createVMProxy(String string, String string2, rjvm_intf rjvm_intf2) {
        try {
            Class<?> clazz = Class.forName("RJ" + string);
            Constructor<?> constructor = clazz.getConstructor(String.class, rjvm_intf.class);
            return (VM)constructor.newInstance(string2, rjvm_intf2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static void registerRemote(UnicastRemoteObject unicastRemoteObject) {
        remTable.put(unicastRemoteObject, unicastRemoteObject);
    }

    public static void unregisterRemote(UnicastRemoteObject unicastRemoteObject) {
        remTable.remove(unicastRemoteObject);
    }

    public void unregisterAllRemote() {
        Enumeration<UnicastRemoteObject> enumeration = remTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                UnicastRemoteObject.unexportObject(enumeration.nextElement(), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized long getTimestamp() {
        return ++timestamp;
    }

    public static synchronized long setTimestamp(long l) {
        if (l + 1L > ++timestamp) {
            timestamp = l + 1L;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ping() throws RemoteException {
        rjvm rjvm2 = this;
        synchronized (rjvm2) {
            this.pinged = true;
            this.missed = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPing() {
        boolean bl = false;
        rjvm rjvm2 = this;
        synchronized (rjvm2) {
            bl = this.pinged;
            this.pinged = false;
        }
        if (!bl) {
            ++this.missed;
        }
        try {
            rjx.ping();
            this.missed = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.missed > 2) {
            System.err.println("Abnormal exit -- heartbeat failed!");
            System.exit(1);
        }
    }

    public static final void threadBirth() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        rjvm.threadBirth_internal();
        termination.release();
    }

    private static final void threadBirth_internal() {
        ++ready;
        rjvm.notifyNotIdle();
    }

    public static final void threadDeath() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        rjvm.threadDeath_internal();
        termination.release();
    }

    private static final void threadDeath_internal() {
        --ready;
        rjvm.notifyIdle();
    }

    private static final void messageSent() {
        ++messages;
    }

    private static final void messageReceived() {
        --messages;
    }

    public static final void sendAndDie() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        rjvm.messageSent();
        rjvm.threadDeath_internal();
        termination.release();
    }

    public static final void ariseAndReceive() {
        if (!implicitTermination) {
            return;
        }
        termination.acquire();
        rjvm.messageReceived();
        rjvm.threadBirth_internal();
        termination.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void notifyNotIdle() {
        amIdle = false;
        if (ready == 1L) {
            try {
                termination.release();
                try {
                    rjx.notIdle(vmName);
                }
                finally {
                    termination.acquire();
                }
            }
            catch (Exception exception) {
                System.err.println("notifyNotIdle cannot reach RJX ... exiting!");
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void notifyIdle() {
        if (ready == 0L) {
            amIdle = true;
            try {
                termination.release();
                try {
                    rjx.idle(vmName);
                }
                finally {
                    termination.acquire();
                }
            }
            catch (Exception exception) {
                System.err.println("notifyIdle cannot reach RJX ... exiting!");
                System.exit(1);
            }
        }
    }

    @Override
    public final TerminationData checkIdle() throws RemoteException {
        return rjvm.checkLocalIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final TerminationData checkLocalIdle() {
        termination.acquire();
        try {
            TerminationData terminationData = new TerminationData(amIdle, messages);
            return terminationData;
        }
        finally {
            termination.release();
        }
    }

    public static VM createVM(String string, String string2) {
        try {
            Debug.println("rjvm's createVM1 " + string + " " + string2);
            return rjx.createVM(string, string2);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    public static VM createVM(VM vM, String string) {
        try {
            Debug.println("rjvm's createVM2 " + vM + " " + string);
            return rjx.createVM(vM, string);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    public static VM createVM(String string, String string2, String string3, Class[] classArray, Object[] objectArray) {
        try {
            Debug.println("rjvm's createVM3 " + string + " " + string2);
            return rjx.createVM(string, string2, string3, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    public static VM createVM(VM vM, String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            System.out.println("rjvm's createVM4 " + vM + " " + string);
            return rjx.createVM(vM, string, string2, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            throw new rjCommunicationException(remoteException);
        }
    }

    static {
        remTable = new Hashtable();
        termination = new Semaphore(1);
        implicitTermination = false;
        verbosity = 0;
        timestamp = 0L;
        ready = 0L;
        messages = 0L;
        amIdle = true;
    }

    private class Reaper
    extends Thread {
        final int SLEEP_TIME = 50;

        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = rjvm.this.dieMutex;
            synchronized (object) {
                while (!rjvm.this.dying) {
                    try {
                        rjvm.this.dieMutex.wait();
                    }
                    catch (Exception exception) {}
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rjvm.this.die();
            }
        }
    }

    private class PingChecker
    extends Thread {
        final int SLEEP_TIME = 5000;

        private PingChecker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rjvm.this.dying) break;
                rjvm.this.checkPing();
            }
        }
    }
}

