/*
 */

package edu.ucdavis.rj;

import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import java.io.Serializable;

public class OpInniIteratorImpl
    implements OpInniIterator, Serializable
{
    static final long serialVersionUID = 0;
    private OpInniIteratorRemote _delegate;

    public OpInniIteratorImpl(OpInniIteratorRemote delegate)
    {
      _delegate = delegate;
    }

    public boolean hasNext()
    {
       try
       {
          return _delegate.hasNext();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public boolean hasMoreElements()
    {
       try
       {
          return _delegate.hasMoreElements();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public Object next()
    {
       try
       {
          return _delegate.next();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public Object nextElement()
      throws NoSuchElementException
    {
       try
       {
          return _delegate.nextElement();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public Object get(int index)
    {
       try
       {
          return _delegate.get(index);
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }


    // removes the last element returned
    public void remove()
    {
       try
       {
          _delegate.remove();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    // removes the element at index
    public void remove(int index)
    {
       try
       {
          _delegate.remove(index);
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public int getCurInvocationIndex()
    {
       try
       {
          return _delegate.getCurInvocationIndex();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public void unregister()
    {
       try
       {
          _delegate.unregister();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public int size()
    {
       try
       {
          return _delegate.size();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

    public void reset()
    {
       try
       {
          _delegate.reset();
       }
       catch (RemoteException re)
       {
          throw new rjCommunicationException(re);
       }
    }

}
