package edu.ucdavis.rj;

import java.util.*;

import java.rmi.*;

/**
 * An operation that's to be serviced via inni.
 */
public class OpInniNoop extends OpInni {

    /**
     * Create a new instance of an operation that's to be serviced
     * via inni.
     * @throws java.rmi.RemoteException if RMI fails.
     */
     public OpInniNoop() throws RemoteException {
     }

    // guess what?  I'm a noop
    public boolean isNoop() {
        return true;
    }

    /**
     * Invoke this operation asynchronously.
     * @param originalInv The invocation to service.
     * override OpImpl's send so don't need to clone inv.
     */
    public void send(Invocation originalInv) {
	this.internalSend(originalInv);
    }

    void internalSend(Invocation inv) {
	// nothing to do for a noop.
    }

    /**
     * Invoke this operation synchronously.
     * @param  originalInv The invocation to service.
     * @return The invocation,
     * from which the return value of the operation can be extracted.
     * <P>
     * N.B., (the reference for) the returned invocation may not be the
     * same as {@code originalInv}.  
     * See details under {@link Op#call}.  
     */
    public Invocation call(Invocation originalInv) {
	// not much to do for a noop.
	originalInv.setReturnValue(null);
	return originalInv;
    }

}
