package edu.ucdavis.rj;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.net.*;
import java.util.*;
import java.util.jar.*;
import java.util.zip.*;
import java.lang.reflect.*;
import java.io.*;


public class RemoteLoader_impl
  extends UnicastRemoteObject
  implements RemoteLoader
{
    static final long serialVersionUID = 0;
    private static final String dotJar = ".jar";
    private static final char separatorChar = '/';
    java.util.Hashtable<String, byte[]> hash = new java.util.Hashtable<String, byte[]>();
    public RemoteLoader_impl () throws RemoteException
    {}

    public void unregister()
	throws RemoteException
    {
	try
	{
	    UnicastRemoteObject.unexportObject(this, true);
	}
	catch (Exception e)
	{
	    throw new RemoteException(e.toString());
	}
    }

    public byte [] getClass(String name) throws RemoteException
    {
//System.out.print("Trying to get " + name);
      try
      {
	name = name.trim().replace('.', separatorChar);

	byte [] clsBytes = (byte [])hash.get(name);
	if (clsBytes != null)
	{
//System.out.println(" -- found");
	    return clsBytes;
	}

	String classname = name.concat(".class");
	String classpath = System.getProperty("java.class.path");
	StringTokenizer stok = new StringTokenizer(classpath,
						File.pathSeparator);

	while (stok.hasMoreTokens())
	{
	    String path = stok.nextToken();

	    // Determine if the path is to a jar file
	    if ((path.length() > 4) &&
		 path.endsWith(dotJar)
		//(path.substring(path.length() - 4, path.length()).
		// equals(".jar"))
		)
	    {
		try
		{
		    clsBytes = readJar(path, classname);
		    if (clsBytes == null)
			continue;
		    else
		    {
			hash.put(name, clsBytes);
//System.out.println(" -- found");
			return clsBytes;
		    }
		}
		catch (Exception e) {continue;}
	    }
	    else
	    {
		try
		{
		    // reading from class file directly
		    clsBytes = readFile(path, classname);
		    if (clsBytes == null)
			continue;
		    else
		    {
			hash.put(name, clsBytes);
//System.out.println(" -- found");
			return clsBytes;
		    }
		}
		catch (Exception e) {continue;}
	    }
	}
      }
      catch (Exception e)
      { throw new RemoteException(e.toString()); }

//System.out.println(" -- missing");
	// Didn't find it
	return null;
    }

    private byte [] readJar(String path, String classname)
	throws java.io.IOException
    {
	// trying to read from a jar file
	File file = new File(path);
	if (file.exists() && file.canRead())
	{
	    JarFile jfile = new JarFile(file, false);
	    JarEntry jentry = jfile.getJarEntry(classname);
	    if (jentry == null)
	    { return null; }

	    long eSize = jentry.getSize();
	    JarInputStream jstream = new JarInputStream(
					new BufferedInputStream(
					new FileInputStream(file)));
	    while ((jentry = jstream.getNextJarEntry()) != null)
	    {
		if (!jentry.isDirectory() &&
				jentry.getName().equals(classname))
		{
		    int size = (int) ((jentry.getSize() == -1) ?
						eSize : jentry.getSize());
		    return readClass(jstream, size);
		}
	    }
	}
	return null;
    }

    private byte [] readFile(String path, String classname)
	throws java.io.IOException
    {
	String curpath = path + "/" + classname;
	File file = new File(curpath);

	if (file.exists() && file.canRead())
	{
	    //System.out.println("Found the class in " + curpath);
	    InputStream in = new FileInputStream(file);
	    return readClass(in, in.available());
	}
	return null;
    }

    private byte [] readClass(InputStream in, int size)
	throws java.io.IOException
    {
	byte [] clsBytes = new byte[size];
	int bRead = 0, chunk = 0;

	while ((size - bRead) > 0)
	{
	    chunk = in.read(clsBytes, bRead, size - bRead);
	    if (chunk == -1)
	    {
		break;
	    }
	    bRead += chunk;
	}

	return clsBytes;
    }
}
