package edu.ucdavis.rj;

import java.lang.*;
import java.io.Serializable;

/**
 * Class representing a virtual machine.
 */
public class VM implements Serializable
{
    static final long serialVersionUID = 0;
    public String host;
    public rjvm_intf rjVM;

    public VM()
    {
		this.host = null;
		this.rjVM = null;
	 }

    protected VM(String host, rjvm_intf rjVM)
    {
	this.host = host;
	this.rjVM = rjVM;
        thisVM = this;
    }

    public String toString()
    {
        return host;
    }

    public static VM currentVM()
    {
      if (thisVM == null)
      {
	 thisVM = new VM(rjvm.vmName, rjvm.thisVM);
      }

      return thisVM;
    }

    private static VM thisVM = null;
}
