import edu.ucdavis.rj.*;

import java.util.ArrayList;
import java.util.Iterator;

public class MyShape<E>
{
	private E id;

	public MyShape(E id)
	{
		this.id = id;
	}

        public OpMethod get, set, print;
        {
            try {
                get = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    inv.setReturnValue(id);
                        }
                    };
                set = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    E invId = (E)(inv.getParam(0));
			    id = invId;
                        }
                    };
                print = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    System.out.println("MyShape " + id);
                        }
                    };
            } catch (Exception e) {
                System.err.println("OpMethods");
                e.printStackTrace();
            }
        }

	public String toString() {
		return id.toString();
	}

	public static void main(String [] args)
	{
		ArrayList<MyShape> shapes = new ArrayList<MyShape>();

		MyShape<String> square = new MyShape<String>("square");
		MyShape<String> triangle = new MyShape<String>("triangle");
		MyShape<String> rectangle = new MyShape<String>("rectangle");

		shapes.add(square);
		shapes.add(triangle);
		shapes.add(rectangle);

		System.out.println("A list of shapes: ");
		for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		{
			it.next().print.call();
		}

                System.out.println("changing triangle to equilateral triangle...");
                triangle.set.call(new Invocation("equilateral triangle"));
		Invocation rinv = triangle.get.call();
                System.out.println("shape just changed: " + rinv.getReturnValue());


                System.out.println("Now the list of shapes becomes: ");
                for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		    {
                        it.next().print.call();
		    }
        }

}
