/****
# context switch using semaphores
# Two processes run simultaneously.  p1 blocks until p2 releases.
# p2 then blocks waiting for p1 to release.  Blocking is done by
# semaphores.  The reported number of times is twice the loop limit
# because two context switches occur on each pass.
****/

import edu.ucdavis.rj.*;

public class Context {
  
   // in SR, export prevents sem optimization; in JR and RJ, it's irrelevant
   // (for now)
    private OpInni up = OpInni.newSem(0);
    private OpInni down = OpInni.newSem(0);

   // to control shutdown
    private OpInni done = OpInni.newSem(0);

   private int limit;
   private int factor;
   private int base;
   private int trials;

   public Context(int factor, int base, int trials) {

      this.factor = factor;
      this.base   = base;
      this.trials = trials;

      limit = factor * base / 2; // **** note the "/ 2"; see above comment

         p1.send();
         p2.send();
	 // don't want to shutdown program until done.
	 done.P();
	 done.P();
   }

   // would-be process
    OpMethod p1 = null;
    OpMethod p2 = null;
    {
        try {
            p1 = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			long start, finish;

			for (int t = 1; t <= trials; t++ ) {
			    start = System.currentTimeMillis();
			    for (int i = 1; i<=limit ; i++) {
				up.V();
				down.P();
			    }
			    finish =System.currentTimeMillis();
			    System.out.println(2*limit + " times   " + (finish-start) + " ms");
			}
			done.V();
		    }
		};
            p2 = new OpMethod() {
		    public void codeBlock(Invocation pinv) {

			for (int t = 1; t <= trials; t++ ) {
			    for (int i = 1; i<=limit ; i++) {
				up.P();
				down.V();
			    }
			}
			done.V();
		    }
		};
	} catch (Exception e) {
	    System.err.println("p1 or p2");
	    e.printStackTrace();
	}
    }

}
