package edu.ucdavis.rj;

import java.io.*;
import java.rmi.RemoteException;

public class ProxyInputStream extends InputStream
{
    RemoteInputStream rin;

    public ProxyInputStream(RemoteInputStream rin)
    {
	this.rin = rin;
    }

    public int available()
	throws IOException
    {
	try
	{
	    return rin.available();
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }

    public void close()
	throws IOException
    {
	try
	{
	    rin.close();
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }

    public void mark(int readlimit)
    {
	try
	{
	rin.mark(readlimit);
	}
	catch (RemoteException e)
	{ /* ignore exception */ }
    }

    public boolean markSupported()
    {
	try
	{
	    return rin.markSupported();
	}
	catch (RemoteException e)
	{ return false; }
    }

    public int read()
	throws IOException
    {
	try
	{
	    return rin.read();
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }

    public int read(byte [] b)
	throws IOException
    {
	return read(b, 0, b.length);
    }

    public int read(byte [] b, int off, int len)
	throws IOException
    {
	if (b == null) throw new NullPointerException("null buffer");
	if ((off < 0) || (len < 0) || ((off + len) > b.length))
		throw new IndexOutOfBoundsException();
	if (len == 0)
	    return 0;
	try
	{
	    RemoteInputStream.readResult result = rin.read(len);
	    if (result.ret > 0)
		System.arraycopy(result.buf, 0, b, off, len);
	    return result.ret;
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }

    public void reset()
	throws IOException
    {
	try
	{
	    rin.reset();
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }

    public long skip(long n)
	throws IOException
    {
	try
	{
	    return rin.skip(n);
	}
	catch (RemoteException e)
	{
	    throw new IOException("RemoteException: " + e.getMessage());
	}
    }
}
