package edu.ucdavis.rj;

/*  Contain information relevant to a specific in statement */

class Sorter
{
    public static class SortCompare
    {
	public boolean precede(Object lft, Object rht)
	{
	    return true;
	}
    }

    public static void sort(Object [] array, SortCompare func)
    {
	sort(array, 0, array.length - 1, func);
    }

    static void sort(Object [] array, int strt, int end, SortCompare func)
    {
	if ((strt == end) || (strt > end)) return;

	int pivot = partition(array, strt, end, func);

	sort(array, strt, pivot - 1, func);
	sort(array, pivot + 1, end, func);
    }

    static int partition(Object [] array, int strt, int end, SortCompare func)
    {
	// just use the first element as the pivot, this can be
	// bad in theory
	int pos = strt;
	Object tmp = array[pos];

	// place the pivot
	array[pos] = array[strt];
	array[strt] = tmp;
	pos = strt;
	for (int i = strt + 1; i <= end; i++)
	{
	    if (func.precede(array[i], array[strt]))
	    {
		pos++;
		tmp = array[i];
		array[i] = array[pos];
		array[pos] = tmp;
	    }
	}
	tmp = array[pos];
	array[pos] = array[strt];
	array[strt] = tmp;

	return pos;
    }
}
