package edu.ucdavis.rj;

import java.rmi.RemoteException;

/* This class is really just a proxy around the InLock class to
   allow locks to change during equivalence class formation.
*/
class CLock
{
    InLock theLock;
    private LockId lockId;

    public boolean duplicate = false;
    public boolean isRemoteLock;
    public long numDupes = 0;

    public CLock(InLock theLock)
	throws RemoteException
    {
	this.theLock = theLock;
	this.lockId = theLock.getLockId();
	this.isRemoteLock = this.lockId.site.compareTo("jrx") == 0;
    }

    static class DupSorter extends Sorter.SortCompare
    {
	public boolean precede(Object lft, Object rht)
        {
	    LockId llk, rlk;
	    llk = ((CLock)lft).lockId;
	    rlk = ((CLock)rht).lockId;

	    int compare = llk.site.compareTo(rlk.site);
	    if (compare < 0)
		return true;
	    else if (compare == 0)
		return llk.num < rlk.num;
	    else
		return false;
        }
    }
    private static DupSorter dupSorter = new DupSorter();
    public static void markDuplicates(CLock [] array)
      throws RemoteException
    {
//System.out.println("Looking for duplicates");
	int pos = 0;
	Sorter.sort(array, dupSorter);

        if (array.length > 0)
        {
	   LockId posId = array[0].lockId;
//System.out.println("Lock site: " + array[0].lockId.site + ":" + array[0].lockId.num);
	   for (int i = 1; i < array.length; i++)
	   {
//System.out.println("Lock site: " + array[i].lockId.site + ":" + array[i].lockId.num);
	       if ((posId.site.compareTo(array[i].lockId.site) == 0) &&
		   (posId.num == array[i].lockId.num))
	       {
//System.out.println("\t\tFound DUPLICATE");
		   array[i].duplicate = true;
		   array[pos].numDupes++;
	       }
	       else
	       {
		   pos = i;
		   posId = array[pos].lockId;
	       }
	   }
       }
    }

    public void lock()
	throws java.rmi.RemoteException
    {
	theLock.lock();
    }

    public void unlock()
	throws java.rmi.RemoteException
    {
	theLock.unlock();
    }

    public void waitOnLock()
	throws java.rmi.RemoteException
    {
	theLock.waitOnLock();
    }

    public void lockEC()
	throws java.rmi.RemoteException
    {
	theLock.lockEC();
    }

    public void unlockEC()
	throws java.rmi.RemoteException
    {
	theLock.unlockEC();
    }

    public void forwardTo(InLock newLock)
	throws RemoteException //, LockNotHeldException
    {
	theLock.forwardTo(newLock);
	this.lockId = getLock().getLockId();
    }

    public InLock getLock()
	throws RemoteException
    {
	return theLock.getInnerLock();
    }

   public final LockId getLockId()
      throws RemoteException
   {
      return theLock.getLockId();
   }

   public boolean isDupeOf(CLock aLock)
      throws RemoteException
   {
      return (this.lockId.site.compareTo(aLock.lockId.site) == 0) &&
          (this.lockId.num == aLock.lockId.num);
   }
}
