/*
 * 2011-06-21
 * based on JR's InStatObj
 * renamed and stripped down some:
 *   removed TimesCompare (since equivalent is in Inni)
 *   removed releaseIter() (since equivalent is in InniArm)

 //////////////// removed optimizations
 ///////// rethink which might still make sense..........

  hasChanged might, but would need to write equals() for some classes.
  and some of that might require RMI to get fields to compare.
  if so, that's costly (but need to figure out whether that is 
   less than reforming???)

 */

package edu.ucdavis.rj;
/*
   Instances of this class store information pertaining to a specific
   inni statement during execution.  Specifically, it manages the
   locks for the operations serviced by the inni statement.

   A bunch of OO design is violated by this class in an attempt to
   improve performance.
*/

import java.rmi.RemoteException;
import java.util.ArrayList;

class InniLocker
{
    public int N;

    private ArrayList<InniArm> armList;

    private CLock [] lockArray;
    private CLock masterLock;

    /////// some of these are just for optimizations
    ////////// which aren't done at least for now
    ///////////// so can clean up at some point.......
    private boolean ecFormed;
    private boolean hasCap;
    private boolean quantified;
    private boolean cleared;

    public InniLocker(ArrayList<InniArm> armList)
    {
	this.armList = armList;
	this.N = armList.size();
        this.quantified = true;
	this.ecFormed = false;
	this.masterLock = null;
	this.lockArray = new CLock[N];
        this.hasCap = true; // = hasCap;
        this.cleared = false;
        this.quantified = false;
    }

    /***********
///////////////////
    private void toArray()
    {
	this.armArray = (QuantRec [])listDueToQuants.toArray(this.armArray);
        for (int i = 0; i < this.armArray.length; i++)
        {
	   this.armArray[i].armArrayIndex = i;
        }
        int N = this.armArray.length;
	this.N = N;
	this.lockArray = new CLock[N];
    }
    *************/

    /** Lock the equivalence class.  First determine if some number of
     *  operations must be added to the equivalence class.  If so, then
     *  create a new ec.
     */
    public void lock()
    {
      try
      {
	  /******************* ///////
        if (cleared)
        {
	   cleared = false;
	   toArray(); // convert to an array to speed execution
        }
	  *****************/
	int i;
	boolean needRemote = false;

	if (!ecFormed || ((hasCap || quantified) && this.capChanged()))
	{
            this.masterLock = null;
	    rjvm.sendAndDie();
	    try
	    {
		rjvm.rjx.lockEC();
//System.out.println("Locked rjx EC " + Thread.currentThread());
	    }
	    finally
	    {
		rjvm.ariseAndReceive();
	    }
//System.out.println("Forming EC");
	    for (i = 0; i < this.N; i++)
		{
		    OpProxy theOp = this.armList.get(i).getOpProxy();

		this.lockArray[i] =
		    new CLock(theOp.getLock());
		if (theOp.isRemote(rjvm.thisVM.getName()))
		    needRemote = true;
	    }
	    // mark the duplicate locks to prevent deadlock
	    CLock.markDuplicates(this.lockArray);

	    try
	    {
		// form the equivalence class
		for (i = 0; i < this.N; i++)
		{
//System.out.println("Locking arm " + i);
		    if (!this.lockArray[i].duplicate)
		    {
//System.out.println("\t\t\t" + i + " lock not duplicate");
			rjvm.sendAndDie();
			try
			{
			    this.lockArray[i].lockEC();
			}
			finally
			{
			    rjvm.ariseAndReceive();
			}

			// is this the most duplicated lock (with
			// preference for remote locks)
			if (this.lockArray[i].isRemoteLock &&
			    ((this.masterLock == null) ||
			     (!this.masterLock.isRemoteLock) ||
			     (this.lockArray[i].numDupes >
			      this.masterLock.numDupes)))
			{
			    this.masterLock = this.lockArray[i];
			}
			else if (!this.lockArray[i].isRemoteLock &&
				 ((this.masterLock == null) ||
				 (!this.masterLock.isRemoteLock &&
				  (this.lockArray[i].numDupes >
				   this.masterLock.numDupes))))
			{
			    this.masterLock = this.lockArray[i];
			}
		    }
		}
		// ensure that the master lock is remote if needed
		if (needRemote)
		{
		    if ((this.masterLock == null) ||
			!this.masterLock.isRemoteLock)
		    {
			// create a remote lock that is already locked
			this.masterLock =
			    new CLock(rjvm.rjx.createRemoteLock());
		    }
		}
		else
		{
		    if (this.masterLock == null)
		    {
			// create a local lock that is already locked
			this.masterLock = new CLock(createLocalLock());
		    }
		}

		// forward all locks
		for (i = 0; i < this.N; i++)
		{
		    // if this lock does not duplicate the master lock
		    // or another lock in the set, then forward its
		    // messages
		    if (!this.lockArray[i].isDupeOf(this.masterLock)
			&& !this.lockArray[i].duplicate)
		    {
			rjvm.sendAndDie();
			try
			{
			    this.lockArray[i].forwardTo(
						this.masterLock.getLock());
			}
			finally
			{
			    rjvm.ariseAndReceive();
			}
		    }
		}

		// update EC info
		this.equivClassFormed();

		rjvm.sendAndDie();
		try
		{
		    this.masterLock.unlockEC();
		}
		finally
		{
		    rjvm.ariseAndReceive();
		}
	    }
	    catch (Exception e)
	    {
               e.printStackTrace();
	       throw new rjRuntimeError("error constructing equivalence class");
	    }
	    rjvm.sendAndDie();
	    try
	    {
		rjvm.rjx.unlockEC();
//System.out.println("Unlocked rjx EC " + Thread.currentThread());
	    }
	    finally
	    {
		rjvm.ariseAndReceive();
	    }
	}

	// lock the masterLock
	rjvm.sendAndDie();
	try
	{
	    this.masterLock.lock();
	}
	finally
	{
	    rjvm.ariseAndReceive();
	}
      }
      catch (RemoteException re)
      {
         throw new rjCommunicationException(re);
      }
    }

    public void unlock()
    {
	rjvm.sendAndDie();
	try
	{
	    this.masterLock.unlock();
	}
        catch (RemoteException re)
        {
           throw new rjCommunicationException(re);
        }
	finally
	{
	    rjvm.ariseAndReceive();
	}
    }

    public void waitOnLock()
    {
	////2012-10-10 Debug.println("InniLocker +waitOnLock() masterLock=" +masterLock);
	rjvm.sendAndDie();
	////2012-10-10 Debug.println("InniLocker waitOnLock() post-rjvm.sendAndDie()");
	try
	{
	    this.masterLock.waitOnLock();
	    ////2012-10-10 Debug.println("InniLocker waitOnLock() post-this.masterLock.waitOnLock()");
	}
        catch (RemoteException re)
        {
           throw new rjCommunicationException(re);
        }
	finally
	{
	    rjvm.ariseAndReceive();
	}
	////2012-10-10 Debug.println("InniLocker -waitOnLock() masterLock=" +masterLock);
    }

    private void equivClassFormed()
    {
	this.ecFormed = true;
	/************************** /////////////////////////
	if (hasCap)
        {
	    if (oldArmArray != null && oldArmArray.length == armArray.length)
	    {
	       // if the new is the right size
	       System.arraycopy(this.armArray, 0, this.oldArmArray,
		  0, this.N);
	    }
	    else
	    {
	       // clone to hold the old
	       this.oldArmArray = (QuantRec [])this.armArray.clone();
	    }
        }
	***********************/
    }

    /** Determine if a capability refers to a different operation than
     *  the last time the equivalence class was gathered.
     *  @return whether cap has changed.
     */
    private boolean capChanged()
    {
	/********************** //////////////
	Object _new, _old;
        if (oldArmArray == null || oldArmArray.length != armArray.length)
        {
	   return true;
        }
	for (int i = 0; i < armArray.length; i++)
	{
	    if (!armArray[i].equals(oldArmArray[i]))
	    {
	       return true;
	    }

	    _new = armArray[i].theCap.getOp();
	    _old = oldArmArray[i].theCap.getOp();
	    //if (!armArray[i].getOp().equals(oldArmArray[i].getOp()))
	    if (((_old == null) && (_new != null)) ||
		((_old != null) && (_new == null)) ||
		((_old != null) && (_new != null) && !_new.equals(_old)))
	    {
		return true;
	    }
	}
	return false;
	********************/
	return true;
    }

    private static InLock createLocalLock()
    {
       try
       {
          return new InLock_impl(rjvm.thisVM.getName(), true);
       }
       catch (RemoteException re)
       {
           throw new rjCommunicationException(re);
       }
    }

}
