package edu.ucdavis.rj;

import java.util.*;

/**
 * Base class incorporating quantifiers
 * for all `arms' of code, i.e., blocks for inni and co.
 */ 
abstract public class ArmCode extends BaseArmCode implements Quantifiable {

    /**
     * Override this method with the body of code for the invocation.
     * @param  inv  The invocation.
     */
    abstract public void codeBlock(Invocation inv);

    /**
     * Value of quantifiers, if any, are accessible via this field.
     */
    public Quantifiers q;

    public void setQuantifiers(Quantifiers q) {
	this.q = q;
    }

}
