package edu.ucdavis.rj;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.net.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.*;

public class RJX_impl
  extends UnicastRemoteObject
  implements RJX
{
    static final long serialVersionUID = 0;
    // default rmi port
    //private static final int DEFAULT_PORT = Registry.REGISTRY_PORT;
    private static int thePort = Registry.REGISTRY_PORT + 1;
    private static Registry registry = null;

    private static long PRINTMILLIS = 5;
    private static int PRINTNANOS = 0;

    private long hostnums = 1;
    private Runtime rt;
    private Hashtable<String, VMRegInfo> creating = new Hashtable<String, VMRegInfo>();
    private Hashtable<String, VMElement> vms = new Hashtable<String, VMElement>();
    private Hashtable printers = new Hashtable();
    private boolean exiting = false;
    private Vector<Process> processes = new Vector<Process>();

    private static String name, localname, codebase, policy,
	rjrsh, rjsh, rjshc, rjjo;
        // 2007-12-19 RAO rjjo == RJ Java option, e.g., -Xmx2000m
    //private static String remoteVMClass = "edu.ucdavis.rj.rjx.rjvm";
    private static String remoteVMClass = "edu.ucdavis.rj.rjvm_wrap";

    private RemoteOutputStream stdout, stderr;
    private RemoteInputStream stdin;
    private RemoteLoader rl;

    private Pinger pinger;
    private Idler idler = null;
    private Object idleMutex = null;
    private static boolean implicitTermination = true;
    private static int verbosity = 0;
    // RAO 2007-09-19
    private static final int defaultVerbosityWhenSet = 1; // if just -verbosity, set to this level.
    private static final int V_QUIESCENCE_MESSAGE = 1;

    static final int PING_SLEEP_TIME = 5000;
    static final String windows = "Windows";
    static final String wincmdsep = "&&";
    static String cmdsep = ";";
    static final String LOCAL_HOST = "localhost";
    static final String LOCAL_IP = "127.0.0.1";

    private RJX_impl(RemoteLoader rl) throws RemoteException
    {
	super();
	this.rl = rl;
	this.rt = Runtime.getRuntime();
	this.stdin = new RemoteInputStream_impl(System.in);
	this.stdout = new RemoteOutputStream_impl(System.out);
	this.stderr = new RemoteOutputStream_impl(System.err);
	this.pinger = new Pinger();
	this.pinger.start();
	if (implicitTermination)
	{
	    this.idleMutex = new Object();
	    this.idler = new Idler();
	    this.idler.start();
            rjvm.implicitTermination=true;
	}
	rjvm.rjx = this;
	rjvm.vmName = "rjx";
    }

    // RAO 2010-04-26
    // refactored to eliminate duplicated code
    // the non-parameterized VM case:
    public VM createVM(String onHost, String fromHost) throws RemoteException
    {
	return createVM(false, onHost, fromHost, "VM", null, null);
    }
    // the parameterized VM case:
    public VM createVM(String onHost, String fromHost, String vmType,
      Class [] vmParamType, Object [] vmParam) throws RemoteException
    {
	return createVM(true, onHost, fromHost, vmType, vmParamType, vmParam);
    }
    // handle all cases:
    private VM createVM(boolean parameterizedVM,
			String onHost, String fromHost, String vmType,
			Class [] vmParamType, Object [] vmParam)
	throws RemoteException
    {
	boolean isIdleOnInit = true; // non-main vm is initially idle
        long myhost;
        String hostname;
        String hostToConnectTo = determineConnectHost(onHost, fromHost,
                                                      localname);
        String actualHost = determineActualHost(onHost, fromHost);
	VMRegInfo done;
	if (parameterizedVM) {
	    Class [] newParamType;
	    Object [] newParamValues;
	    // create array of parameter types
	    newParamType = new Class[2 + vmParamType.length];
	    newParamType[0] = String.class;
	    newParamType[1] = String.class;
	    for (int i = 0; i < vmParamType.length; i++)
		{
		    newParamType[i + 2] = vmParamType[i];
		}

	    newParamValues = new Object[2 + vmParam.length];
	    newParamValues[0] = onHost;
	    newParamValues[1] = fromHost;
	    for (int i = 0; i < vmParam.length; i++)
		{
		    newParamValues[i + 2] = vmParam[i];
		}

	    done = new VMRegInfo(false, newParamType, newParamValues);
	}
	else {
	    done = new VMRegInfo(false);
	}
        synchronized (this)
        {
            myhost = hostnums++;
        }
        //hostname = (onHost + "_" + myhost);
        hostname = (actualHost + "_" + myhost);

        creating.put(hostname, done);
        Process p = null;
        try
        {
            //Process p = rt.exec("rsh -n " + host + " java " +
            //p = rt.exec(rjrsh + " -n " + hostToConnectTo + " java " +

            Debug.println(rjrsh + " " + hostToConnectTo + " java " +
        //      "\"-Djava.compiler=NONE\" " +
		(rjjo == null?"": " \""+rjjo +"\" ")+
                "\"-Djava.rmi.server.codebase=" + codebase +
                "\" \"-Djava.security.policy=" + policy +
                "\" " +
                remoteVMClass +
                //"\" edu.ucdavis.rj.rjx.rjvm" +
                " " + localname +
                " " + hostname + " " + actualHost + " " + thePort +
                " " + (implicitTermination ? 1 : 0) + " " + verbosity +
                " " + (isIdleOnInit ? 1 : 0) +
			  " " + vmType);


            p = rt.exec(rjrsh + " " + hostToConnectTo + " java " +
        //      "\"-Djava.compiler=NONE\" " +
		(rjjo == null?"": " \""+rjjo +"\" ")+
                "\"-Djava.rmi.server.codebase=" + codebase +
                "\" \"-Djava.security.policy=" + policy +
                "\" " +
                remoteVMClass +
                //"\" edu.ucdavis.rj.rjx.rjvm" +
                " " + localname +
                " " + hostname + " " + actualHost + " " + thePort +
                " " + (implicitTermination ? 1 : 0) + " " + verbosity +
                " " + (isIdleOnInit ? 1 : 0) +
                " " + vmType);
                //+ ">&! rjvm_" + hostname + ".output");
            processes.add(p);
            p.getOutputStream().close();
        }
        catch (IOException e)
        { throw new RemoteException(e.toString()); }

        ProcessChecker waitThread = new ProcessChecker(p, done, onHost);
        waitThread.start();
        // Wait for the creation to complete
        synchronized (done)
        {
            while (!done.getValue())
            {
                try
                {
                    done.wait();
                } catch (Exception e)
                {}
            }
        }
        waitThread.awaken();
        try
        {
            waitThread.interrupt();
        } catch (Exception e) {}
        creating.remove(hostname);

        //rjvm_intf rjVM = (rjvm_intf)vms.get(hostname);
        //rjvm_intf rjVM = ((VMElement)vms.get(hostname)).vm.rjVM;
        VMElement el = (VMElement)vms.get(hostname);
        if ((el == null) || (el.vm == null) || (el.vm.rjVM == null))
        {
            throw new RemoteException("Cannot find created VM");
        }
        //return createVMProxy(vmType, hostname, el.vm);
        return el.vm;
    }

/*
    private VM createVMProxy(String vmType, String hostname, rjvm_intf vm)
    {
       try
       {
System.out.println("creating : " + vmType);
          Class classOf =
             ClassLoader.getSystemClassLoader().loadClass("RJ" + vmType);
          Constructor ctr = classOf.getConstructor(
             new Class[] {String.class, rjvm_intf.class});
          return (VM)(ctr.newInstance(new Object [] {hostname, vm}));
       }
       catch (Exception e)
       {
          e.printStackTrace();
          System.exit(1);
          return null;
       }
    }
*/

    public Object [] getParamValues(String host) throws RemoteException
    {
        return ((VMRegInfo)creating.get(host)).getParamValues();
    }

    public Class [] getParamTypes(String host) throws RemoteException
    {
        return ((VMRegInfo)creating.get(host)).getParamTypes();
    }

    private String determineConnectHost(String onHost, String fromHost,
				        String rjxHost)
    {
      try
      {
	 String connectHost = onHost;
	 // is this a request to create a vm on the local host?
	 if ((onHost.equals(LOCAL_HOST) || onHost.equals(LOCAL_IP))
	     && !fromHost.equals(LOCAL_HOST))
	 {
	    // if the request came from the same machine on which rjx is
	    // running, then just connect to local host
	    // -- FIX for stand-alone computer
	    InetAddress addr = InetAddress.getByName(fromHost);
	    //String addrStr = addr.getHostName();
	    String addrStr = addr.getCanonicalHostName();
	    if (addrStr.equals(rjxHost))
	    {
	       connectHost = LOCAL_HOST;
	    }
	    else
	    {
	       // connect to the host from which the request was sent
	       // resolved to addrStr
	       connectHost = addrStr;
	    }
	 }
	 else
	 {
	    // if the request is to connect to the same machine on
	    // which rjx is running, then just connect to local host
	    // -- FIX for stand-alone computer
	    InetAddress addr = InetAddress.getByName(onHost);
	    //String addrStr = addr.getHostName();
	    String addrStr = addr.getCanonicalHostName();
	    if (addrStr.equals(rjxHost))
	    {
	       connectHost = LOCAL_HOST;
	    }
	    else
	    {
	       // connect to the requested host
	       // resolved to addrStr
	       connectHost = addrStr;
	    }
	 }
	 return connectHost;
      }
      catch (java.net.UnknownHostException e)
      {
	 // allow an attempt to connect anyhow
	 // if it actually fails, then this will be caught later
	 return onHost;
      }
    }

    private String determineActualHost(String onHost, String fromHost)
    {
      if (onHost.equals(LOCAL_HOST) || onHost.equals(LOCAL_IP))
      {
	 return fromHost;
      }
      try
      {
	 InetAddress addr = InetAddress.getByName(onHost);
	 //String addrStr = addr.getHostName();
	 String addrStr = addr.getCanonicalHostName();
	 return addrStr;
      }
      catch (java.net.UnknownHostException e)
      {
	 // allow an attempt to connect anyhow
	 // if it actually fails, then this will be caught later
	 return onHost;
      }
    }

    public VM createVM(VM host, String fromHost) throws RemoteException
    {
	return createVM(host.rjVM.getHost(), fromHost);
    }

    public VM createVM(VM host, String fromHost, String vmType,
      Class [] vmParamType, Object [] vmParam) throws RemoteException
    {
	return createVM(host.rjVM.getHost(), fromHost, vmType, vmParamType,
         vmParam);
    }

    //public void hello(String host, rjvm_intf rjVM, boolean idle)
    public void hello(String host, VM rjVM, boolean idle)
    throws RemoteException
    {
	//System.out.println("hello called");
	VMRegInfo done = (VMRegInfo)creating.get(host);

	if (done == null) return;

	vms.put(host, new VMElement(rjVM, idle));
	synchronized (done)
	{
	    done.setValue(true);
	    // awaken the waiting invoker */
	    done.notifyAll();
	}
    }

    public boolean destroyVM(String host) throws RemoteException
    {
	rjvm_intf rjVM;
	synchronized (vms)
	{
	    //rjVM = (rjvm_intf)vms.get(host);
	    rjVM = ((VMElement)vms.get(host)).vm.rjVM;

	    if (rjVM == null) return false;

	    vms.remove(host);
	}

	//System.out.println("Destroying " + host);
	// tell the vm to destroy itself
	try
	{
	    rjVM.destroyVM();
	} catch (Exception e)
	{ e.printStackTrace(); return false; }

	return true;
    }

    public synchronized void exit(int exitval) throws RemoteException
    {
	System.out.flush();
	System.err.flush();
	rjvm_intf rjVM;
	Enumeration els, keys; 
	String host;
	boolean b = true;
//System.out.println("\t\tRJX.exit called");
	//while (exiting) Thread.yield();

	exiting = true;
//System.out.println("\t\tKill printers");
	// let the print threads execute
	//Thread.currentThread().yield();
	try{
	Thread.currentThread().sleep(1);
	} catch (Exception e) {}
	for (Enumeration pntrs = printers.elements();
	    pntrs.hasMoreElements();)
	{
	    try{
		Thread pntr = (Thread)pntrs.nextElement();
		((PrintThread)pntr).setInterrupted();
		pntr.interrupt();
		pntr.join(PRINTMILLIS, PRINTNANOS);
	    } catch (Exception e) { e.printStackTrace(); }
	}
//System.out.println("\t\tKill pinger");
	// kill the pinger
	try{
	    this.pinger.interrupt();
	    this.pinger = null;
	} catch (Exception e) { /* ignore */ }
	// kill the idler
	try{
	    if (this.idler != null)
	    {
		this.idler.interrupt();
		this.idler = null;
	    }
	} catch (Exception e) { /* ignore */ }
//System.out.println("\t\tKill VMs");
	synchronized (vms)
	{
	    els = vms.elements();
	    keys = vms.keys();

	    for (; els.hasMoreElements();)
	    {
		//rjVM = (rjvm_intf)els.nextElement();
		rjVM = ((VMElement)els.nextElement()).vm.rjVM;
		host = (String)keys.nextElement();

		if (rjVM == null) continue;

//System.out.println("Destroying " + host);
		// tell the vm to destroy itself
		try
		{
		    rjVM.destroyVM();
		} catch (Exception e)
		{ }
//System.out.println("Destroyed " + host);
	    }
/*
	    for (Enumeration procs = processes.elements();
		procs.hasMoreElements();)
	    {
		((Process)procs.nextElement()).destroy();
	    }
*/
	    //vms.clear();
	}

	try
	{
//System.out.println("\t\tUnbinding");
	    //registry.unbind(name);
	    try
	    {
		boolean exp = false;
		if (!exp)
		    exp = UnicastRemoteObject.unexportObject(stdin, true);
		exp = false;
		if (!exp)
		    exp = UnicastRemoteObject.unexportObject(stdout, true);
		exp = false;
		if (!exp)
		    exp = UnicastRemoteObject.unexportObject(stderr, true);
		exp = false;
		if  (!exp)
		    rl.unregister();
	    }
	    catch (Exception e)
	    {
		throw new Exception(e.getMessage());
	    }
	    b = UnicastRemoteObject.unexportObject(this, true);
	}
	catch (NoSuchObjectException ns)
	{ throw new RemoteException(ns.toString()); }
	catch (Exception e)
	{
	    try
	    {
		b = UnicastRemoteObject.unexportObject(this, true);
	    } catch (Exception e2) {}
	    throw new RemoteException(e.toString());
	}

	if (!b)
	    throw new RemoteException("Cannot unexport rjx");
//System.out.println("Should exit now");
	System.exit(exitval);
//System.out.println("Should have exited");
    }

/*
    public byte [] getClass(String name) throws RemoteException
    {
	name = name.replace('.', '/');
	try
	{
	    InputStream in = streamFor(name);
	    if (in == null)
		throw new ClassNotFoundException(name);
	    int length = in.available();
	    if (length == 0)
		throw new ClassNotFoundException(name);
	    byte [] buf = new byte[length];
	    in.read(buf);
	    return buf;
	} catch (Exception e)
	{ throw new RemoteException(e.toString()); }
    }

    private InputStream streamFor(String name)
    {
	String classname = name.concat(".class");
	String classpath = System.getProperty("java.class.path");
	int lastcolon = -1, colon;
//System.out.println("Looking for " + classname);

	while ((colon = classpath.indexOf(':', lastcolon + 1)) != -1)
	{
	    try
	    {
	        String curpath = classpath.substring(lastcolon + 1, colon) +
			"/" + classname;
		File in = new File(curpath);
//System.out.println("Looking in " + curpath);
		if (in.exists() && in.canRead())
		{
		    //System.out.println("Found the class in " + curpath);
		    return new FileInputStream(in);
		}
	    } catch (Exception e)
	    { System.err.println("Exception in streamFor"); e.printStackTrace(); System.exit(1); }
	    lastcolon = colon;
	}
	if (lastcolon != (classpath.length() - 1))
	{
	    try
	    {
		//System.out.println((lastcolon + 1) + ":" + classpath.length());
	        String curpath = classpath.substring(lastcolon + 1) +
			"/" + classname;
		File in = new File(curpath);
		if (in.exists() && in.canRead())
		{
		    //System.out.println("Found the class in " + curpath);
		    return new FileInputStream(in);
		}
	    } catch (Exception e)
	    { e.printStackTrace(); System.exit(1); }
	}
	return null;
    }
*/

    private void createMainVM(String args[]) throws RemoteException
    {
	// Start the main program
	boolean isIdleOnInit = false; // main vm is not initially idle
	String hostname = localname + "_0";
	VMRegInfo done = new VMRegInfo(false);
	creating.put(hostname, done);

	String sep = System.getProperty("file.separator");
	String cwd = System.getProperty("user.dir");
	//String jhome = System.getProperty("java.home") + "/bin/java";
	String jhome = System.getProperty("java.home") +
						sep + "bin" + sep + "java";
	String cpath = System.getProperty("java.class.path");

	String cmd [] = new String[3];
	cmd[0] = rjsh;
	cmd[1] = rjshc;
	//cmd[2] = "cd " + cwd + ";" + jhome +
	cmd[2] = "cd " + "\"" + cwd + "\"" + cmdsep + "\"" + jhome + "\"" +
	//      "\"-Djava.compiler=NONE\" " +
	    (rjjo == null?"": " \""+rjjo +"\" ")+
	    " \"-Djava.rmi.server.codebase=" + codebase +
	    "\" \"-Djava.security.policy=" + policy +
	    "\" \"-Djava.rmi.server.hostname=" + localname +
	    "\" -classpath \"" + cpath + "\"" +
	    " " +
	    remoteVMClass +
	    //" edu.ucdavis.rj.rjx.rjvm" +
	    " " + localname +
	    " " + hostname + " " + localname + " " + thePort +
	    " " + (implicitTermination ? 1 : 0) + " " + verbosity +
	    " " + (isIdleOnInit ? 1 : 0) +
            " " + "VM";

	// copy the class alone
	if (args.length > 0)
	{
	    cmd[2] += " " + "\"" + args[0] + "\"";
	}
	// copy the args for main
	for (int ai = 1; ai < args.length; ai++)
	{
	    cmd[2] += " " + "\"" + args[ai] + "\"";
	}
	//cmd[2] += " >&! main.output";
	//cmd[2] += " > D:\\main.output 2>&1";
//System.out.println(cmd[2]);

	Process mainProc = null;
	try
	{
	    mainProc =
		Runtime.getRuntime().exec(cmd);
	    processes.add(mainProc);
/*
	    Thread t = new PrintThread(mainProc.getInputStream(), System.out);
	    printers.put(t, t);
	    t.start();
	    t = new PrintThread(mainProc.getErrorStream(), System.err);
	    printers.put(t, t);
	    t.start();
*/
	    mainProc.getOutputStream().close();
	} catch (IOException e)
	{ throw new RemoteException(e.toString()); }

//System.out.println("main vm creation initiated");
	// Wait for the creation to complete
	ProcessChecker waitThread =
		new ProcessChecker(mainProc, done, "main host");
	waitThread.start();
	synchronized (done)
	{
	    while (!done.getValue())
	    {
		try
		{
		    done.wait();
		} catch (Exception e)
		{}
	    }
	}
	waitThread.awaken();
	try
	{
	    waitThread.interrupt();
	} catch (Exception e) {}
	creating.remove(hostname);
	//rjvm_intf rjVM = (rjvm_intf)vms.get(hostname);
	VMElement el = (VMElement)vms.get(hostname);
	//el.idle = false; // main does not start idle
	//rjvm_intf rjVM = el.vm.rjVM;
	if (el == null || el.vm == null || el.vm.rjVM == null)
	{
	    throw new RemoteException("Cannot find main VM");
	}

//System.out.println("main vm should exist");

	// The main vm has been created, now start main on that vm
/*
	try
	{
	    rjVM.startmain(args);
	} catch (java.rmi.UnmarshalException e)
	{
	    // exception expected here because the main call may
	    // not return properly
	}
*/

//System.out.println("\t\tEnumerate processes");
	Enumeration procs = processes.elements();
	boolean alldone;
	int exitval = 0;
	while (!exiting && procs.hasMoreElements())
	{
	    alldone = false;
	    // get a process
	    Process cur = (Process)procs.nextElement();

	    while (!alldone)
	    {
		try
		{
		    exitval = cur.waitFor();
		    //cur.destroy();
		    alldone = true;
		} catch (Exception e)
		{ }
	    }
	}

//System.out.println("\t\tShould be exiting");

	// If nobody else initiated the exit then clean-up
	if (!exiting) this.exit(exitval);
    }

    private static ResourceBundle versionRB;

    public static void main(String [] args)
    {

	////////Debug.turnOn();
	Debug.println("RJ's RJ_impl.java main");

	int len = args.length;
	// all optinos to RJX are required to be passed before
	// any non-options to prevent confusion with options to
	// the RJ program
	for (int i = 0; i < args.length; i++)
	{
	    if (args[i].charAt(0) == '-')
		len--;
	    else
		break;
	}

	boolean implSet = false, verboSet = false;
	for (int i = 0; i < args.length; i++)
	{
	    if (args[i].charAt(0) != '-') break;
	    if (args[i].equals("-version"))
	    {
		try
		{
		    versionRB = ResourceBundle.
			getBundle("edu.ucdavis.rj.resources.rj");
		    System.out.println("rj version \"" +
			versionRB.getString("rj.version") + "\"");
		}
		catch (MissingResourceException e)
		{ throw new Error("Fatal: Resource for rj is missing"); }
		System.exit(0);
	    }
	    else if (args[i].equals("-implicit"))
	    {
		if (implSet)
		{
		    System.err.println("Multiple termination switches not allowed!");
		    System.exit(1);
		}
		implicitTermination = true;
		implSet = true;
		continue;
	    }
	    else if (args[i].equals("-explicit"))
	    {
		if (implSet)
		{
		    System.err.println("Multiple termination switches not allowed!");
		    System.exit(1);
		}
		implicitTermination = false;
		implSet = true;
		continue;
	    }
	    else if (args[i].equals("-verbosity"))
	    {
		if (verboSet)
		{
		    System.err.println("Multiple verbosities not allowed!");
		    System.exit(1);
		}
		verbosity = defaultVerbosityWhenSet;
		verboSet = true;
		continue;
	    }
	    else if (args[i].startsWith("-verbosity="))
	    {
		if (verboSet)
		{
		    System.err.println("Multiple verbosities not allowed!");
		    System.exit(1);
		}
		String sub = null;
		try
		{
		    sub = args[i].substring(11);
		    verbosity = Integer.parseInt(sub);
		    verboSet = true;
		}
		catch (IndexOutOfBoundsException e)
		{
		    System.err.println("invalid option: " + args[i]);
		    System.exit(1);
		}
		catch (NumberFormatException e)
		{
		    System.err.println("invalid verbosity level: " + sub);
		    System.exit(1);
		}

		continue;
	    }
	    else if (args[i].startsWith("-help"))
            {
                try
                {
                    versionRB = ResourceBundle.
                        getBundle("edu.ucdavis.rj.resources.rj");
                    System.out.println("rj rts version \"" +
                        versionRB.getString("rj.version") + "\"");
                }
                catch (MissingResourceException e)
                { throw new Error("Fatal: Resource for rj is missing"); }
      
                System.out.println("-version\t\tversion information");
                System.out.println("-implicit\t\tenable implicit termination detection (default)");
                System.out.println("-explicit\t\tdisable implicit termination detection");
                System.out.println("-verbosity=n\t\tRTS information reporting level");
                System.out.println("-help\t\t\tthis synopsis");
                System.exit(0);
            }

	    // catch an erroneous option
	    System.err.println("invalid option: " + args[i]);
	    System.exit(1);
	}

	// remove the options from the actual arguments
	String [] newargs = new String[len];
	System.arraycopy(args, args.length - len, newargs, 0, len);
	args = newargs;

	if (len == 0)
	{
	    System.err.println("Error: no program to execute");
	    System.exit(1);
	}

/*
	if (System.getSecurityManager() == null)
	{
	    System.setSecurityManager(new RMISecurityManager());
	}
*/

	try
	{
	    InetAddress addr = InetAddress.getLocalHost();
	    //localname = addr.getHostName();
	    localname = addr.getCanonicalHostName();
	    //System.out.println(localname);
	}
	catch (Exception e_addr)
	{
	    localname = LOCAL_HOST;
	    //System.err.println("Cannot get local host address");
	    //System.exit(1);
	}

        try
        {
	    new Socket(localname, 0).close();
        }
        catch (NoRouteToHostException e)
        {
	    localname = LOCAL_HOST;
            System.setProperty("java.rmi.server.hostname", LOCAL_HOST);
        }
        catch (Exception e)
        {
	    // awkward silence - ignore any other exceptions since the
	    // the attempt to connect is silly anyhow
	    // -- address stand-alone laptop bug
        }

	while (registry == null)
	{
	    // Start the name server
	    try
	    {
		registry = LocateRegistry.createRegistry(thePort);
	    }
	    catch (Exception e)
	    {
		registry = null;
		thePort++;
	    }
	}
	//name = "//" + localname + ":" + thePort + "/RJX";
	name = "//localhost:" + thePort + "/RJX";
	String loader = "//localhost:" + thePort + "/remoteLoader";
	//String loader = "//" + localname + ":" + thePort + "/remoteLoader";
//System.out.println(name);
	try
	{
	    RemoteLoader rl = new RemoteLoader_impl();
	    RJX rjx = new RJX_impl(rl);

	    //registry.rebind(name, rjx);
	    Naming.rebind(name, rjx);
	    //registry.rebind(loader, rl);
	    Naming.rebind(loader, rl);
	    //System.out.println("RJX bound");

	    // Get properties
	    //codebase = System.getProperty("java.rmi.server.codebase");
	    codebase = "";
	    //policy = System.getProperty("java.security.policy");
	    policy = "";

	    // default rjsh and rjshc depend on OS
	    String defrjsh = "csh";
	    String defrjrsh = "rsh";
            String defrjshc = "-c";
            String osname = System.getProperty("os.name");
            if (osname.startsWith(windows))
            {
                cmdsep = wincmdsep;
                defrjsh = "cmd";
                defrjshc = "/C";
            }
            rjsh = System.getProperty("RJSH");
            rjsh = ((rjsh == null) || (rjsh.length() == 0)) ? defrjsh : rjsh;
            rjrsh = System.getProperty("RJRSH");
            rjrsh = ((rjrsh == null) || (rjrsh.length() == 0)) ? defrjrsh : rjrsh;
            rjshc = System.getProperty("RJSHC");
            rjshc = ((rjshc == null) || (rjshc.length() == 0)) ? defrjshc : rjshc;
	    rjjo = System.getenv("RJJO"); // returns null if no such
            if (rjjo != null && rjjo.length() == 0) rjjo = null;

//System.out.println("Using: rjjo=" + rjjo);

	    ///System.out.println("Using: " + rjrsh + " and " + rjsh);
	    ///System.out.println(osname + " " + rjsh + " " + rjshc);

	    // create the actual main vm
	    ((RJX_impl)rjx).createMainVM(args);
	}
	catch (Exception e)
	{
	    System.err.println("rjx_impl exception: " + e.getMessage());
	    e.printStackTrace();
	    System.exit(1);
	}
    }

    public RemoteOutputStream getStdOut()
	throws RemoteException
    {
	return stdout;
    }

    public RemoteOutputStream getStdErr()
	throws RemoteException
    {
	return stderr;
    }

    public RemoteInputStream getStdIn()
	throws RemoteException
    {
	return stdin;
    }

    public InLock createRemoteLock()
	throws RemoteException
    {
	return new InLock_impl("rjx", true);
    }

    private boolean ecLocked = false;
    private Object lockObj = new Object();
    public void lockEC()
	throws RemoteException
    {
	synchronized (lockObj)
	{
	    while (ecLocked)
	    {    
		try
		{
		    lockObj.wait();
		}
		catch (Exception e) {}
	    }
	    ecLocked = true;
	}
    }

    public void unlockEC()
	throws RemoteException
    {
	synchronized (lockObj)
	{
	    ecLocked = false;
	    lockObj.notifyAll();
	}
    }

    private class Pinger extends java.lang.Thread
    {
        final int SLEEP_TIME = RJX_impl.PING_SLEEP_TIME;
        public void run()
        {
            while (true)
            {
                try
                {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (Exception e)
                {
                    if (exiting)
                    {
                        break;
		    }
		}
		synchronized (vms)
		{
		    Enumeration els = vms.elements();
		    Enumeration keys = vms.keys();

		    for (; els.hasMoreElements();)
		    {
			VMElement vmElement = (VMElement)els.nextElement();
			//rjVM = (rjvm_intf)els.nextElement();
			rjvm_intf rjVM = vmElement.vm.rjVM;
			String host = (String)keys.nextElement();

			if (rjVM == null) continue;

			//System.out.println("Pinging " + host);
			// ping the vm
			try
			{
			    rjVM.ping();
			    vmElement.missed = 0;
			} catch (Exception e)
			{
			    // couldn't reach the vm
			    vmElement.missed++;
			    if (vmElement.missed > MAX_MISSED)
			    {
				try
				{
				    host = host.substring(0,
						host.lastIndexOf('_'));
				} catch (Exception ee) { /* ignore */ }
				System.err.println("Contact with a VM on " +
					host + " has been lost ... exiting");
				try{
				    RJX_impl.this.exit(1);
				} catch (Exception ee)
				{
				    System.err.println("Abnormal exit!");
				    ee.printStackTrace();
				    System.exit(1); }
			    }
			}
		    }
		}
	    }
 	}
    } // Pinger class

    public void ping() throws RemoteException
    {}

    private static class VMElement
    {
	//public rjvm_intf vm;
	public VM vm;
	public int missed;
	public boolean idle;

	//public VMElement(rjvm_intf vm, boolean isIdle)
	public VMElement(VM vm, boolean isIdle)
	{
	    this.vm = vm;
	    this.missed = 0;
	    this.idle = isIdle;
	}
    }

    private boolean doIdleCheck = false;
    private boolean rjxIdle = true;
    public void idle(String vmName) throws RemoteException
    {
	// those locks that have been migrated to RJX will report
	// thread births and deaths on RJX -- check to see if RJX
	// goes idle
	if (vmName.equals("rjx"))
	{
	    rjxIdle = true;
	    checkAllIdle();
	    return;
	}
	Object o = null;
	synchronized (vms)
	{
	    o = vms.get(vmName);
	}
	if (o != null)
	{
	    ((VMElement)o).idle = true;
	    checkAllIdle();
	}
	else
	{
	    System.err.println("Unexpected idle message from " +
			vmName + " ... exiting!");
	    exit(1);
	}
    }

    public void notIdle(String vmName) throws RemoteException
    {
	// those locks that have been migrated to RJX will report
	// thread births and deaths on RJX -- check to see if RJX
	// goes is not longer idle
	if (vmName.equals("rjx"))
	{
	    rjxIdle = false;
	    synchronized (idleMutex)
	    {
		doIdleCheck = false;
	    }
	    return;
	}
	Object o = null;
	synchronized (vms)
	{
	    o = vms.get(vmName);
	}
	if (o != null)
	{
	    ((VMElement)o).idle = false;
	    synchronized (idleMutex)
	    {
		doIdleCheck = false;
	    }
	}
	else
	{
	    System.err.println("Unexpected not idle message from " +
			vmName + " ... exiting!");
	    exit(1);
	}
    }

    private void checkAllIdle()
    {
//System.out.println("check all idle");
	boolean allIdle = true;
	synchronized (vms)
	{
	    Enumeration els = vms.elements();

	    for (; allIdle && els.hasMoreElements();)
	    {
		VMElement el = (VMElement)els.nextElement();
//System.out.println(el.idle);
		allIdle &= el.idle;
	    }
	    allIdle &= rjxIdle;
	}
	if (allIdle)
	{
	    synchronized (idleMutex)
	    {
		doIdleCheck = true;
		idleMutex.notifyAll();
	    }
	}
    }

    private class Idler extends java.lang.Thread
    {
        public void run()
        {
            while (true)
            {
//System.out.println("idler");
		synchronized (RJX_impl.this.idleMutex)
		{
		    while (!RJX_impl.this.doIdleCheck)
		    {
			try
			{
			    RJX_impl.this.idleMutex.wait();
			}
			catch (Exception e)
			{
			    // ignore interrupt
			}
		    }
		    RJX_impl.this.doIdleCheck = false;
		}
		boolean allIdle = true;
		long messages = 0;
		int vmCount = 0; // number of VMs
		int vmNonNullCount = 0; // number of VMs that haven't failed
		synchronized (RJX_impl.this.vms)
		{
		    Enumeration els = RJX_impl.this.vms.elements();

		    for (; allIdle && els.hasMoreElements();)
		    {
			VMElement el = (VMElement)els.nextElement();
			allIdle &= el.idle;
			rjvm_intf rjVM = el.vm.rjVM;
			if (rjVM == null) continue;
			vmNonNullCount++;
			try
			{
			    TerminationData td = rjVM.checkIdle();
//System.out.println("verifying idle: " + td.idle + " - " + td.messages + " messages");
			    allIdle &= td.idle;
			    messages += td.messages;
			    vmCount++;
			}
			catch (Exception e)
			{
			    //			    e.printStackTrace();
			    // ignore for now
			    if (RJX_impl.this.exiting) return;
			}
		    }
		    TerminationData td = rjvm.checkLocalIdle();
		    allIdle &= td.idle;
		    messages += td.messages;
		}
		//		System.err.println("Quiescence tested vmCount, vmNonNullCount="
		//+vmCount+" "+vmNonNullCount);
		if (!allIdle || (messages != 0)) continue;
		// if mismatch, then 1 or more VMs have failed,
		// so make whole program fail, not quiesce.
		if (vmCount != vmNonNullCount) {
		    // System.err.println("fake Quiescence vmCount, vmNonNullCount="
		    // +vmCount+" "+vmNonNullCount +" "+RJX_impl.this.exiting);
		    try
			{
			RJX_impl.this.exit(1);
			}
		    catch (Exception e)
			{ 
			    System.err.println("Abnormal exit!");
			    e.printStackTrace();
			    System.exit(1);
			}
		}
		if (verbosity >= V_QUIESCENCE_MESSAGE)
		    System.err.println("Quiescence detected.");
		try
		{
//System.out.println("signal quiescence");
		    if (qOpProxy == null)
		    {
			RJX_impl.this.exit(0);
		    }
		    else
		    {
			OpProxy qOpProxyLoc = qOpProxy;
			qOpProxy = null;
			qOpProxyLoc.send();
		    }
		}
		catch (Exception e)
		{ 
		    System.err.println("Abnormal exit!");
		    e.printStackTrace();
		    System.exit(1);
		}
	    }
 	}
    } // Idler class

    OpProxy qOpProxy = null;
    public void registerQuiescenceAction(OpProxy opProxy)
	throws RemoteException, QuiescenceRegistrationException
    {
	qOpProxy = opProxy;
    }

    private class ProcessChecker extends java.lang.Thread
    {
	Process _p;
	VMRegInfo _done;
	String _host;
	boolean awakened = false;
	public ProcessChecker(Process p, VMRegInfo done, String host)
	{
	    _p = p;
	    _done = done;
	    _host = host;
	}
        public void run()
        {
	    boolean waiting = true;
	    int exitCode = 0;

	    while (waiting)
	    {
		try
		{
		    exitCode = _p.waitFor();
		    waiting = false;
		}
		catch (java.lang.InterruptedException e)
		{
		    if (awakened)
			return;
		}
	    }

	    // the process has terminated, if done was eventually set, then
	    // everything is cool, otherwise bad news
	    synchronized (_done)
	    {
		if (!_done.getValue())
		{
		    // done was never set, something died before replying
		    // to rjx -- exit
		    System.err.println("Cannot create virtual machine on "
			+ _host + " ... exiting!");
		    try
		    {
			RJX_impl.this.exit(1);
		    }
		    catch (Exception e)
		    {
			System.err.println("Abnormal exit!");
			e.printStackTrace();
			System.exit(1);
		    }
		}
	    }
	}
	public void awaken()
	{
	     awakened = true;
	}
    }
}
