//////////// eventually will need
/////// to handle ops and noop??????????

package edu.ucdavis.rj;

import java.lang.reflect.*;
import java.util.*;
import java.io.Serializable;


/**
 * Class representing a remote object.
 * Contains one {@code OpProxy} for each instance operation
 * in the remote object.
 */
public class RemoteRefs
    implements Serializable, Cloneable
{

    // must correspond to where Ops are declared
    private static final String opClassNamePrefix = "edu.ucdavis.rj";
    // things that can extend Op?
    /////////// won't work if, say, user code extends any of these
    ////// but maybe these should be final? or code below should test for extends
    //////rather than just name match???
    private static final String [] opClassNames = {
	opClassNamePrefix+".OpImpl",
	opClassNamePrefix+".OpInni",
	opClassNamePrefix+".OpMethod",
    };


    // String is identifier
    // OpProxy is its value
    HashMap<String, OpProxy> map;

    RemoteRefs(Class<?> cc, Object obj) {
	try {
	    this.map = getRemoteRefs(cc, obj);
	}
	catch (Exception e) {
	    throw new rjRuntimeError("RJ internal error: getRemoteRefs failed");
	}
    }

    /**
     * Returns the {@code OpProxy} within this {@code RemoteRefs}
     * for the named operation.
     * @param id the name of operation.
     *        (N.B., the name is a String.)
     * @return the {@code OpProxy} for {@code id}.
     */
    public OpProxy get(String id) {
	return map.get(id);
    }


    //////////////////////////// 
    ////////////// String is identifier
    /////// Object is its value

    // have created obj, an instance of cc.
    // get all the Op out of it.
    private static HashMap<String, OpProxy> getRemoteRefs(Class<?> cc, Object obj) 
throws java.lang.IllegalAccessException
{

	Debug.println("cc = "+ cc);

	HashMap <String, Field> mapFields = getOpFields(cc);

	Debug.println("results from getOpFields");

	/////////////////	Iterator<Field> fit = fields.values;
	Collection<Field> fc = mapFields.values();
	// just debug output
	Iterator<Field> outfit = fc.iterator();
	while (outfit.hasNext()) {
	    Field field = outfit.next();
	    Debug.println("field = "+ field);
	    Debug.println("field.getName() = "+ field.getName());
	    Debug.println("field.getType() = "+ field.getType());
	    int modifiers = field.getModifiers();
	    Debug.println("field.getModifiers() = "+ modifiers);
	    Debug.println("field is static? = "+ Modifier.isStatic(modifiers));
	    Debug.println("field is private? = "+ Modifier.isPrivate(modifiers));

	}

	HashMap<String, OpProxy> ret = new HashMap<String, OpProxy>();
	Iterator<Field> fit = fc.iterator();
	while (fit.hasNext()) {
	    Field field = fit.next();
	    Debug.println("field="+field);
	    Debug.println("field.isAccessible="+field.isAccessible());
	    // a bit of magic required here ;-)
	    field.setAccessible(true);
	    Debug.println("field.isAccessible="+field.isAccessible());
	    Debug.println("obj="+obj);

	    OpImpl fieldValue = (OpImpl)(field.get(obj));
	    if (fieldValue == null) {
		////////////////////// throw exception?????????????
		//////// or just don't put in map?
		Debug.println("user error: OpInni or OpMethod field is null = "+ field.getName());

	    }
	    ////	    ret.put(field.getName(), fieldValue);
	    ret.put(field.getName(), new OpProxy(fieldValue));
	}

	return ret;

    }

    private static  HashMap<String, Field>  getOpFields(Class<?> c) {

	HashMap<String, Field> ops = new HashMap<String, Field>();

	doGetOpFields(c, ops);

	/*
	// convert ops to an array and return it
	Field [] ret = new Field [ops.size()];
	int f = 0;
	for (Field field: ops.values()) {
	    ret[f] = field;
	    f++;
	}
	return ret;
	*/

	return ops;

    }

    // add to ops c's op fields.
    private static void doGetOpFields(Class<?> c, HashMap<String, Field> ops) {

	// those ops in c
	Field [] fields = c.getDeclaredFields();

	Debug.println("fields.length = "+ fields.length);
	Debug.println("ops.size = "+ ops.size());

	for (Field field: fields) {
	    considerField(field, ops);
	}

	// those ops in c's superclass
	Class <?> superC = c.getSuperclass();
	Debug.println("superC = "+ superC);
	if (superC != null) {
	    doGetOpFields(superC, ops);
	}

    }

    // is field of interest?
    // if so, add it to ops;
    // o.w., skip it.
    private static void considerField(Field field, HashMap<String, Field> ops) {

	Debug.println();
	Debug.println("   considerField "+ops.size());


	if (!fieldIsOp(field)) {
	    Debug.println("   considerField !fieldIsOp ");
	    return;
	}

	// need to deal with "hiding" via inheritance
	// 4 cases:
	// c has     Op x and c's super has     Op x => keep c's x
	// c has     Op x and c's super has non-Op X => keep c's x
	// c has non-Op x and c's super has     Op X => keep super's x
	// c has non-Op x and c's super has non-Op X => keep neither
	//
	// note ops contains only Operations, so this boils down to first case.
	//
	// recall that processing hierarchy in
	// subclass -> superclass order
	// (i.e., have already done subclass), so just ignore any new ones.
	String name = field.getName();

	if  (ops.containsKey(name)) {
	    Debug.println("   containsKey found dupl "+name);
	    return;
	}

	Debug.println("   considerField puttin ");
	ops.put(name, field);

    }

    // field is
    //     op
    //     not static
    //     accessible.
    private static boolean fieldIsOp(Field field) {
	Debug.println("field = "+ field);
	String name = field.getName();

	Class<?> type = field.getType();

	String typeName = type.getName();

	// make sure typeName is some kind of Op:
	boolean found = false;
	for (String opClassName: opClassNames) {
	    if (typeName.equals(opClassName)) {
		found = true;
		break;
	    }
	}
	if (!found) {
	    return false;
	}

	Debug.println("field.getName() = "+ field.getName());
	Debug.println("field.getType() = "+ field.getType());
	int modifiers = field.getModifiers();
	Debug.println("field.getModifiers() = "+ modifiers);
	Debug.println("field is static? = "+ Modifier.isStatic(modifiers));
	Debug.println("field is private? = "+ Modifier.isPrivate(modifiers));
	if (Modifier.isStatic(modifiers)) {
	    return false;
	}
	Debug.println("field is private? = "+ Modifier.isPrivate(modifiers));
	if (Modifier.isPrivate(modifiers)) {
	    return false;
	}
	return true;
    }

    /**
     * Equivalent to JR's this.remote.
     * @param  obj an {@link Object}.
     * @return RemoteRefs for {@code obj}.
     */
    public static RemoteRefs getThisRemoteRefs(Object obj) {
	RemoteRefs ret;
	Class<?> thisClass = obj.getClass();
	///System.out.println("getThisRemoteRefs thisClass="+thisClass);
	ret = new RemoteRefs(thisClass, obj);
	///System.out.println("getThisRemoteRefs ret="+ret);
	return ret;
    }

    static final long serialVersionUID = 0;

    /**
     * Clones this object.
     */
    public Object clone()
	throws CloneNotSupportedException
    {
	return super.clone();
    }


}
