// 2010-09-02 program exhibited interesting bug (which has been fixed)
// Invocation timestamps weren't being reset on send to replyOp.
// since Invocations were copied and they're used on Co's Inni,
// the order of Co's Inni was wrong.
// So, for this program, where it forces a particular order in Co's Inni,
// it was observable:  Invocation timestamps were assigned
// in order that Invocations were created -- see loop for creating doWork.
// (Changing the order of that loop also would affect outcome, but no longer
//  since bug fix.)

import edu.ucdavis.rj.*;
import edu.ucdavis.rj.CoArm.CoKind;

public class main {

    private static OpInni request = OpInni.newOpInni();

    private static OpImpl server;
    private static OpImpl worker;
    private static OpImpl client;

    private static final int NW = 2; // number of workers
    private static final int NC = 3; // number of clients
    private static final int NR = 5; // number of requests per client

    private static OpInni doWork[] = new OpInni [NW];


    public static void main(String [] args) {
	server.send();
	for (int i = 0; i < NW; i++) {
	    doWork[i] = OpInni.newOpInni();
	    worker.send(new Invocation(i));
	}
	for (int i = 0; i < NC; i++) {
	    client.send(new Invocation(i));
	}

	/////// quiescence is likely bogus, so ...
	/*****
	RJ.nap(3000);
	RJ.exit(0);
	*******/
    }


    // control the order in which workers service requests,
    // just to make the output deterministic.
    // some of these sizes depends on particular service pattern.
    // below is hard-wired.
    // pattern here:
    //   worker 0 services 2 requests
    //   worker 1 services 1 request
    //   ...

    static int servicePerTurn[] = { 2, 1 };
    static int catchup[] = { 0, 0 };
    static OpInni [] turn = new OpInni [NW]; // my turn?
    static int [] next = {1, 0};
    static {
	for (int k = 0; k < NW; k++) {
	    turn[k] = OpInni.newSem();
	}
	turn[0].V(); // start things off
    }

    static {
        try {
            server = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			//System.out.println("server process");
			while(true){
			    ArmCode ccode = new ArmCode() {
				    public void codeBlock(Invocation inv) {
					int clientId = (Integer)(inv.getParam(0));
					int clientRequestNumber = (Integer)(inv.getParam(1));
					System.out.println("server process received request: " + clientId +" "+clientRequestNumber);
					// this won't work!
					// since only first forward
					// pass replyOp.
					// but do so since it's a good test
					// to make sure it doesn't work!
					for (int k = 0; k < NW; k++) {
					    inv.forward(doWork[k]);
					}
				    }
				};
			    InniArm carm = new InniArm(request, ccode);

			    Inni inni1 = new Inni( carm );
			    inni1.service();
			}
		    }
		};
            worker = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			final int id = (Integer)(inv.getParam(0));
			//System.out.println("server process");
			while(true){
			    // wait until it's my turn:
			    turn[id].P();
			    ArmCode ccode = new ArmCode() {
				    public void codeBlock(Invocation inv) {
					int clientId = (Integer)(inv.getParam(0));
					int clientRequestNumber = (Integer)(inv.getParam(1));
					System.out.println("worker process "
							   +id+
							   " received request: " + clientId +" "+clientRequestNumber);
					// inv.setReturnValue(id*1000+clientRequestNumber);
					inv.setReturnValue(1000+id);
				    }
				};
			    InniArm carm = new InniArm(doWork[id], ccode);

			    Inni inni1 = new Inni( carm );
			    // service as many as I should this turn
			    for (int k = 1; k <= catchup[id] + servicePerTurn[id]; k++) {
				inni1.service();
			    }
			    // tell next worker how much it needs to catch up
			    // (which is how many I serviced)
			    // and then to go
			    catchup[next[id]] = servicePerTurn[id];
			    turn[next[id]].V();
			}
		    }
		};
            client = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			int id = (Integer)(inv.getParam(0));
			System.out.println("client process");
			for (int i = 0; i < NR; i++) {
			    Invocation rinv = request.call(new Invocation(id, i));
			    int result = (Integer)(rinv.getReturnValue());
			    System.out.println("client process received: " + result);
			}
		    }
		};
	} catch (Exception e) {
            System.err.println("'s");
            e.printStackTrace();
        }
    }

}
