import edu.ucdavis.rj.*;

public class Server {

    // operations invoked by Readers/Writers
    public OpInni readRequest = OpInni.newOpInni();
    public OpInni readRelease = OpInni.newOpInni();
    public OpInni writeRequest = OpInni.newOpInni();
    public OpInni writeRelease = OpInni.newOpInni();

    public Server() {
	try {
	    server.send();
	} catch (Exception e) {
	    System.err.println("server.send");
	    e.printStackTrace();
	}
    }

    int nr = 0; // class-level so can access easily w/i armcode. ugh.

    OpMethod server;

    {
	try {
	    server = new OpMethod() {
		    public void codeBlock(Invocation pinv) {

			System.out.println("starting up server");

			ArmCode readRequestCode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr++;
				}
			    };

			ArmCode writeRequestCode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    // the tricky case: don't let this writer
				    // proceed until all reads have finished
				    while (nr > 0) {
					readRelease.receive();
					nr--;
				    }
				    // nr==0, so let writer proceed
				    // and then wait for it to finish
				    inv.reply();
				    writeRelease.receive();
				    // since nr==0, enclosing while terminates
				}
			    };

			ArmCode readReleaseCode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr--;
				}
			    };

			InniArm readRequestArm2 = new InniArm(readRequest, readRequestCode2);
			InniArm writeRequestArm2 = new InniArm(writeRequest, writeRequestCode2);
			InniArm readReleaseArm2 = new InniArm(readRelease, readReleaseCode2);
			final Inni inni2 = new Inni( readRequestArm2, writeRequestArm2, readReleaseArm2 );

			ArmCode readRequestCode1 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    inv.reply();
				    nr++;
				    while (nr > 0) {
					inni2.service();
				    }
				}
			    };

			ArmCode writeRequestCode1 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    inv.reply();
				    writeRelease.receive();
				}
			    };

			InniArm readRequestArm1 = new InniArm(readRequest, readRequestCode1);
			InniArm writeRequestArm1 = new InniArm(writeRequest, writeRequestCode1);
			Inni inni1 = new Inni( readRequestArm1, writeRequestArm1 );

			while (true) {
			    System.out.println("Server nr=" +nr); // always 0
			    inni1.service();
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server");
	    e.printStackTrace();
	}
    }
}

