import edu.ucdavis.rj.*;

import java.util.ArrayList;
import java.util.Iterator;

public class MyShape<E>
{
	private E id;
	OpProxy mycap;

	public MyShape(E id)
	{
		this.id = id;
		mycap = new OpProxy(testReply);
	}

        public OpMethod get, set, print, testReply;
        {
            try {
                get = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    inv.setReturnValue(id);
                        }
                    };
                set = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    E invId = (E)(inv.getParam(0));
			    id = invId;
                        }
                    };
                print = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    System.out.println("MyShape " + id);
                        }
                    };
                testReply = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    E x = (E)(inv.getParam(0));
			    inv.reply(x);
                        }
                    };
            } catch (Exception e) {
                System.err.println("OpMethods");
                e.printStackTrace();
            }
        }

	public String toString() {
		return id.toString();
	}

	public static void main(String [] args)
	{
		ArrayList<MyShape> shapes = new ArrayList<MyShape>();

		MyShape<String> square = new MyShape<String>("square");
		MyShape<String> triangle = new MyShape<String>("triangle");
		MyShape<String> rectangle = new MyShape<String>("rectangle");

		shapes.add(square);
		shapes.add(triangle);
		shapes.add(rectangle);

		System.out.println("A list of shapes: ");
		for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		{
			it.next().print.call();
		}

                System.out.println("changing triangle to equilateral triangle...");
                triangle.set.call(new Invocation("equilateral triangle"));
		Invocation rinv = triangle.get.call();
                System.out.println("shape just changed: " + rinv.getReturnValue());


                System.out.println("Now the list of shapes becomes: ");
                for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		    {
                        it.next().print.call();
		    }

		try {
		    rinv = square.mycap.call(new Invocation("hihi"));
		} catch (Exception e) {
		    System.err.println("square.mycap.call");
		    e.printStackTrace();
		}

		String result = (String)(rinv.getParam(0));
		System.out.println("call serviced by op: "+result);
	}
}
