// 2017-04-02 based on extensions to CO to allow VMs to be created in parallel.
// shows how to simulate parameterized VMs.

import edu.ucdavis.rj.*;

public class Main {

    private static OpInni done = OpInni.newOpInni();
    private static OpProxy pDone = new OpProxy(done);

    public static void main(String [] args) {

	// nVM and n picked to spread things a bit unevenly
        int nVM = 5; // number of VMs
        int n = 9; // number of philosophers
	int t = 3; // number of sessions per philosopher
  
        VM vmref[] = new VM [nVM];

            // remote Servant s = new remote Servant(n);

	try {

	    // remote Servant s[] = new remote Servant[n];

	    RemoteRefs [] s = new RemoteRefs[n];

	    System.out.println("Main starts");


	for( int i = 0; i < nVM; i++ ) {
	    VM vmi = Create.createVM();
	    vmref[i] = vmi;
	    Create.createInstance(vmi, "Glob", i);
	}

	for( int i = 0; i < n; i++ ) {
	    VM vmi = vmref[i % nVM];
            // s[i] = new remote Servant(i) on vmi;
	    s[i] = Create.createInstance(vmi, "Servant", i);
	    // new remote Philosopher(s, i, t, done) on vmi;
	    Create.createInstance(vmi, "Philosopher", s[i], i, t, pDone);
	}


	    // give each Servant capabilities for
	    // its two neighboring Servants
	    System.out.println("before start computation");
	    for( int i = 0; i < n; i++ ) {
		int left = (i-1<0?n-1:i-1), right = (i+1>n-1?0:i+1);
		Op links = (Op)(s[i].get("links"));
		links.send(new Invocation(s[left],s[right]));
	    }

	    // initialize each Servant's forks;
	    // ..........
	    Op forks;
	    System.out.println("before start forks");
	    forks = s[0].get("forks");
	    forks.send(new Invocation(true, true, true, true));
	    for( int i = 1; i < n-1; i++ ) {
		forks = s[i].get("forks");
		forks.send(new Invocation(false, false, true, false));
	    }
	    forks = s[n-1].get("forks");
	    forks.send(new Invocation(false, false, false, false));

	    System.out.println("main after distributed forks");


	//// System.out.println("main after Servant and Philosophers started up");
	// wait for Philosophers to finish
	    for ( int i = 1; i <= n; i++ ) {
		done.receive();
	    }
	    RJ.exit(0);

	} catch (Exception e) {
	    System.err.println("Main's loop");
	    e.printStackTrace();
	}
    }



}

