import edu.ucdavis.rj.*;

public class Main {

    private static OpImpl save, update;

    private static final int n = 20;
    private static int [] sum = new int [n];
    private static int [] old = new int [n];

    static {
	for (int i = 0; i < n; i++) {
	    sum[i] = i;
	}
    }

    private static int d;

    public static void main(String [] args) {

	for (d = 1; d < n; d = d+d) {
	    /***
	    co ((int i = 0; i < n; i++)) save(i);
	    ***/
	    {
		Quantifiers [] qs = new Quantifiers[n];
		OpImpl [] op = new OpImpl[n];
		Invocation [] inv = new Invocation[n];

		int k = 0;
		for (int i = 0; i < n; i++) {
		    qs[k] = new Quantifiers(i);
		    op[k] = save;
		    inv[k] = new Invocation(i);
		    k++;
		}

		CoArm arm1 = new CoArm(new CoArm.OpArray(qs, op, inv));

		Co co1 = new Co(arm1);
		co1.go();
	    }

	    /***
	    co ((int i = 0; i < n; i++)) update(i);
	    ***/
	    {
		Quantifiers [] qs = new Quantifiers[n];
		OpImpl [] op = new OpImpl[n];
		Invocation [] inv = new Invocation[n];

		int k = 0;
		for (int i = 0; i < n; i++) {
		    qs[k] = new Quantifiers(i);
		    op[k] = update;
		    inv[k] = new Invocation(i);
		    k++;
		}

		CoArm arm1 = new CoArm(new CoArm.OpArray(qs, op, inv));

		Co co1 = new Co(arm1);
		co1.go();
	    }

	}
	for (int i = 0; i < n; i++) {
	    System.out.println(i + " " + sum[i]);
	}

	/////// quiescence is likely bogus, so ...
	///JR.nap(3000);
	///JR.exit(0);
    }

    static {
        try {
            save = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			int i = (Integer)(inv.getParam(0));
			old[i] = sum[i];
		    }
		};
            update = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			int i = (Integer)(inv.getParam(0));
			if (i-d >= 1) sum[i] += old[i-d];
		    }
		};
	} catch (Exception e) {
            System.err.println("'s");
            e.printStackTrace();
        }
    }

}
