import edu.ucdavis.rj.*;

public class Main {

    static OpInni joo = OpInni.newOpInni();

    public static void main(String [] args ) {

        // register done as the quiescence operation
        try {
            RJ.registerQuiescenceAction(new OpProxy(done));
        } catch (edu.ucdavis.rj.QuiescenceRegistrationException e) {
	    e.printStackTrace();
        }

	final int ITIMEOUT = Integer.parseInt(args[0]);

	final int UTIMEOUT = Integer.parseInt(args[1]);

	final int XTIMEOUT = 4 * UTIMEOUT;

	u.send(new Invocation(UTIMEOUT));

	/***
	    inni void joo(){ 
	    System.out.println("in joo");
	    // sleep long enough for u to finish
	    RJ.nap(XTIMEOUT);
	    }
	    [] elseafter ITIMEOUT { 
	    System.out.println("in elseafter"); 
	    receive joo();
	    System.out.println("got joo in elseafter"); 
	    }
	****/

	ArmCode jcode = new ArmCode() {
		public void codeBlock(Invocation inv) {
		    System.out.println("in joo");
		    // sleep long enough for u to finish
		    RJ.nap(XTIMEOUT);
		    System.out.println("in joo after sleep");
		}
	    };
	InniArm jarm = new InniArm(joo, jcode);

	InniArmElseCode elsecode = new InniArmElseCode() {
		public void codeBlock() {
		    System.out.println("in elseafter"); 
		    joo.receive();
		    System.out.println("got joo in elseafter"); 
		}
	    };

	InniArmElseafter elseafterArm = new InniArmElseafter(ITIMEOUT, elsecode);
	Inni inni1 = new Inni( elseafterArm, jarm );
	inni1.service();
	
    }

    public static OpMethod u;
    static {
        try {
            u = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			int nap = (Integer)(inv.getParam(0));
			RJ.nap(nap);
			joo.send();
		    }
                };
        } catch (Exception e) {
            System.err.println("u's");
            e.printStackTrace();
        }
    }

    public static OpMethod done;
    static {
        try {
            done = new OpMethod() {
                    public void codeBlock(Invocation inv) {
			System.out.println("Quiescence!");
                                            }
                };
        } catch (Exception e) {
            System.err.println("done's");
            e.printStackTrace();
        }
    }

}
