import edu.ucdavis.rj.*;

import java.io.*;
public class Jacobi {
  private int PR, S;
  public Jacobi(int PR, int S) {
    this.PR = PR;
    this.S = S;
  }
    boolean ans; // hack -- global
  public Results compute(int N, double xl, double xt,
                         double xr, double xb, double epsilon) {
    //// op boolean terminate(double);
    OpInni terminate = OpInni.newOpInni();
    // op void gather(int, double [][]);
    OpInni gather = OpInni.newOpInni();
    OpProxy pGather = new OpProxy(gather);

    //// remote Worker wref[] = new remote Worker[PR];
    RemoteRefs wref[] = new RemoteRefs[PR];
    double [][] matrix = new double [N+2][N+2];

    //// vmi = new vm() on hostnames[0];
    ////wref[0] = new remote Worker(1,N,PR,S,xl,xt,xr,0.0)
	////on vmi;
    wref[0] = Create.createInstance("Worker", 1,N,PR,S,xl,xt,xr,0.0);
    for (int i = 1; i <= PR-2; i++) {
	    //// vmi = new vm() on hostnames[i];
	////wref[i] = new remote Worker(i+1,N,PR,S,xl,0.0,xr,0.0)
	    //// on vmi;
	    wref[i] = Create.createInstance("Worker", i+1,N,PR,S,xl,0.0,xr,0.0);
    }
    ////vmi = new vm() on hostnames[PR-1];
    ////wref[PR-1] = new remote Worker(PR,N,PR,S,xl,0.0,xr,xb)
	////on vmi;
	wref[PR-1] = Create.createInstance("Worker", PR,N,PR,S,xl,0.0,xr,xb);

	////long timerFinish = System.currentTimeMillis();
	////System.out.println("lineTIME   " + (timerFinish-timerStart) + " ms"
		        // following is macro defined in m4
	////		   +" newsCombinedSeq /home/olsson/WW7/pdeDha/B1000");

    // start the computation
	////send wref[0].compute(noop, wref[1], terminate, gather);
	////for (int i = 1; i <= PR-2; i++) {
	////send wref[i].compute(wref[i-1],wref[i+1],terminate, gather);
	////}
	////send wref[PR-1].compute(wref[PR-2], noop, terminate, gather);

	System.out.println("before start computation");
	OpProxy term = new OpProxy(terminate);
	try {
	    OpProxy compute = wref[0].get("compute");
	    // note: wref[0] in send should be NOOP
	    // but RJ doesn't have noop RemoteRefs
	    compute.send(new Invocation(wref[0], wref[1], term, pGather));
	    for( int i = 1; i <= PR-2; i++ ) {
		// send wref[i].compute(wref[i-1],wref[i+1],terminate);
		compute = wref[i].get("compute");
		compute.send(new Invocation(wref[i-1],wref[i+1], term, pGather));
	    }
	    //          send wref[PR-1].compute(wref[PR-2],noop, terminate);
	    // send wref[PR-1].compute(wref[PR-2],wref[0], terminate);
	    compute = wref[PR-1].get("compute");
	    // note: wref[0] in send should be NOOP
	    // but RJ doesn't have noop RemoteRefs
	    compute.send(new Invocation(wref[PR-2],wref[0], term, pGather));
	} catch (Exception e) {
	    System.err.println("compute.send");
	    e.printStackTrace();
	}

	// do termination checks until convergence
        System.out.println("before convergence check");
	int iters = 0;
	ans = false;
	while ( !ans ) {
	    iters++;
	    /***
                inni boolean terminate(double diff)
		    st terminate.length() == PR by -diff {
		        ans = (diff <= epsilon);
			for( int i = 1; i <= PR-1; i++ ) {
			        inni boolean terminate(double diff_unused) {
			            return ans;
			        }
			}
			return ans;
		}
	    ***/

	    ArmCode farmcode = new ArmCode() {
		    public void codeBlock(Invocation inv) {
			double diff = (double)(inv.getParam(0));
			ans = (diff <= epsilon);
			ArmCode garmcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    double diff_unused = (double)(inv.getParam(0));
				    inv.setReturnValue(ans);
				}
			    };
			InniArm garm = new InniArm(terminate, garmcode);
			Inni inni2 = new Inni( garm );

			for( int i = 1; i <= PR-1; i++ ) {
			    inni2.service();
			}
			inv.setReturnValue(ans);
		    }
		};
	    InniArm.SuchThat fst = new InniArm.SuchThat() {
		    public boolean expr(Invocation inv) {
			return terminate.length() == PR;
		    }
		};
	    InniArm farm = new InniArm(terminate, fst, new Common.Largest(0), farmcode);
	    Inni inni1 = new Inni( farm );
	    inni1.service();
	}

        System.out.println("has converged; now gathering");


    // accumulate results from each Worker.
    // Worker sends back all its S+2 rows;
    // copy middle S rows from all Workers,
    // but also topmost row from top Worker
    // and bottommost row from bottom Worker.
    ////for (int i = 0; i < PR; i++) {
    ////  inni void gather(int id, double [][] chunk) {
    ////    // copy chunk into matrix
    ////    for (int r = (id==0?0:1); r <= (id==PR?S+1:S); r++) {
    ////      matrix[r+(id-1)*S] = chunk[r];
    ////    }
    ////  }
    ////}

    ArmCode garmcode = new ArmCode() {
	    public void codeBlock(Invocation inv) {
		int id = (int)(inv.getParam(0));
		//////System.out.println("id="+id);
		Double [][] chunk = (Double [][])(inv.getParam(1));
		// copy chunk into matrix
		for (int r = (id==0?0:1); r <= (id==PR?S+1:S); r++) {
		    ////System.out.println("id="+id +" r="+r+" rr"+(r+(id-1)*S));
		    // unfortunately can't copy entire row
		    // since chunk is a Double[][], and matrix is a double[][]
		    // matrix[r+(id-1)*S] = chunk[r];
		    for (int c = 0; c < N+2; c++) {
			matrix[r+(id-1)*S][c] = chunk[r][c];
		    }
		}
	    }
	};
    InniArm garm = new InniArm(gather, garmcode);
    Inni innig = new Inni( garm );

    for (int i = 0; i < PR; i++) {
	innig.service();
    }

    return new Results(iters, matrix);
  }

}

