/****
# timing for loop control overhead
# An empty fa loop is repeated 'limit' number of times.   
****/

import edu.ucdavis.rj.*;

public class Loop {
  

   private int limit;
   private int factor;
   private int base;
   private int trials;

   public Loop(int factor, int base, int trials) {

      this.factor = factor;
      this.base   = base;
      this.trials = trials;

      limit = factor * base;

         test.call(); // should be send,
		      // but don't want to shutdown program until done.
   }

    OpMethod dummy = null;
    {
        try {
            dummy = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
		    }
		};
	} catch (Exception e) {
	    System.err.println("dummy");
	    e.printStackTrace();
	}
    }

    OpMethod test = null;
    {
        try {
            test = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			long start, finish;

			for (int t = 1; t <= trials; t++ ) {
			    start = System.currentTimeMillis();
			    for (int i = 1; i<=limit ; i++) {
				// do nothing
			    }
			    finish =System.currentTimeMillis();
			    System.out.println(limit + " times   " + (finish-start) + " ms");
			}

		    }
		};
	} catch (Exception e) {
	    System.err.println("test");
	    e.printStackTrace();
	}
    }

}
