/****
# context switch using message passing
# The context switch is similar to switch using semaphores.  The only
# difference is that message passing is used instead of semaphores.
# The reported number of times is twice the loop limit
# because two context switches occur on each pass.
****/



import edu.ucdavis.rj.*;

public class Context {
  
    private OpInni up = OpInni.newOpInni();
    private OpInni down = OpInni.newOpInni();

   // to control shutdown
    private OpInni done = OpInni.newSem(0);

   private int limit;
   private int factor;
   private int base;
   private int trials;

   public Context(int factor, int base, int trials) {

      this.factor = factor;
      this.base   = base;
      this.trials = trials;

      limit = factor * base / 2; // **** note the "/ 2"; see above comment

         p1.send();
         p2.send();
	 // don't want to shutdown program until done.
	 done.P();
	 done.P();
   }

   // would-be process
    OpMethod p1 = null;
    OpMethod p2 = null;
    {
        try {
            p1 = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			long start, finish;

			for (int t = 1; t <= trials; t++ ) {
			    start = System.currentTimeMillis();
			    for (int i = 1; i<=limit ; i++) {
				up.send();
				down.receive();
			    }
			    finish =System.currentTimeMillis();
			    System.out.println(2*limit + " times   " + (finish-start) + " ms");
			}
			done.V();
		    }
		};
            p2 = new OpMethod() {
		    public void codeBlock(Invocation pinv) {

			for (int t = 1; t <= trials; t++ ) {
			    for (int i = 1; i<=limit ; i++) {
				up.receive();
				down.send();
			    }
			}
			done.V();
		    }
		};
	} catch (Exception e) {
	    System.err.println("p1 or p2");
	    e.printStackTrace();
	}
    }

}
