import edu.ucdavis.rj.*;

public class Main{
    public static void main(String[] args) {

	OpInni f = OpInni.newOpInni();
	OpProxy c, d;

      // they do compare equally, when "local"
      c = null;
      d = null;
      System.out.println("c==c? "+(c==c));
      System.out.println("c==d? "+(c==d));
      System.out.println("f==f? "+(f==f));
      // since c and d are null:
      System.out.println("c==f? "+(f.equals(c)));
      System.out.println("d==f? "+(f.equals(d)));

      // they do compare equally, when "local"
      c = new OpProxy(OpInni.noop);
      d = new OpProxy(OpInni.noop);
      System.out.println("c==c? "+(c.equals(c)));
      System.out.println("c==d? "+(c.equals(d)));
      System.out.println("f==f? "+(f.equals(f)));
      System.out.println("c==f? "+(c.equals(f)));
      System.out.println("d==f? "+(d.equals(f)));

      // they do compare equally, when "local"
      c = new OpProxy(f);
      d = new OpProxy(f);
      System.out.println("c==c? "+(c.equals(c)));
      System.out.println("c==d? "+(c.equals(d)));
      System.out.println("f==f? "+(f.equals(f)));
      System.out.println("c==f? "+(c.equals(f)));
      System.out.println("d==f? "+(d.equals(f)));


      OpInni g = OpInni.newOpInni();
      c = new OpProxy(g);
      d = new OpProxy(g);
      System.out.println("c==c? "+(c.equals(c)));
      System.out.println("c==d? "+(c.equals(d)));
      System.out.println("f==f? "+(f.equals(f)));
      System.out.println("c==f? "+(c.equals(f)));
      System.out.println("d==f? "+(d.equals(f)));

      VM v1;
      v1 = Create.createVM();

      RemoteRefs funRefs;
      funRefs = Create.createInstance(v1, "C");

      OpProxy thefun;
      thefun = funRefs.get("compare");

      // lazy?
      OpProxy noop = new OpProxy(OpInni.noop);
      OpProxy h = new OpProxy(f);

      System.out.println("w.compare(c,c)? "+ wcompare(thefun, c,c));
      System.out.println("w.compare(c,d)? "+ wcompare(thefun, c,d));
      System.out.println("w.compare(f,f)? "+ wcompare(thefun, h,h));
      System.out.println("w.compare(null,null)? "+ wcompare(thefun, null,null));
      System.out.println("w.compare(noop,noop)? "+ wcompare(thefun, noop,noop));
      System.out.println("w.compare(noop,null)? "+ wcompare(thefun, noop,null));
      System.out.println("w.compare(null,noop)? "+ wcompare(thefun, null,noop));
      System.out.println("w.compare(c,null)? "+ wcompare(thefun, c,null));
      System.out.println("w.compare(c,noop)? "+ wcompare(thefun, c,noop));
      System.out.println("w.compare(f,null)? "+ wcompare(thefun, h,null));
      System.out.println("w.compare(f,noop)? "+ wcompare(thefun, h,noop));

      thefun = new OpProxy(C.staticCompare);

      System.out.println("w.staticCompare(c,c)? "+ wcompare(thefun, c,c));
      System.out.println("w.staticCompare(c,d)? "+ wcompare(thefun, c,d));
      System.out.println("w.staticCompare(f,f)? "+ wcompare(thefun, h,h));
      System.out.println("w.staticCompare(null,null)? "+ wcompare(thefun, null,null));
      System.out.println("w.staticCompare(noop,noop)? "+ wcompare(thefun, noop,noop));
      System.out.println("w.staticCompare(noop,null)? "+ wcompare(thefun, noop,null));
      System.out.println("w.staticCompare(null,noop)? "+ wcompare(thefun, null,noop));
      System.out.println("w.staticCompare(c,null)? "+ wcompare(thefun, c,null));
      System.out.println("w.staticCompare(c,noop)? "+ wcompare(thefun, c,noop));
      System.out.println("w.staticCompare(f,null)? "+ wcompare(thefun, h,null));
      System.out.println("w.staticCompare(f,noop)? "+ wcompare(thefun, h,noop));

	System.out.println("done");
    }

    static boolean wcompare(OpProxy thefun, OpProxy a, OpProxy b) {
	Invocation inv = new Invocation(a, b);
        try {
            inv = thefun.call(inv);
        } catch (Exception e) {
            System.err.println("wcompare");
            e.printStackTrace();
        }
        boolean result = (Boolean)(inv.getReturnValue());
	return result;
    }

}
