/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.rj;

import edu.ucdavis.rj.ArmCode;
import edu.ucdavis.rj.BaseArmCode;
import edu.ucdavis.rj.CoArm;
import edu.ucdavis.rj.Inni;
import edu.ucdavis.rj.InniArm;
import edu.ucdavis.rj.Invocation;
import edu.ucdavis.rj.OpProxy;
import edu.ucdavis.rj.Quantifiers;
import edu.ucdavis.rj.rjRuntimeError;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class Co {
    ArrayList<CoArm> arms;

    public Co(CoArm coArm, CoArm ... coArmArray) {
        this.createCo(coArm, coArmArray);
    }

    private void createCo(CoArm coArm, CoArm ... coArmArray) {
        this.arms = new ArrayList();
        int n = 0;
        this.oneCoArm(coArm, n);
        for (CoArm coArm2 : coArmArray) {
            this.oneCoArm(coArm2, ++n);
        }
    }

    private void oneCoArm(CoArm coArm, int n) {
        if (coArm == null) {
            throw new rjRuntimeError("Co given null arm (arm " + n + ", counting from 0)");
        }
        if (coArm.op != null) {
            this.arms.add(coArm);
        } else if (coArm.oa != null) {
            ArrayList<OpProxy> arrayList = coArm.oa.getOpsList();
            ArrayList<Invocation> arrayList2 = coArm.oa.getInvocationsList();
            ArmCode armCode = coArm.getCode();
            ArrayList<Quantifiers> arrayList3 = coArm.oa.getQuantifiersList();
            CoArm.CoKind coKind = coArm.getCoKind();
            if (arrayList3 != null && arrayList.size() != arrayList3.size()) {
                throw new rjRuntimeError("Co OpArray and quants sizes differ");
            }
            if (arrayList3 != null && arrayList2.size() != arrayList3.size()) {
                throw new rjRuntimeError("Co OpArray and invocation list sizes differ");
            }
            int n2 = 0;
            for (OpProxy opProxy : arrayList) {
                Quantifiers quantifiers = arrayList3 == null ? null : arrayList3.get(n2);
                Invocation invocation = arrayList2.get(n2);
                this.arms.add(new CoArm(quantifiers, opProxy, invocation, armCode, coKind));
                ++n2;
            }
        } else {
            throw new rjRuntimeError("RJ internal error: bad CoArm");
        }
    }

    public BaseArmCode.Control go() {
        Object object;
        BaseArmCode.Control control = BaseArmCode.Control.NORMAL;
        if (this.arms.size() == 0) {
            return control;
        }
        InniArm inniArm = null;
        InniArm[] inniArmArray = new InniArm[this.arms.size() - 1];
        int n = 0;
        int n2 = 0;
        for (CoArm coArm : this.arms) {
            ++n2;
            object = coArm.op;
            try {
                if (coArm.coKind == CoArm.CoKind.COSEND || ((OpProxy)object).isNoop()) {
                    coArm.replyOp.send();
                    coArm.inv.setReplyOp(null);
                } else if (coArm.coKind == CoArm.CoKind.COCALL) {
                    coArm.inv.setReplyOp(new OpProxy(coArm.replyOp));
                } else {
                    throw new rjRuntimeError("RJ internal error: unknown arm.coKind");
                }
                ((OpProxy)object).send(coArm.inv);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                System.exit(1);
            }
            InniArm inniArm2 = new InniArm(coArm.quants, new OpProxy(coArm.replyOp), null, null, coArm.code);
            if (n == 0) {
                inniArm = inniArm2;
            } else {
                inniArmArray[n - 1] = inniArm2;
            }
            ++n;
        }
        Inni inni = new Inni(inniArm, inniArmArray);
        for (int i = 1; i <= n2 && (object = inni.service()) != BaseArmCode.Control.BREAK; ++i) {
            if (object == BaseArmCode.Control.CONTINUE || object != BaseArmCode.Control.RETURN) continue;
            control = BaseArmCode.Control.RETURN;
            break;
        }
        return control;
    }
}

