/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.rj;

import edu.ucdavis.rj.ArmCode;
import edu.ucdavis.rj.Invocation;
import edu.ucdavis.rj.OpImpl;
import edu.ucdavis.rj.OpInni;
import edu.ucdavis.rj.OpInniIterator;
import edu.ucdavis.rj.OpProxy;
import edu.ucdavis.rj.Quantifiable;
import edu.ucdavis.rj.Quantifiers;
import edu.ucdavis.rj.rjRuntimeError;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;

public class InniArm {
    Quantifiers quants;
    OpProxy op;
    SuchThat st;
    By by;
    ArmCode code;
    OpArray oa;

    InniArm(Quantifiers quantifiers, OpProxy opProxy, SuchThat suchThat, By by, ArmCode armCode) {
        if (opProxy == null) {
            throw new NullPointerException("OpProxy given to InniArm is null");
        }
        this.commonSingle(quantifiers, opProxy, suchThat, by, armCode);
    }

    void commonSingle(Quantifiers quantifiers, OpProxy opProxy, SuchThat suchThat, By by, ArmCode armCode) {
        this.checkOpProxyIsForOpInni(opProxy, -1);
        this.quants = quantifiers;
        this.op = opProxy;
        this.st = suchThat;
        this.by = by;
        this.code = armCode;
    }

    public InniArm(OpInni opInni, SuchThat suchThat, By by, ArmCode armCode) {
        if (opInni == null) {
            throw new NullPointerException("OpInni given to InniArm is null");
        }
        this.commonSingle(null, new OpProxy(opInni), suchThat, by, armCode);
    }

    public InniArm(OpInni opInni, SuchThat suchThat, By by) {
        this(opInni, suchThat, by, null);
    }

    public InniArm(OpInni opInni, SuchThat suchThat, ArmCode armCode) {
        this(opInni, suchThat, null, armCode);
    }

    public InniArm(OpInni opInni, SuchThat suchThat) {
        this(opInni, suchThat, null, null);
    }

    public InniArm(OpInni opInni, By by, ArmCode armCode) {
        this(opInni, null, by, armCode);
    }

    public InniArm(OpInni opInni, By by) {
        this(opInni, null, by, null);
    }

    public InniArm(OpInni opInni, ArmCode armCode) {
        this(opInni, null, null, armCode);
    }

    public InniArm(OpInni opInni) {
        this(opInni, null, null, null);
    }

    public InniArm(OpProxy opProxy, SuchThat suchThat, By by, ArmCode armCode) {
        this(null, opProxy, suchThat, by, armCode);
    }

    public InniArm(OpProxy opProxy, SuchThat suchThat, By by) {
        this(opProxy, suchThat, by, null);
    }

    public InniArm(OpProxy opProxy, SuchThat suchThat, ArmCode armCode) {
        this(opProxy, suchThat, null, armCode);
    }

    public InniArm(OpProxy opProxy, SuchThat suchThat) {
        this(opProxy, suchThat, null, null);
    }

    public InniArm(OpProxy opProxy, By by, ArmCode armCode) {
        this(opProxy, null, by, armCode);
    }

    public InniArm(OpProxy opProxy, By by) {
        this(opProxy, null, by, null);
    }

    public InniArm(OpProxy opProxy, ArmCode armCode) {
        this(opProxy, null, null, armCode);
    }

    public InniArm(OpProxy opProxy) {
        this(opProxy, null, null, null);
    }

    public InniArm(OpArray opArray, SuchThat suchThat, By by, ArmCode armCode) {
        if (opArray == null) {
            throw new NullPointerException("OpArray given to InniArm is null");
        }
        this.oa = opArray;
        this.st = suchThat;
        this.by = by;
        this.code = armCode;
        this.checkArray();
    }

    private void checkArray() {
        this.oa.checkQuantifiers();
        this.oa.checkOps();
        int n = 0;
        for (OpProxy opProxy : this.oa.opsList) {
            this.checkOpProxyIsForOpInni(opProxy, n);
            ++n;
        }
    }

    public InniArm(OpArray opArray, SuchThat suchThat, By by) {
        this(opArray, suchThat, by, null);
    }

    public InniArm(OpArray opArray, SuchThat suchThat, ArmCode armCode) {
        this(opArray, suchThat, null, armCode);
    }

    public InniArm(OpArray opArray, SuchThat suchThat) {
        this(opArray, suchThat, null, null);
    }

    public InniArm(OpArray opArray, By by, ArmCode armCode) {
        this(opArray, null, by, armCode);
    }

    public InniArm(OpArray opArray, By by) {
        this(opArray, null, by, null);
    }

    public InniArm(OpArray opArray, ArmCode armCode) {
        this(opArray, null, null, armCode);
    }

    public InniArm(OpArray opArray) {
        this(opArray, null, null, null);
    }

    void checkOpProxyIsForOpInni(OpProxy opProxy, int n) {
        try {
            if (!opProxy.canAppearInInni()) {
                String string = "can't use an OpMethod in an InniArm";
                if (n >= 0) {
                    string = string + " (item " + n + " in op list) ";
                }
                throw new rjRuntimeError(string);
            }
        }
        catch (RemoteException remoteException) {
            throw new rjRuntimeError("RJ internal error:  InniArm op.canAppearInInni()");
        }
    }

    public OpProxy getOpProxy() {
        return this.op;
    }

    ArmCode getCode() {
        return this.code;
    }

    public Invocation selectInvocation() {
        boolean bl = this.st != null;
        boolean bl2 = this.by != null;
        int n = -1;
        Invocation invocation = null;
        Comparable comparable = null;
        OpInniIterator opInniIterator = null;
        try {
            opInniIterator = this.op.elements();
        }
        catch (RemoteException remoteException) {
            throw new rjRuntimeError("RJ internal error: InniArm op.elements()");
        }
        while (opInniIterator.hasNext()) {
            Invocation invocation2 = (Invocation)opInniIterator.next();
            Quantifiable.Helper.setQuantifiers(this.st, this.quants);
            if (this.st != null && !this.st.expr(invocation2)) continue;
            if (!bl2) {
                n = opInniIterator.getCurInvocationIndex();
                invocation = invocation2;
                break;
            }
            Quantifiable.Helper.setQuantifiers(this.by, this.quants);
            Comparable comparable2 = this.by.expr(invocation2);
            if (n >= 0 && this.by.compareTo(comparable2, comparable) >= 0) continue;
            n = opInniIterator.getCurInvocationIndex();
            invocation = invocation2;
            comparable = comparable2;
        }
        if (n >= 0) {
            opInniIterator.remove(n);
        }
        opInniIterator.unregister();
        return invocation;
    }

    public static abstract class By
    implements Quantifiable {
        public Quantifiers q;

        public abstract Comparable expr(Invocation var1);

        public int compareTo(Comparable comparable, Comparable comparable2) {
            return comparable.compareTo(comparable2);
        }

        @Override
        public void setQuantifiers(Quantifiers quantifiers) {
            this.q = quantifiers;
        }
    }

    public static abstract class SuchThat
    implements Quantifiable {
        public Quantifiers q;

        public abstract boolean expr(Invocation var1);

        @Override
        public void setQuantifiers(Quantifiers quantifiers) {
            this.q = quantifiers;
        }
    }

    public static class OpArray {
        ArrayList<Quantifiers> quantsList;
        ArrayList<OpProxy> opsList;
        String classNameForErrors = "InniArm";

        public OpArray(Quantifiers[] quantifiersArray, OpImpl[] opImplArray) {
            this.quantsList = this.safeNewArrayList(quantifiersArray);
            this.opsList = this.getArrayListFromArray(opImplArray);
            this.commonCheck();
        }

        public OpArray(ArrayList<Quantifiers> arrayList, ArrayList<OpImpl> arrayList2) {
            this.quantsList = this.safeNewArrayList(arrayList);
            this.opsList = this.getArrayListFromArrayList(arrayList2);
            this.commonCheck();
        }

        public OpArray(OpImpl[] opImplArray) {
            this.opsList = this.getArrayListFromArray(opImplArray);
            this.commonCheck();
        }

        public OpArray(ArrayList<OpImpl> arrayList, Dummy ... dummyArray) {
            this.opsList = this.getArrayListFromArrayList(arrayList);
            this.commonCheck();
        }

        ArrayList<OpProxy> getArrayListFromArray(OpImpl[] opImplArray) {
            ArrayList<OpProxy> arrayList = new ArrayList<OpProxy>(opImplArray.length);
            int n = 0;
            for (OpImpl opImpl : opImplArray) {
                if (opImpl == null) {
                    throw new NullPointerException("op " + n + " in OpArray given to " + this.classNameForErrors + " is null");
                }
                ++n;
                arrayList.add(new OpProxy(opImpl));
            }
            return arrayList;
        }

        ArrayList<OpProxy> getArrayListFromArrayList(ArrayList<OpImpl> arrayList) {
            ArrayList<OpProxy> arrayList2 = new ArrayList<OpProxy>(arrayList.size());
            for (OpImpl opImpl : arrayList) {
                arrayList2.add(new OpProxy(opImpl));
            }
            return arrayList2;
        }

        public OpArray(Quantifiers[] quantifiersArray, OpProxy[] opProxyArray) {
            this.quantsList = new ArrayList<Quantifiers>(Arrays.asList(quantifiersArray));
            this.opsList = new ArrayList<OpProxy>(Arrays.asList(opProxyArray));
            this.commonCheck();
        }

        public OpArray(ArrayList<Quantifiers> arrayList, ArrayList<OpProxy> arrayList2, Dummy ... dummyArray) {
            this.quantsList = (ArrayList)arrayList.clone();
            this.opsList = (ArrayList)arrayList2.clone();
            this.commonCheck();
        }

        public OpArray(OpProxy[] opProxyArray) {
            this.opsList = new ArrayList<OpProxy>(Arrays.asList(opProxyArray));
            this.commonCheck();
        }

        public OpArray(ArrayList<OpProxy> arrayList) {
            this.opsList = (ArrayList)arrayList.clone();
            this.commonCheck();
        }

        private void commonCheck() {
            if (this.quantsList != null && this.quantsList.size() != this.opsList.size()) {
                String string = "in constructing OpArray, size of quantifiers list (" + this.quantsList.size() + ") differs from size of op list (" + this.opsList.size() + ")";
                throw new rjRuntimeError(string);
            }
        }

        private ArrayList<Quantifiers> safeNewArrayList(ArrayList<Quantifiers> arrayList) {
            return arrayList == null ? null : (ArrayList)arrayList.clone();
        }

        private ArrayList<Quantifiers> safeNewArrayList(Quantifiers[] quantifiersArray) {
            return quantifiersArray == null ? null : new ArrayList<Quantifiers>(Arrays.asList(quantifiersArray));
        }

        ArrayList<OpProxy> getOpsList() {
            return this.opsList;
        }

        ArrayList<Quantifiers> getQuantifiersList() {
            return this.quantsList;
        }

        protected void checkQuantifiers() {
            if (this.quantsList == null) {
                return;
            }
            int n = 0;
            for (Quantifiers quantifiers : this.quantsList) {
                if (quantifiers == null) {
                    throw new NullPointerException("quantifier " + n + " in OpArray given to " + this.classNameForErrors + " is null");
                }
                ++n;
            }
        }

        protected void checkOps() {
            int n = 0;
            for (OpProxy opProxy : this.opsList) {
                if (opProxy != null) continue;
                throw new NullPointerException("op " + n + " in OpArray given to " + this.classNameForErrors + " is null");
            }
        }

        protected class Dummy {
            protected Dummy() {
            }
        }
    }
}

