/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.rj;

import edu.ucdavis.rj.OpImpl;
import edu.ucdavis.rj.OpProxy;
import edu.ucdavis.rj.Timestamp;
import edu.ucdavis.rj.rjRuntimeError;
import edu.ucdavis.rj.rjvm;
import java.io.Serializable;

public class Invocation
implements Serializable,
Cloneable {
    static final long serialVersionUID = 0L;
    private Object[] params;
    private Object returnValue;
    Timestamp timestamp;
    private OpProxy replyOp;

    public Invocation(Object ... objectArray) {
        this.params = objectArray;
        this.timestamp = new Timestamp(rjvm.getTimestamp());
    }

    public int paramsLength() {
        return this.params.length;
    }

    public Object getParam(int n) {
        return this.params[n];
    }

    public void setReturnValue(Object object) {
        this.returnValue = object;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReplyOp(OpProxy opProxy) {
        this.replyOp = opProxy;
    }

    public OpProxy getReplyOp() {
        return this.replyOp;
    }

    void replyToInvoker() {
        this.internalReplyToInvoker(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReplyToInvoker(boolean bl) {
        OpProxy opProxy;
        Invocation invocation = this;
        synchronized (invocation) {
            opProxy = this.getReplyOp();
            if (opProxy != null) {
                this.setReplyOp(null);
            }
        }
        if (opProxy != null) {
            invocation = bl ? this.safeClone() : this;
            try {
                invocation.timestamp = new Timestamp(rjvm.getTimestamp());
                opProxy.send(invocation);
            }
            catch (Exception exception) {
                throw new rjRuntimeError("RJ internal error: Invocation.replyToInvoker");
            }
        }
    }

    public void reply() {
        this.internalReplyToInvoker(true);
    }

    public void reply(Object object) {
        this.setReturnValue(object);
        this.reply();
    }

    public void forward(OpProxy opProxy, Invocation invocation) {
        this.internalForward(opProxy, invocation);
    }

    public void forward(OpImpl opImpl, Invocation invocation) {
        this.forward(new OpProxy(opImpl), invocation);
    }

    public void forward(OpProxy opProxy) {
        this.forward(opProxy, this);
    }

    public void forward(OpImpl opImpl) {
        this.forward(new OpProxy(opImpl));
    }

    private void internalForward(OpProxy opProxy, Invocation invocation) {
        OpProxy opProxy2 = this.getReplyOp();
        this.setReplyOp(null);
        Invocation invocation2 = invocation.safeClone();
        invocation2.setReplyOp(opProxy2);
        try {
            opProxy.send(invocation2);
        }
        catch (Exception exception) {
            throw new rjRuntimeError("RJ internal error: Invocation.internalForward");
        }
    }

    Timestamp getTimestamp() {
        return this.timestamp;
    }

    void setRJVMTimestamp() {
        rjvm.setTimestamp(this.getTimestamp().getTimestamp());
    }

    protected Invocation clone() throws CloneNotSupportedException {
        return (Invocation)super.clone();
    }

    Invocation safeClone() {
        Invocation invocation = null;
        try {
            invocation = this.clone();
        }
        catch (Exception exception) {
            throw new rjRuntimeError("RJ internal error: Invocation's safeClone");
        }
        return invocation;
    }
}

